/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.outline;

import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.Document;
import com.lizardtech.djvu.outline.Bookmark;
import com.lizardtech.djvubean.DjVuBean;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Outline
extends Canvas
implements PropertyChangeListener,
Serializable {
    private static final Class[] visibleParms = new Class[]{Integer.TYPE};
    public final DjVuBean djvuBean;
    private Hashtable depthMap = new Hashtable();
    private Hashtable parentMap = new Hashtable();
    private Vector activeVector = new Vector();
    private Vector pagenoVector = new Vector();
    private final Object[] visibleArgs = new Object[]{null};
    private boolean checked = false;
    private boolean firstTime = true;
    private int fontHeight = -1;
    private int fontWidth = -1;

    public Outline(DjVuBean djVuBean) {
        this.djvuBean = djVuBean;
        if (djVuBean.getDocument().size() < 2) {
            throw new ArrayIndexOutOfBoundsException("Can not navigate documents with only one page.");
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Outline.this.clickLocation(mouseEvent.getX(), mouseEvent.getY());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(DjVuOptions.err);
                    System.gc();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        Document document = djVuBean.getDocument();
        Bookmark bookmark = (Bookmark)document.getBookmark();
        bookmark.setDjVmDir(document.getDjVmDir());
        this.setFirstBookmark(bookmark);
        Properties properties = djVuBean.properties;
        ((Hashtable)properties).put("addOn.NavPane", "Outline," + properties.getProperty("addOn.NavPane", "None"));
        djVuBean.addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getBookmark(int n) {
        Vector vector;
        Vector vector2 = vector = this.getActiveVector();
        synchronized (vector2) {
            return n < vector.size() ? vector.elementAt(n) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckedItem(int n, boolean bl) {
        Vector vector;
        Vector vector2 = vector = this.getActiveVector();
        synchronized (vector2) {
            if (n < vector.size()) {
                this.setCheckedItem(n, bl, vector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckedItem(int n) {
        Vector vector;
        boolean bl = false;
        Vector vector2 = vector = this.getActiveVector();
        synchronized (vector2) {
            Bookmark bookmark;
            if (n + 1 < vector.size() && (bookmark = this.getBookmark(n)).size() > 0) {
                Bookmark bookmark2;
                Bookmark bookmark3 = this.getBookmark(n + 1);
                bl = bookmark3 == (bookmark2 = bookmark.elementAt(0));
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckedPage(int n) {
        Vector vector;
        Vector vector2 = vector = this.getActiveVector();
        synchronized (vector2) {
            Object e;
            Vector vector3 = this.getPagenoVector();
            if (n < vector3.size() && (e = vector3.elementAt(n)) != null) {
                this.setCheckedBookmark((Bookmark)e, vector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstBookmark(Bookmark bookmark) {
        Vector vector;
        Vector vector2 = vector = this.getActiveVector();
        synchronized (vector2) {
            Hashtable hashtable = this.getParentMap();
            hashtable.clear();
            Vector vector3 = this.getPagenoVector();
            vector3.setSize(0);
            this.getDepthMap().clear();
            this.mapChildren(bookmark, hashtable, vector3, new Integer(0));
            vector.setSize(0);
            vector.addElement(bookmark);
            this.setCheckedItem(0, true);
        }
    }

    public void setFontHeight(int n) {
        this.fontHeight = n;
    }

    public int getFontHeight() {
        int n = this.fontHeight;
        if (n < 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            n = fontMetrics.getHeight();
            this.setFontHeight(n);
        }
        return n;
    }

    public void setFontWidth(int n) {
        this.fontWidth = n;
    }

    public int getFontWidth() {
        int n = this.fontWidth;
        if (this.fontWidth < 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            n = fontMetrics.stringWidth("_");
            this.setFontWidth(n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize() {
        Dimension dimension = new Dimension();
        Hashtable hashtable = this.getDepthMap();
        int n = 0;
        Vector vector = this.getActiveVector();
        synchronized (vector) {
            Enumeration enumeration = this.getDepthMap().keys();
            while (enumeration.hasMoreElements()) {
                Bookmark bookmark = (Bookmark)enumeration.nextElement();
                Rectangle rectangle = this.getTextBounds(n++, bookmark, hashtable.get(bookmark));
                int n2 = rectangle.x + rectangle.width;
                if (n2 > dimension.width) {
                    dimension.width = n2;
                }
                dimension.height = rectangle.y + rectangle.height;
            }
        }
        dimension.width += 2 * this.getFontMetrics(this.getFont()).getMaxAdvance();
        dimension.height += 2 * this.getFontHeight();
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getMaximumSize();
    }

    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public int getRow(int n) {
        int n2 = this.getFontHeight();
        return n2 > 0 ? n / n2 : 0;
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            Container container = this.getParent();
            if (container != null && container.getComponentCount() == 1) {
                container.setVisible(bl);
            }
            this.invalidate();
            try {
                while (container != null) {
                    try {
                        container.getClass().getMethod("resetToPreferredSizes", null).invoke((Object)container, null);
                        this.visibleArgs[0] = new Integer(bl ? 10 : 0);
                        container.getClass().getMethod("setDividerSize", visibleParms).invoke((Object)container, this.visibleArgs);
                        break;
                    }
                    catch (Throwable throwable) {
                        container = container.getParent();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.djvuBean.recursiveRevalidate();
        }
    }

    public void clickLocation(int n, int n2) {
        int n3 = this.getRow(n2);
        Bookmark bookmark = this.getBookmark(n3);
        if (bookmark != null) {
            Rectangle rectangle = this.getCheckboxBounds(n3, bookmark, this.getDepthMap().get(bookmark));
            if (n >= rectangle.x && n2 > rectangle.y && n < rectangle.x + rectangle.width && n2 < rectangle.y + rectangle.height) {
                this.setCheckedItem(n3, !this.isCheckedItem(n3));
            } else {
                int n4;
                rectangle = this.getTextBounds(n3, bookmark, this.getDepthMap().get(bookmark));
                if (n >= rectangle.x && n2 > rectangle.y && n < rectangle.x + rectangle.width && n2 < rectangle.y + rectangle.height && (n4 = bookmark.getPageno() + 1) > 0) {
                    this.djvuBean.setPage(n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setFontWidth(fontMetrics.stringWidth("_"));
        this.setFontHeight(fontMetrics.getHeight());
        if (this.firstTime) {
            this.firstTime = false;
            this.setVisible("Outline".equalsIgnoreCase(this.djvuBean.properties.getProperty("navpane")));
        }
        if (!this.isVisible()) {
            this.getParent().setVisible(false);
            this.invalidate();
            this.djvuBean.recursiveRevalidate();
        } else {
            Vector vector = this.activeVector;
            synchronized (vector) {
                this.paintItem(0, graphics, this.getBookmark(0));
                this.paintCheckbox(0, graphics, this.getBookmark(0));
            }
        }
    }

    public int paintCheckbox(int n, Graphics graphics, Bookmark bookmark) {
        int n2 = n + 1;
        if (bookmark != null) {
            Rectangle rectangle = this.getCheckboxBounds(n, bookmark, this.getDepthMap().get(bookmark));
            int n3 = rectangle.y + rectangle.height / 2;
            int n4 = rectangle.x + rectangle.width / 2;
            Enumeration enumeration = bookmark.elements();
            if (enumeration.hasMoreElements()) {
                Bookmark bookmark2;
                Bookmark bookmark3;
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.drawLine(rectangle.x + 2, n3, rectangle.x + rectangle.width - 2, n3);
                boolean bl = true;
                while ((bookmark3 = (Bookmark)enumeration.nextElement()) == (bookmark2 = this.getBookmark(n2))) {
                    bl = false;
                    n2 = this.paintCheckbox(n2, graphics, bookmark3);
                    if (enumeration.hasMoreElements()) continue;
                }
                if (bl) {
                    graphics.drawLine(n4, rectangle.y + 2, n4, rectangle.y + rectangle.height - 2);
                }
            }
        }
        return n2;
    }

    public int paintItem(int n, Graphics graphics, Bookmark bookmark) {
        int n2 = n + 1;
        if (bookmark != null) {
            Rectangle rectangle = this.getTextBounds(n, bookmark, this.getDepthMap().get(bookmark));
            int n3 = rectangle.y + rectangle.height / 2;
            Enumeration enumeration = bookmark.elements();
            String string = bookmark.getDisplayName();
            if (string != null) {
                graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height);
            }
            if (enumeration.hasMoreElements()) {
                Bookmark bookmark2;
                Bookmark bookmark3;
                graphics.drawLine(rectangle.x - this.getFontWidth(), n3, rectangle.x - 2, n3);
                int n4 = rectangle.x - this.getFontWidth() / 2;
                int n5 = n3;
                while ((bookmark3 = (Bookmark)enumeration.nextElement()) == (bookmark2 = this.getBookmark(n2))) {
                    n5 = (2 * n2 + 1) * this.getFontHeight() / 2;
                    graphics.drawLine(n4, n5, rectangle.x - 2, n5);
                    n2 = this.paintItem(n2, graphics, bookmark3);
                    if (enumeration.hasMoreElements()) continue;
                }
                if (n5 > n3) {
                    graphics.drawLine(n4, n3, n4, n5);
                }
            } else if (string != null) {
                graphics.drawLine(rectangle.x - this.getFontWidth(), n3, rectangle.x - 2, n3);
            }
        }
        return n2;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            String string;
            String string2 = propertyChangeEvent.getPropertyName();
            if ("page".equalsIgnoreCase(string2)) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Number) {
                    this.setCheckedPage(((Number)object).intValue() - 1);
                }
            } else if ("propertyName".equalsIgnoreCase(string2) && "navpane".equalsIgnoreCase(string = (String)propertyChangeEvent.getNewValue())) {
                this.setVisible("Outline".equalsIgnoreCase(this.djvuBean.properties.getProperty(string)));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    protected Vector getActiveVector() {
        return this.activeVector;
    }

    protected Rectangle getCheckboxBounds(int n, Bookmark bookmark, Object object) {
        int n2 = object instanceof Number ? ((Number)object).intValue() : 0;
        int n3 = this.getFontWidth();
        int n4 = this.getFontHeight();
        int n5 = n3 < n4 ? n3 : n4;
        return new Rectangle(((2 * n2 + 1) * n3 - n5) / 2, ((2 * n + 1) * n4 - n5) / 2, n5, n5);
    }

    protected int setCheckedBookmark(Bookmark bookmark, Vector vector) {
        Bookmark bookmark2 = (Bookmark)this.getParentMap().get(bookmark);
        int n = 0;
        if (bookmark2 != null) {
            n = this.setCheckedBookmark(bookmark2, vector);
        }
        while (n < vector.size()) {
            Bookmark bookmark3;
            if ((bookmark3 = (Bookmark)vector.elementAt(n++)) != bookmark) continue;
            this.setCheckedItem(n - 1, true, vector);
            break;
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    protected void setCheckedItem(int var1_1, boolean var2_2, Vector var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Hashtable getDepthMap() {
        return this.depthMap;
    }

    protected Vector getPagenoVector() {
        return this.pagenoVector;
    }

    protected Hashtable getParentMap() {
        return this.parentMap;
    }

    protected Rectangle getTextBounds(int n, Bookmark bookmark, Object object) {
        int n2 = this.getFontWidth();
        int n3 = this.getFontHeight();
        String string = bookmark.getDisplayName();
        int n4 = object instanceof Number ? ((Number)object).intValue() : 0;
        return new Rectangle((n4 + 2) * n2, n * n3, string != null ? this.getFontMetrics(this.getFont()).stringWidth(string) : n2, n3);
    }

    protected void mapChildren(Bookmark bookmark, Hashtable hashtable, Vector vector, Number number) {
        Enumeration enumeration;
        this.getDepthMap().put(bookmark, number);
        int n = bookmark.getPageno();
        if (n >= 0) {
            while (n >= vector.size()) {
                vector.addElement(null);
            }
            vector.setElementAt(bookmark, n);
        }
        if ((enumeration = bookmark.elements()).hasMoreElements()) {
            Integer n2 = new Integer(number.intValue() + 1);
            do {
                Bookmark bookmark2 = (Bookmark)enumeration.nextElement();
                hashtable.put(bookmark2, bookmark);
                this.mapChildren(bookmark2, hashtable, vector, n2);
            } while (enumeration.hasMoreElements());
        }
    }
}

