/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.menu;

import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvubean.DjVuBean;
import com.lizardtech.djvubean.DjVuViewport;
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Properties;

public class DjVuMenu
extends PopupMenu
implements MouseListener,
PropertyChangeListener {
    private final ActionListener aboutListener = new Listener(4);
    private final ActionListener helpListener = new Listener(5);
    private final ActionListener navigationListener = new Listener(3);
    private final ItemListener findListener = new Listener(2);
    private final ItemListener navPaneListener = new Listener(1);
    private final Listener zoomListener = new Listener(0);
    private final Listener pageLayoutListener = new Listener(6);
    private Menu navPaneMenu = null;
    private Menu zoomMenu = null;
    private Menu pageLayoutMenu = null;
    private MenuItem aboutMenuItem = null;
    private MenuItem findMenuItem = null;
    private MenuItem helpMenuItem = null;

    public DjVuMenu(DjVuBean djVuBean) {
        djVuBean.add(this);
        djVuBean.addMouseListener(this);
        djVuBean.addPropertyChangeListener(this);
        ((Hashtable)djVuBean.properties).put("addOn.menu", djVuBean.properties.getProperty("menu", "true"));
    }

    public MenuItem getAboutMenuItem() {
        MenuItem menuItem = this.aboutMenuItem;
        if (menuItem == null) {
            menuItem = new MenuItem("About");
            menuItem.addActionListener(this.aboutListener);
            this.aboutMenuItem = menuItem;
        }
        return menuItem;
    }

    public String getAboutURL() {
        return this.getDjVuBean().properties.getProperty("abouturl", "http://javadjvu.foxtrottechnologies.com/" + "0_8_09".replace('_', '/') + "/releasenotes/");
    }

    public DjVuBean getDjVuBean() {
        return (DjVuBean)((MenuComponent)this).getParent();
    }

    public MenuItem getFindMenuItem() {
        CheckboxMenuItem checkboxMenuItem = null;
        String string = this.getDjVuBean().properties.getProperty("addOn.finder");
        if (string != null) {
            checkboxMenuItem = (CheckboxMenuItem)this.findMenuItem;
            if (checkboxMenuItem == null) {
                checkboxMenuItem = new CheckboxMenuItem("Find");
                checkboxMenuItem.addItemListener(this.findListener);
                this.findMenuItem = checkboxMenuItem;
            }
            checkboxMenuItem.setState(DjVuBean.stringToBoolean(string, false));
        }
        return checkboxMenuItem;
    }

    public MenuItem getHelpMenuItem() {
        MenuItem menuItem = this.helpMenuItem;
        if (menuItem == null) {
            menuItem = new MenuItem("Help");
            menuItem.addActionListener(this.helpListener);
            this.helpMenuItem = menuItem;
        }
        return menuItem;
    }

    public String getHelpURL() {
        return this.getDjVuBean().properties.getProperty("helpurl", "http://javadjvu.sourceforge.net");
    }

    public String getNavPane() {
        return this.getDjVuBean().properties.getProperty("navpane", "None");
    }

    public Menu getNavPaneMenu() {
        String string;
        int n;
        Menu menu = this.navPaneMenu;
        if (menu == null && (n = (string = this.getDjVuBean().properties.getProperty("addOn.NavPane", "None")).indexOf(44)) >= 0) {
            CheckboxMenuItem checkboxMenuItem;
            String string2;
            menu = new Menu("Navigation Pane");
            int n2 = 0;
            do {
                string2 = string.substring(n2, n);
                checkboxMenuItem = new CheckboxMenuItem(string2);
                checkboxMenuItem.addItemListener(this.navPaneListener);
                menu.add(checkboxMenuItem);
            } while ((n = string.indexOf(44, n2 = n + 1)) >= 0);
            string2 = string.substring(n2);
            checkboxMenuItem = new CheckboxMenuItem(string2);
            checkboxMenuItem.addItemListener(this.navPaneListener);
            menu.add(checkboxMenuItem);
            this.navPaneMenu = menu;
        }
        return menu;
    }

    public Menu getZoomMenu() {
        Menu menu = this.zoomMenu;
        if (menu == null) {
            MenuItem menuItem;
            menu = new Menu("Zoom");
            int n = 0;
            while (n < DjVuBean.ZOOM_STANDARD_LIST.length) {
                menuItem = new CheckboxMenuItem(DjVuBean.ZOOM_STANDARD_LIST[n++]);
                ((CheckboxMenuItem)menuItem).addItemListener(this.zoomListener);
                menu.add(menuItem);
            }
            menu.addSeparator();
            n = 0;
            while (n < DjVuBean.ZOOM_SPECIAL_LIST.length) {
                menuItem = new CheckboxMenuItem(DjVuBean.ZOOM_SPECIAL_LIST[n++]);
                ((CheckboxMenuItem)menuItem).addItemListener(this.zoomListener);
                menu.add(menuItem);
            }
            menu.addSeparator();
            n = 0;
            while (n < DjVuBean.ZOOM_BUTTON_LIST.length) {
                menuItem = new MenuItem(DjVuBean.ZOOM_BUTTON_LIST[n++]);
                menuItem.addActionListener(this.zoomListener);
                menu.add(menuItem);
            }
            this.zoomMenu = menu;
        }
        return menu;
    }

    public Menu getPageLayoutMenu() {
        Menu menu = this.pageLayoutMenu;
        if (menu == null) {
            menu = new Menu("Page Layout");
            int n = 0;
            while (n < DjVuBean.PAGE_LAYOUT_LIST.length) {
                CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(DjVuBean.PAGE_LAYOUT_LIST[n++]);
                checkboxMenuItem.addItemListener(this.pageLayoutListener);
                menu.add(checkboxMenuItem);
            }
            this.pageLayoutMenu = menu;
        }
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.getItemCount() == 0) {
            DjVuMenu djVuMenu = this;
            synchronized (djVuMenu) {
                if (this.getItemCount() == 0) {
                    Object object;
                    MenuItem menuItem;
                    int n;
                    DjVuBean djVuBean = this.getDjVuBean();
                    Menu menu = this.getZoomMenu();
                    if (menu != null) {
                        this.add(menu);
                        DjVuMenu.updateMenu(menu, djVuBean.getZoom());
                    }
                    if ((n = djVuBean.getDocumentSize()) > 1) {
                        this.createNavigation(n);
                        menuItem = this.getNavPaneMenu();
                        if (menuItem != null) {
                            this.add(menuItem);
                            DjVuMenu.updateMenu((Menu)menuItem, this.getNavPane());
                        }
                        if ((object = this.getPageLayoutMenu()) != null) {
                            this.add((MenuItem)object);
                            DjVuMenu.updateMenu((Menu)object, djVuBean.getPageLayout());
                        }
                    }
                    if ((menuItem = this.getFindMenuItem()) != null) {
                        this.addSeparator();
                        this.add(menuItem);
                    }
                    object = this.getHelpURL();
                    String string = this.getAboutURL();
                    if (object != null && ((String)object).length() > 0) {
                        this.addSeparator();
                        this.add(this.getHelpMenuItem());
                        if (string != null && string.length() > 0) {
                            this.add(this.getAboutMenuItem());
                        }
                    } else if (string != null && string.length() > 0) {
                        this.addSeparator();
                        this.add(this.getAboutMenuItem());
                    }
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            DjVuBean djVuBean = this.getDjVuBean();
            if ((mouseEvent.getModifiers() & 0xFFFFFFEF) != 0) {
                if (DjVuBean.stringToBoolean(djVuBean.properties.getProperty("menu"), true)) {
                    this.init();
                    if (djVuBean instanceof DjVuViewport) {
                        Point point = ((DjVuViewport)djVuBean).getScrollPosition();
                        this.show(djVuBean, mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
                    } else {
                        this.show(djVuBean, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block14: {
            try {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("zoom")) {
                    DjVuMenu.updateMenu(this.getZoomMenu(), (String)propertyChangeEvent.getNewValue());
                    break block14;
                }
                if (!string.equals("propertyName")) break block14;
                String string2 = (String)propertyChangeEvent.getNewValue();
                if ("HelpURL".equalsIgnoreCase(string2)) {
                    DjVuMenu djVuMenu = this;
                    synchronized (djVuMenu) {
                        this.removeAll();
                        break block14;
                    }
                }
                if ("AboutURL".equalsIgnoreCase(string2)) {
                    DjVuMenu djVuMenu = this;
                    synchronized (djVuMenu) {
                        this.removeAll();
                        break block14;
                    }
                }
                if ("NavPane".equalsIgnoreCase(string2)) {
                    DjVuMenu.updateMenu(this.getNavPaneMenu(), this.getNavPane());
                } else if ("pagelayout".equalsIgnoreCase(string2)) {
                    DjVuMenu.updateMenu(this.getPageLayoutMenu(), (String)propertyChangeEvent.getNewValue());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(DjVuOptions.err);
                System.gc();
            }
        }
    }

    private static void updateMenu(Menu menu, String string) {
        if (menu != null && string != null) {
            int n = menu.getItemCount();
            while (n-- > 0) {
                MenuItem menuItem = menu.getItem(n);
                if (!(menuItem instanceof CheckboxMenuItem)) continue;
                CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)menuItem;
                boolean bl = checkboxMenuItem.getState();
                boolean bl2 = string.equalsIgnoreCase(menuItem.getLabel());
                if (bl2 == bl) continue;
                checkboxMenuItem.setState(bl2);
            }
        }
    }

    private void createNavigation(int n) {
        MenuItem menuItem;
        MenuItem[] menuItemArray = new MenuItem[n];
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            menuItem = new MenuItem(Integer.toString(n3++));
            menuItem.addActionListener(this.navigationListener);
            menuItemArray[n2++] = menuItem;
        }
        Menu menu = this.createPageMenu(n, 10, menuItemArray, n);
        menu.addSeparator();
        n3 = 0;
        while (n3 < DjVuBean.NAVIGATE_LIST.length) {
            menuItem = new MenuItem(DjVuBean.NAVIGATE_LIST[n3++]);
            menuItem.addActionListener(this.navigationListener);
            menu.add(menuItem);
        }
        this.insert(menu, 0);
    }

    private Menu createPageMenu(int n, int n2, MenuItem[] menuItemArray, int n3) {
        if (n3 < 2) {
            menuItemArray[0].setLabel("Navigate");
            return (Menu)menuItemArray[0];
        }
        int n4 = (n3 + 7) / 10;
        MenuItem[] menuItemArray2 = n2 == 10 ? new MenuItem[n4] : menuItemArray;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        while (n5 < n4) {
            if (n5 + 1 == n4) {
                n7 = n3;
                n9 = n;
            } else {
                n7 += 10;
                n9 += n2;
            }
            Menu menu = new Menu(n8 + "-" + n9);
            do {
                menu.add(menuItemArray[n6++]);
            } while (n6 < n7);
            menuItemArray2[n5++] = menu;
            n8 += n2;
        }
        return this.createPageMenu(n, n2 * 10, menuItemArray2, n4);
    }

    private class Listener
    implements ItemListener,
    ActionListener {
        private final int listener;

        public Listener(int n) {
            this.listener = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DjVuBean djVuBean = DjVuMenu.this.getDjVuBean();
                switch (this.listener) {
                    case 0: {
                        djVuBean.setZoom(((MenuItem)actionEvent.getSource()).getLabel());
                        break;
                    }
                    case 3: {
                        djVuBean.setPageString(((MenuItem)actionEvent.getSource()).getLabel());
                        break;
                    }
                    case 4: {
                        djVuBean.setSubmit(DjVuMenu.this.getAboutURL());
                        break;
                    }
                    case 5: {
                        djVuBean.setSubmit(DjVuMenu.this.getHelpURL());
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(DjVuOptions.err);
                System.gc();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
                String string = checkboxMenuItem.getLabel();
                DjVuBean djVuBean = DjVuMenu.this.getDjVuBean();
                switch (this.listener) {
                    case 6: {
                        if (checkboxMenuItem.getState()) {
                            Menu menu = DjVuMenu.this.getPageLayoutMenu();
                            int n = menu.getItemCount();
                            while (n-- > 0) {
                                MenuItem menuItem = menu.getItem(n);
                                if (!(menuItem instanceof CheckboxMenuItem) || checkboxMenuItem == menuItem) continue;
                                ((CheckboxMenuItem)menuItem).setState(false);
                            }
                            djVuBean.setPageLayout(checkboxMenuItem.getLabel());
                            break;
                        }
                        if (!djVuBean.getPageLayout().equals(string)) break;
                        checkboxMenuItem.setState(true);
                        break;
                    }
                    case 0: {
                        if (checkboxMenuItem.getState()) {
                            djVuBean.setZoom(checkboxMenuItem.getLabel());
                            break;
                        }
                        if (!djVuBean.getZoom().equals(string)) break;
                        checkboxMenuItem.setState(true);
                        break;
                    }
                    case 1: {
                        Properties properties = djVuBean.properties;
                        if (checkboxMenuItem.getState()) {
                            ((Hashtable)properties).put("navpane", string);
                            break;
                        }
                        if (!properties.getProperty("navpane", "None").equalsIgnoreCase(string)) break;
                        checkboxMenuItem.setState(true);
                        break;
                    }
                    case 2: {
                        ((Hashtable)djVuBean.properties).put("addOn.finder", checkboxMenuItem.getState() ? "true" : "false");
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(DjVuOptions.err);
                System.gc();
            }
        }
    }
}

