/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.anno;

import com.lizardtech.djvu.DjVuInfo;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.DjVuPage;
import com.lizardtech.djvu.anno.DjVuAnno;
import com.lizardtech.djvu.anno.Poly;
import com.lizardtech.djvu.anno.Rect;
import com.lizardtech.djvubean.DjVuBean;
import com.lizardtech.djvubean.DjVuImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import java.util.Vector;

public class AnnoManager
extends MouseAdapter
implements MouseMotionListener {
    protected final DjVuBean djvuBean;
    private Vector[] map_area = null;
    private DjVuImage image = null;
    private Rect mapRect = null;
    private int mapRectIndex = -1;
    static /* synthetic */ Class class$com$lizardtech$djvubean$anno$AnnoManager;

    public AnnoManager(DjVuBean djVuBean) {
        this.djvuBean = djVuBean;
        ((Hashtable)djVuBean.properties).put("addOn.anno", (class$com$lizardtech$djvubean$anno$AnnoManager == null ? (class$com$lizardtech$djvubean$anno$AnnoManager = AnnoManager.class$("com.lizardtech.djvubean.anno.AnnoManager")) : class$com$lizardtech$djvubean$anno$AnnoManager).getName());
        this.djvuBean.addMouseListener(this);
        this.djvuBean.addMouseMotionListener(this);
    }

    private void setMapRect(int n, int n2) {
        Vector vector = this.getMapArea(0);
        DjVuImage djVuImage = this.image;
        if (djVuImage != null) {
            Dimension dimension = djVuImage.getBorderNW();
            int n3 = djVuImage.getIndexMax();
            double d = 1.0 / djVuImage.getHorizontalScale();
            double d2 = 1.0 / djVuImage.getVerticalScale();
            int n4 = 0;
            while (true) {
                Rectangle rectangle;
                if ((rectangle = djVuImage.getPageBounds(n4)) != null && vector != null && vector.size() > 0) {
                    int n5 = dimension.width + rectangle.x;
                    int n6 = dimension.height + rectangle.y;
                    int n7 = n5 + rectangle.width;
                    int n8 = n6 + rectangle.height;
                    if (n >= n5 && n < n7 && n2 >= n6 && n2 < n8) {
                        DjVuInfo djVuInfo = djVuImage.getDjVuInfo(n4);
                        n = (int)((double)(n - n5) * (double)djVuInfo.dpi * d);
                        n2 = djVuInfo.height - (int)((double)(n2 - n6) * (double)djVuInfo.dpi * d2);
                        int n9 = vector.size();
                        while (n9-- > 0) {
                            Rect rect = (Rect)vector.elementAt(n9);
                            if (!rect.contains(n, n2)) continue;
                            this.setMapRect(n4, rect);
                            return;
                        }
                    }
                }
                if (++n4 >= n3) break;
                vector = this.getMapArea(n4);
            }
        }
        this.setMapRect(-1, null);
    }

    public Vector getMapArea(int n) {
        Vector[] vectorArray;
        DjVuImage djVuImage = this.djvuBean.getImage();
        if (djVuImage != this.image) {
            this.image = djVuImage;
            this.map_area = null;
            this.mapRect = null;
        }
        if ((vectorArray = this.map_area) == null && djVuImage != null) {
            int n2 = djVuImage.getIndexMax();
            vectorArray = new Vector[n2];
            for (int i = 0; i < n2; ++i) {
                vectorArray[i] = null;
                Rectangle rectangle = djVuImage.getPageBounds(i);
                if (rectangle != null) {
                    DjVuInfo djVuInfo = djVuImage.getDjVuInfo(i);
                    DjVuPage djVuPage = djVuImage.getDjVuPage(i);
                    DjVuAnno djVuAnno = (DjVuAnno)djVuPage.waitForCodec(djVuPage.annoLock, 0L);
                    if (djVuAnno != null) {
                        Vector vector = djVuAnno.getMapArea();
                        int n3 = vector.size();
                        while (n3-- > 0) {
                            Rect rect = (Rect)vector.elementAt(n3);
                            rect.setPageSize(djVuInfo.width, djVuInfo.height, rectangle.width, rectangle.height);
                        }
                        vectorArray[i] = vector;
                    }
                }
                this.map_area = vectorArray;
            }
        }
        return vectorArray[n];
    }

    private boolean switchColor(Graphics graphics, int n) {
        boolean bl = false;
        if (graphics != null) {
            switch (n) {
                case -1: {
                    graphics.setColor(DjVuImage.BLACK);
                    graphics.setPaintMode();
                    break;
                }
                case -16777216: {
                    graphics.setColor(DjVuImage.BLACK);
                    if (DjVuImage.BROKEN_XOR) {
                        graphics.setPaintMode();
                    } else {
                        graphics.setXORMode(DjVuImage.WHITE);
                    }
                    bl = true;
                    break;
                }
                default: {
                    graphics.setColor(new Color(n));
                    graphics.setPaintMode();
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        double d = n3 - n;
        double d2 = n4 - n2;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (n5 <= 1 || d3 < 4.0) {
            graphics.drawLine(n, n2, n3, n4);
            if (bl) {
                if (d3 > 4.0) {
                    d *= 4.0 / d3;
                    d2 *= 4.0 / d3;
                }
                graphics.drawLine(n3, n4, n3 - (int)(d + d2), n4 - (int)(d2 - d));
                graphics.drawLine(n3, n4, n3 - (int)(d - d2), n4 - (int)(d2 + d));
            }
        } else {
            double d4 = (double)n5 / (2.0 * d3);
            double d5 = (double)n - d4 * d2;
            double d6 = (double)n2 + d4 * d;
            double d7 = (double)n3 - d4 * d2;
            double d8 = (double)n4 + d4 * d;
            double d9 = (double)n3 + d4 * d2;
            double d10 = (double)n4 - d4 * d;
            double d11 = (double)n + d4 * d2;
            double d12 = (double)n2 - d4 * d;
            if (bl) {
                double d13 = d7 - 4.0 * d4 * d;
                double d14 = d8 - 4.0 * d4 * d2;
                double d15 = d13 - 4.0 * (d + d2) / d3;
                double d16 = d14 - 4.0 * (d2 - d) / d3;
                double d17 = d15 - d13;
                double d18 = d16 - d14;
                double d19 = Math.sqrt(d17 * d17 + d18 * d18);
                double d20 = (double)n5 / d19;
                double d21 = d15 + d20 * d18;
                double d22 = d16 - d20 * d17;
                double d23 = d9 - 4.0 * d4 * d;
                double d24 = d10 - 4.0 * d4 * d2;
                double d25 = d23 - 4.0 * (d - d2) / d3;
                double d26 = d24 - 4.0 * (d2 + d) / d3;
                d17 = d25 - d23;
                d18 = d26 - d24;
                d19 = Math.sqrt(d17 * d17 + d18 * d18);
                d20 = (double)n5 / d19;
                double d27 = d25 - d20 * d18;
                double d28 = d26 + d20 * d17;
                int[] nArray = new int[]{(int)d5, (int)d13, (int)d15, (int)d21, n3, (int)d27, (int)d25, (int)d23, (int)d11};
                int[] nArray2 = new int[]{(int)d6, (int)d14, (int)d16, (int)d22, n4, (int)d28, (int)d26, (int)d24, (int)d12};
                graphics.fillPolygon(nArray, nArray2, nArray.length);
            } else {
                int[] nArray = new int[]{(int)d5, (int)d7, (int)d9, (int)d11};
                int[] nArray3 = new int[]{(int)d6, (int)d8, (int)d10, (int)d12};
                graphics.fillPolygon(nArray, nArray3, nArray.length);
            }
        }
    }

    public void draw(Graphics graphics) {
        Vector vector = this.getMapArea(0);
        DjVuImage djVuImage = this.image;
        if (djVuImage != null) {
            int n = djVuImage.getIndexMax();
            int n2 = 0;
            while (true) {
                Rectangle rectangle = djVuImage.getPageBounds(n2);
                if (vector != null && rectangle != null) {
                    Graphics graphics2 = graphics.create();
                    Dimension dimension = djVuImage.getBorderNW();
                    graphics2.translate(dimension.width + rectangle.x, dimension.height + rectangle.y);
                    graphics2.setColor(DjVuImage.BLUE);
                    int n3 = vector.size();
                    while (n3-- > 0) {
                        Rect rect = (Rect)vector.elementAt(n3);
                        int[] nArray = rect.getXCoordinates();
                        int[] nArray2 = rect.getYCoordinates();
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        if (nArray.length == 2) {
                            n4 = nArray[0] < nArray[1] ? nArray[0] : nArray[1];
                            n6 = nArray[0] > nArray[1] ? nArray[0] : nArray[1];
                            n5 = nArray2[0] < nArray2[1] ? nArray2[0] : nArray2[1];
                            n7 = nArray2[0] > nArray2[1] ? nArray2[0] : nArray2[1];
                            djVuImage.fillRect(graphics2, rect.getHiliteColor(), rect.getOpacity(), n4, n5, n6, n7);
                        }
                        if (rect.isVisible()) {
                            String string;
                            int n8;
                            if (nArray.length == 2) {
                                djVuImage.fillRect(graphics2, rect.getBgColor(), 100, n4, n5, n6, n7);
                            }
                            if ((n8 = rect.getBorderType()) != 0) {
                                switch (n8) {
                                    case 2: {
                                        this.switchColor(graphics2, rect.getBorderColor());
                                        break;
                                    }
                                    default: {
                                        this.switchColor(graphics2, -16777216);
                                    }
                                }
                                if (rect.getMapType() == 2) {
                                    if (((Poly)rect).isOpen()) {
                                        graphics2.drawPolyline(nArray, nArray2, nArray.length);
                                    } else {
                                        graphics2.drawPolygon(nArray, nArray2, nArray.length);
                                    }
                                } else if (rect.getMapType() == 1) {
                                    graphics2.drawOval(n4, n5, n6 - n4, n7 - n5);
                                } else {
                                    graphics2.drawRect(n4, n5, n6 - n4, n7 - n5);
                                }
                            }
                            if (nArray.length == 2 && rect.isPushpin()) {
                                graphics2.setColor(DjVuImage.BLACK);
                                graphics2.setPaintMode();
                                this.drawLine(graphics2, n4 + 1, n5 + 1, n4 + 8, n5 + 8, 3, false);
                                this.drawLine(graphics2, n4, n5 + 1, n4 + 6, n5 + 1, 3, false);
                                this.drawLine(graphics2, n4 + 1, n5 + 1, n4 + 1, n5 + 6, 3, false);
                            }
                            if (rect.getMapType() == 3 && (string = rect.getComment()) != null && this.switchColor(graphics2, rect.getTextColor())) {
                                FontMetrics fontMetrics = graphics2.getFontMetrics();
                                char[] cArray = string.toCharArray();
                                int n9 = 0;
                                for (int i = n5 + fontMetrics.getHeight() + (rect.isPushpin() ? 10 : 0); n9 < cArray.length && i < n7; i += fontMetrics.getHeight()) {
                                    int n10;
                                    int n11 = n4 + 4;
                                    int n12 = n4 + fontMetrics.charWidth(cArray[n9]);
                                    int n13 = n9;
                                    for (n10 = n9 + 1; n10 < cArray.length; ++n10) {
                                        char c = cArray[n10];
                                        n12 += fontMetrics.charWidth(c);
                                        if (Character.isWhitespace(c)) {
                                            n13 = n10;
                                        }
                                        if (n12 > n6 - 4) break;
                                    }
                                    if (n10 < cArray.length && n13 > n9) {
                                        n10 = n13 + 1;
                                    }
                                    graphics2.drawChars(cArray, n9, n10 - n9, n11, i);
                                    n9 = n10;
                                }
                            }
                        } else if (nArray.length == 2 && rect.isPushpin()) {
                            graphics2.setColor(DjVuImage.BLACK);
                            graphics2.setPaintMode();
                            this.drawLine(graphics2, n4 + 8, n5 + 8, n4 + 1, n5 + 1, 3, false);
                            this.drawLine(graphics2, n4 + 9, n5 + 8, n4 + 3, n5 + 8, 3, false);
                            this.drawLine(graphics2, n4 + 8, n5 + 9, n4 + 8, n5 + 3, 3, false);
                        }
                        if (rect.getMapType() != 4 || !this.switchColor(graphics2, rect.getLineColor())) continue;
                        this.drawLine(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], rect.getLineWidth(), rect.isArrow());
                    }
                    graphics2.dispose();
                }
                if (++n2 >= n) break;
                vector = this.getMapArea(n2);
            }
        }
    }

    public Rect getMapRect() {
        return this.mapRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapRect(int n, Rect rect) {
        Vector vector = this.getMapArea(0);
        DjVuImage djVuImage = this.image;
        if (djVuImage == null || vector == null) {
            this.mapRect = null;
            return;
        }
        if (rect != this.mapRect) {
            AnnoManager annoManager = this;
            synchronized (annoManager) {
                if (rect != this.mapRect) {
                    Rectangle rectangle = null;
                    if (this.mapRect != null && this.mapRect.isVisible() && !this.mapRect.isPushpin()) {
                        this.mapRect.setVisible(false);
                        rectangle = new Rectangle();
                        djVuImage.transformRectangle(this.mapRectIndex, this.mapRect.getBounds(), rectangle);
                    }
                    this.mapRect = rect;
                    this.mapRectIndex = n;
                    if (rect != null && !rect.isPushpin() && !rect.isVisible()) {
                        rect.setVisible(true);
                        Rectangle rectangle2 = new Rectangle();
                        djVuImage.transformRectangle(n, rect.getBounds(), rectangle2);
                        if (rectangle != null) {
                            rectangle.union(rectangle2);
                        } else {
                            rectangle = rectangle2;
                        }
                    }
                    if (rectangle != null) {
                        rectangle.setBounds(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
                        this.djvuBean.repaintImageCoordinates(rectangle);
                    }
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            Rect rect;
            if ((mouseEvent.getModifiers() & 0xFFFFFFEF) == 0 && (rect = this.getMapRect()) != null) {
                if (rect.isPushpin()) {
                    rect.setVisible(!rect.isVisible());
                    Rectangle rectangle = new Rectangle();
                    this.image.transformRectangle(this.mapRectIndex, rect.getBounds(), rectangle);
                    rectangle.setBounds(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
                    this.djvuBean.repaintImageCoordinates(rectangle);
                } else {
                    String string = rect.getURL();
                    if (string != null && string.length() > 0) {
                        int n = this.djvuBean.getDocument().getPageno(string);
                        if (n >= 0) {
                            this.djvuBean.setPage(n + 1);
                        } else {
                            this.djvuBean.setSubmit(this.getMapRect());
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            if (!this.djvuBean.isDecoding()) {
                this.setMapRect(mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

