/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean;

import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvubean.DjVuBean;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class ZoomMode
implements MouseListener,
MouseMotionListener {
    protected final DjVuBean djvuBean;
    protected final Point last = new Point();
    protected Point start = null;
    protected final Rectangle select = new Rectangle();

    public ZoomMode(DjVuBean djVuBean) {
        this.djvuBean = djVuBean;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.djvuBean.requestFocus();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.start != null) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.last.x != n || this.last.y != n2) {
                int n3 = n <= this.start.x ? n : this.start.x;
                int n4 = n2 <= this.start.y ? n2 : this.start.y;
                int n5 = n <= this.start.x ? this.start.x - n : n - this.start.x;
                int n6 = n2 <= this.start.y ? this.start.y - n2 : n2 - this.start.y;
                this.select.setBounds(n3, n4, n5, n6);
                this.djvuBean.setSelect(this.select);
                this.last.setLocation(n, n2);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.djvuBean.requestFocus();
            this.start = new Point(mouseEvent.getX(), mouseEvent.getY());
            this.last.setLocation(this.start);
            this.select.setBounds(this.start.x, this.start.y, 0, 0);
            this.djvuBean.addMouseMotionListener(this);
            this.djvuBean.setSelect(this.select);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            this.start = null;
            this.djvuBean.removeMouseMotionListener(this);
            this.djvuBean.zoomSelect();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }
}

