/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean;

import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvubean.DjVuBean;
import com.lizardtech.djvubean.DjVuImage;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;

public class DjVuViewport
extends DjVuBean
implements AdjustmentListener {
    private Point scrollPosition = new Point();
    private Scrollbar hScroll = null;
    private Scrollbar vScroll = null;

    public void setImageSize(int n, int n2) {
        DjVuImage djVuImage = this.getImageWait();
        Dimension dimension = djVuImage.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (n != n3 || n2 != n4) {
            this.zoom = 0;
            if ((djVuImage = djVuImage.getScaledInstance(n, n2)) != null) {
                n = djVuImage.getBounds().width;
                n2 = djVuImage.getBounds().height;
                this.setImage(djVuImage);
            }
            this.scaleScrollPosition(n3, n4, n, n2);
            this.recursiveRevalidate();
        }
    }

    public Dimension getMaximumSize() {
        return this.getMaximumPanelSize();
    }

    public Dimension getMinimumSize() {
        return this.getMinimumPanelSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumPanelSize();
    }

    public void setScrollPosition(int n, int n2) {
        DjVuImage djVuImage = this.getImage();
        if (djVuImage != null && (n != this.scrollPosition.x || n2 != this.scrollPosition.y)) {
            Dimension dimension = djVuImage.getSize();
            Dimension dimension2 = this.getViewportSize();
            n = Math.max(0, Math.min(dimension.width - dimension2.width, n));
            n2 = Math.max(0, Math.min(dimension.height - dimension2.height, n2));
            if (n != this.scrollPosition.x || n2 != this.scrollPosition.y) {
                this.scrollPosition.setLocation(n, n2);
                this.updateScrollbars();
                this.repaint(50L);
            }
        }
    }

    public Point getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollbar(int n, Scrollbar scrollbar) {
        if (n == 0) {
            this.hScroll = scrollbar;
        } else {
            this.vScroll = scrollbar;
        }
        scrollbar.addAdjustmentListener(this);
        this.updateScrollbars();
    }

    public Scrollbar getScrollbar(int n) {
        return n == 0 ? this.hScroll : this.vScroll;
    }

    public void setSize(int n, int n2) {
        this.setPanelSize(n, n2);
    }

    public void setURL(URL uRL) throws IOException {
        URL uRL2 = this.getURL();
        super.setURL(uRL);
        if (uRL2 == null) {
            this.setScrollbar(0, new Scrollbar(0));
            this.setScrollbar(1, new Scrollbar(1));
            this.hScroll.setUnitIncrement(16);
            this.vScroll.setUnitIncrement(16);
        }
    }

    public void setViewportSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public Dimension getViewportSize() {
        return this.getSize();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        try {
            Scrollbar scrollbar = this.getScrollbar(0);
            Scrollbar scrollbar2 = this.getScrollbar(1);
            Point point = this.getScrollPosition();
            this.setScrollPosition(scrollbar != null ? scrollbar.getValue() : point.x, scrollbar2 != null ? scrollbar2.getValue() : point.y);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.updateScrollbars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        Point point = this.getScrollPosition();
        graphics.translate(-point.x, -point.y);
        try {
            super.paintComponent(graphics);
        }
        finally {
            graphics.translate(point.x, point.y);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        try {
            Point point;
            if (aWTEvent instanceof MouseEvent && (point = this.getScrollPosition()) != null) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                aWTEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
        super.processEvent(aWTEvent);
    }

    public void run() {
        super.run();
        this.updateScrollbars();
    }

    private void updateScrollbars() {
        DjVuImage djVuImage = this.getImage();
        if (djVuImage != null) {
            Dimension dimension = this.getViewportSize();
            Dimension dimension2 = djVuImage.getSize();
            Point point = this.getScrollPosition();
            Scrollbar scrollbar = this.getScrollbar(0);
            Scrollbar scrollbar2 = this.getScrollbar(1);
            if (scrollbar != null) {
                scrollbar.setValues(point.x, dimension.width, 0, dimension2.width);
            }
            if (scrollbar2 != null) {
                scrollbar2.setValues(point.y, dimension.height, 0, dimension2.height);
            }
        }
    }
}

