/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean;

import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInfo;
import com.lizardtech.djvu.DjVuPage;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvubean.DjVuFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class DjVuImage {
    public static boolean BROKEN_XOR = System.getProperty("os.name").equalsIgnoreCase("Mac OS X");
    public static Color WHITE = new Color(255, 255, 255);
    public static Color BLUE = new Color(0, 0, 255);
    public static Color BLACK = new Color(0, 0, 0);
    public static final int FIT_WIDTH = -1;
    public static final int FIT_PAGE = -2;
    public static final Constructor colorConstructor;
    public static final int XOR_HILITE = -16777216;
    private final Dimension borderNW = new Dimension();
    private final Dimension borderSE = new Dimension();
    private final DjVuPage[] djvuPageArray;
    private final DjVuInfo[] infoArray;
    private final Rectangle[] boundArray;
    private final Rectangle filterBounds = new Rectangle();
    private final DjVuFilter[] filterArray;
    private final boolean favorFast;
    private Rectangle targetBounds = null;
    private final double sWidth;
    private final double sHeight;
    private final int dpi;
    private Rectangle highlightBounds = new Rectangle();
    private double highlightXmin = 0.0;
    private double highlightYmin = 0.0;
    private double highlightXmax = 0.0;
    private double highlightYmax = 0.0;
    private Vector highlightList = new Vector();
    static /* synthetic */ Class class$java$awt$Color;

    public DjVuImage(DjVuPage[] djVuPageArray, boolean bl) {
        this.djvuPageArray = djVuPageArray;
        this.infoArray = new DjVuInfo[djVuPageArray.length];
        this.boundArray = new Rectangle[djVuPageArray.length];
        this.filterArray = new DjVuFilter[djVuPageArray.length];
        double d = 0.0;
        double d2 = 0.0;
        int n = 25;
        for (int i = 0; i < djVuPageArray.length; ++i) {
            DjVuInfo djVuInfo;
            this.infoArray[i] = null;
            this.boundArray[i] = null;
            this.filterArray[i] = null;
            DjVuPage djVuPage = djVuPageArray[i];
            if (djVuPage == null) continue;
            this.infoArray[i] = djVuInfo = djVuPage.getInfoWait();
            d += (double)djVuInfo.width / (double)djVuInfo.dpi;
            double d3 = (double)djVuInfo.height / (double)djVuInfo.dpi;
            if (d3 > d2) {
                d2 = d3;
            }
            if (djVuInfo.dpi <= n) continue;
            n = djVuInfo.dpi;
        }
        this.sWidth = d;
        this.sHeight = d2;
        this.dpi = n;
        this.favorFast = bl;
    }

    public DjVuImage(DjVuPage[] djVuPageArray, boolean bl, int n, Dimension dimension) {
        this(djVuPageArray, bl);
        this.setTargetBounds(this.computeScaledBounds(n, dimension));
    }

    public DjVuImage(DjVuPage[] djVuPageArray, boolean bl, int n, int n2) {
        this(djVuPageArray, bl);
        this.setTargetBounds(new Rectangle(0, 0, n, n2));
    }

    public static Color createColor(int n, int n2) {
        Color color = null;
        if (n2 > 254) {
            color = new Color(n);
        } else if (colorConstructor != null) {
            try {
                Object[] objectArray = new Object[]{new Integer(n & 0xFFFFFF | n2 << 24 & 0xFF000000), Boolean.TRUE};
                color = (Color)colorConstructor.newInstance(objectArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return color;
    }

    private void setTargetBounds(Rectangle rectangle) {
        this.targetBounds = rectangle;
        int n = 0;
        int n2 = 0;
        double d = (double)rectangle.width / this.sWidth;
        double d2 = (double)rectangle.height / this.sHeight;
        for (int i = 0; i < this.infoArray.length; ++i) {
            DjVuInfo djVuInfo = this.infoArray[i];
            if (djVuInfo == null) continue;
            int n3 = (int)Math.ceil(d * (double)djVuInfo.width / (double)djVuInfo.dpi - 1.0E-5);
            int n4 = (int)Math.ceil(d2 * (double)djVuInfo.height / (double)djVuInfo.dpi - 1.0E-5);
            this.boundArray[i] = new Rectangle(n, n2, n3, n4);
            n += n3;
        }
    }

    public double getVerticalScale() {
        return (double)this.getBounds().height / this.sHeight;
    }

    public double getHorizontalScale() {
        return (double)this.getBounds().width / this.sWidth;
    }

    public int getMaxDPI() {
        return this.dpi;
    }

    public Rectangle computeScaledBounds(int n, Dimension dimension) {
        double d = this.dpi;
        double d2 = this.sWidth * d;
        double d3 = this.sHeight * d;
        switch (n) {
            case -1: {
                double d4 = (double)dimension.width / d2;
                if (this.favorFast && d4 < 1.0) {
                    d4 = 1.0 / Math.ceil(1.0 / d4);
                    d2 *= d4;
                } else {
                    d2 = dimension.width;
                }
                d3 *= d4;
                break;
            }
            case -2: {
                double d5;
                double d6 = (double)dimension.width / d2;
                double d7 = (double)dimension.height / d3;
                double d8 = d5 = d6 < d7 ? d6 : d7;
                if (this.favorFast && d5 < 1.0) {
                    d5 = 1.0 / Math.ceil(1.0 / d5);
                }
                d2 *= d5;
                d3 *= d5;
                break;
            }
            case 0: {
                break;
            }
            default: {
                double d9 = (double)(n < 1 ? 1 : n) / d;
                d2 *= d9;
                d3 *= d9;
                break;
            }
        }
        return new Rectangle(0, 0, (int)Math.ceil(d2), (int)Math.ceil(d3));
    }

    public Dimension getBorderNW() {
        return this.borderNW;
    }

    public Dimension getBorderSE() {
        return this.borderSE;
    }

    public Rectangle getPageBounds(int n) {
        if (this.targetBounds == null) {
            this.getBounds();
        }
        return this.boundArray[n];
    }

    public boolean isDecoding() {
        for (int i = 0; i < this.djvuPageArray.length; ++i) {
            DjVuPage djVuPage = this.djvuPageArray[i];
            if (djVuPage == null || !djVuPage.isDecoding()) continue;
            return true;
        }
        return false;
    }

    public DjVuPage getDjVuPage(int n) {
        return this.djvuPageArray[n];
    }

    public boolean isDoneDecodingEvent(PropertyChangeListener propertyChangeListener, PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return !this.isDecoding();
        }
        for (int i = 0; i < this.djvuPageArray.length; ++i) {
            DjVuPage djVuPage = this.djvuPageArray[i];
            if (djVuPage == null || !djVuPage.equals(propertyChangeEvent.getSource())) continue;
            return propertyChangeEvent.getPropertyName().equals(djVuPage.doneLock);
        }
        return false;
    }

    public static boolean isDoneDecodingEvent(DjVuImage djVuImage, PropertyChangeListener propertyChangeListener, PropertyChangeEvent propertyChangeEvent) {
        return djVuImage != null && djVuImage.isDoneDecodingEvent(propertyChangeListener, propertyChangeEvent);
    }

    public void setBorder(Dimension dimension, Rectangle rectangle) {
        int n = Math.max(dimension.width - rectangle.width, 0);
        int n2 = Math.max(dimension.height - rectangle.height, 0);
        this.borderNW.width = n / 2;
        this.borderNW.height = n2 / 2;
        this.borderSE.width = n - this.borderNW.width;
        this.borderSE.height = n2 - this.borderNW.height;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.targetBounds;
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, (int)Math.ceil(this.sWidth * (double)this.dpi), (int)Math.ceil(this.sHeight * (double)this.dpi));
            this.setTargetBounds(rectangle);
        }
        return rectangle;
    }

    public void setBufferBounds(Component component, Rectangle rectangle) {
        this.setBorder(component.getSize(), this.getBounds());
        this.setBufferBounds(this.transformBounds(rectangle));
    }

    public void setBufferBounds(Rectangle rectangle) {
        if (rectangle.isEmpty()) {
            this.filterBounds.setBounds(0, 0, 0, 0);
            for (int i = 0; i < this.filterArray.length; ++i) {
                this.filterArray[i] = null;
            }
        } else if (this.filterBounds.width != rectangle.width || this.filterBounds.height != rectangle.height) {
            Rectangle rectangle2 = new Rectangle();
            for (int i = 0; i < this.boundArray.length; ++i) {
                Rectangle rectangle3 = this.boundArray[i];
                if (rectangle3 != null) {
                    rectangle2.setBounds(rectangle.x - rectangle3.x, rectangle.y - rectangle3.y, rectangle.width, rectangle.height);
                    this.filterArray[i] = new DjVuFilter(rectangle2, rectangle3.getSize(), this.djvuPageArray[i], true);
                    continue;
                }
                this.filterArray[i] = null;
            }
        } else if (this.filterBounds.x != rectangle.x || this.filterBounds.y != rectangle.y) {
            for (int i = 0; i < this.boundArray.length; ++i) {
                DjVuFilter djVuFilter = this.filterArray[i];
                if (djVuFilter == null) continue;
                Rectangle rectangle4 = this.boundArray[i];
                djVuFilter.move(rectangle.x - rectangle4.x, rectangle.y - rectangle4.y);
            }
        }
        this.filterBounds.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public DjVuFilter getFilter(Component component, Rectangle rectangle, int n) {
        return new DjVuFilter(rectangle, this.getSize(), this.djvuPageArray[n], true);
    }

    public Rectangle getHighlightBounds() {
        double d = this.getHorizontalScale();
        double d2 = this.getVerticalScale();
        return new Rectangle(this.borderNW.width + (int)Math.floor(d * this.highlightXmin), this.borderNW.height + (int)Math.floor(d2 * this.highlightYmin), (int)Math.ceil(d * (this.highlightXmax - this.highlightXmin)), (int)Math.ceil(d2 * (this.highlightYmax - this.highlightYmin)));
    }

    public void setHighlightList(int n, Vector vector) {
        Rectangle rectangle;
        this.highlightList.setSize(0);
        this.highlightYmax = 0.0;
        this.highlightXmax = 0.0;
        this.highlightYmin = 0.0;
        this.highlightXmin = 0.0;
        if (vector != null && n >= 0 && n < this.boundArray.length && (rectangle = this.boundArray[n]) != null) {
            DjVuInfo djVuInfo = this.infoArray[n];
            double d = 1.0 / (double)djVuInfo.dpi;
            double d2 = 1.0 / this.getHorizontalScale();
            double d3 = 1.0 / this.getVerticalScale();
            int n2 = 0;
            while (n2 < vector.size()) {
                double[] dArray;
                Object object;
                if ((object = vector.elementAt(n2++)) instanceof GRect) {
                    GRect gRect = (GRect)object;
                    dArray = new double[]{d2 * (double)rectangle.x + d * (double)gRect.xmin, d3 * (double)rectangle.y + d * (double)(djVuInfo.height - gRect.ymax), d2 * (double)rectangle.x + d * (double)gRect.xmax, d3 * (double)rectangle.y + d * (double)(djVuInfo.height - gRect.ymin)};
                    object = dArray;
                } else {
                    dArray = (double[])object;
                }
                this.addHighlightArea(dArray, 0);
            }
        }
    }

    public Image[] getImage(Component component, Rectangle rectangle) {
        Image[] imageArray = new Image[]{null};
        imageArray[0] = component.createImage(new DjVuFilter(rectangle, this.getSize(), this.djvuPageArray[0], false).getImageProducer());
        return imageArray;
    }

    public final int getIndexMax() {
        return this.djvuPageArray.length;
    }

    public final DjVuInfo getDjVuInfo(int n) {
        return this.infoArray[n];
    }

    public DjVuImage getScaledInstance(int n, int n2) {
        if (n2 <= 0) {
            if (n <= 0) {
                return null;
            }
            n2 = (int)((long)this.infoArray[0].height * (long)n / (long)this.infoArray[0].width);
        } else if (n <= 0) {
            n = (int)((long)this.infoArray[0].width * (long)n2 / (long)this.infoArray[0].height);
        }
        DjVuImage djVuImage = new DjVuImage(this.djvuPageArray, this.favorFast, n, n2);
        return djVuImage;
    }

    public DjVuImage getScaledInstance(int n) {
        return new DjVuImage(this.djvuPageArray, this.favorFast, (this.infoArray[0].width * n + this.infoArray[0].dpi - 1) / this.infoArray[0].dpi, (this.infoArray[0].height * n + this.infoArray[0].dpi - 1) / this.infoArray[0].dpi);
    }

    public Dimension getSize() {
        return this.getBounds().getSize();
    }

    public Codec getTextCodec(int n, long l) {
        DjVuPage djVuPage;
        if (n >= 0 && n < this.djvuPageArray.length && (djVuPage = this.djvuPageArray[n]) != null) {
            return djVuPage.waitForCodec(djVuPage.textLock, l);
        }
        return null;
    }

    public void draw(Component component, Graphics graphics, ImageObserver imageObserver) {
        this.clearBorder(component, this.getBounds(), graphics);
        Shape shape = graphics.getClip();
        if (this.filterBounds.isEmpty()) {
            this.setBufferBounds(this.transformBounds(shape));
        }
        for (int i = 0; i < this.filterArray.length; ++i) {
            DjVuFilter djVuFilter = this.filterArray[i];
            if (djVuFilter == null) continue;
            Rectangle rectangle = djVuFilter.getBounds();
            Rectangle rectangle2 = this.boundArray[i];
            int n = this.borderNW.width + rectangle2.x;
            int n2 = this.borderNW.height + rectangle2.y;
            graphics.clipRect(n, n2, rectangle2.width, rectangle.y + rectangle.height);
            graphics.drawImage(djVuFilter.getImage(component), n + rectangle.x, n2 + rectangle.y, imageObserver);
            graphics.setClip(shape);
        }
    }

    public void transformRectangle(int n, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.isEmpty() || n < 0 || n > this.boundArray.length || this.boundArray[n] == null) {
            rectangle2.setBounds(rectangle.x, rectangle.y, 0, 0);
        } else {
            Rectangle rectangle3 = this.boundArray[n];
            DjVuInfo djVuInfo = this.infoArray[n];
            double d = (double)rectangle3.width / (double)djVuInfo.width;
            double d2 = (double)rectangle3.height / (double)djVuInfo.height;
            double d3 = d * (double)rectangle.x;
            double d4 = d * (double)rectangle.y;
            double d5 = d * (double)(rectangle.x + rectangle.width);
            double d6 = d2 * (double)(rectangle.y + rectangle.height);
            rectangle2.setBounds(this.borderNW.width + this.boundArray[n].x + (int)Math.floor(d3 + 1.0E-6), this.borderNW.height + this.boundArray[n].y + (int)Math.floor(d4 + 1.0E-6), (int)Math.ceil(0.999999 + d5 - d3), (int)Math.ceil(0.999999 + d6 - d4));
        }
    }

    public void transformRectangle(int n, GRect gRect, Rectangle rectangle) {
        rectangle.setBounds(gRect.xmin, this.infoArray[n].height - gRect.ymax, gRect.width(), gRect.height());
        this.transformRectangle(n, rectangle, rectangle);
    }

    private Vector getHighlightList() {
        return this.highlightList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightArea(double[] dArray, int n) {
        Vector vector;
        Vector vector2 = vector = this.getHighlightList();
        synchronized (vector2) {
            if ((dArray[0] <= this.highlightXmin ? dArray[2] > this.highlightXmin : dArray[0] < this.highlightXmax) && (dArray[1] <= this.highlightYmin ? dArray[3] > this.highlightYmin : dArray[1] < this.highlightYmax)) {
                while (n < vector.size()) {
                    double[] dArray2;
                    int n2 = n++;
                    double[] dArray3 = (double[])vector.elementAt(n2);
                    if (!(dArray[0] <= dArray3[0] ? dArray[2] > dArray3[0] : dArray[0] < dArray3[2]) || !(dArray[1] <= dArray3[1] ? dArray[3] > dArray3[1] : dArray[1] < dArray3[2])) continue;
                    if (dArray3[0] <= dArray[0] && dArray3[1] <= dArray[1] && dArray3[2] >= dArray[2] && dArray3[3] >= dArray[3]) {
                        return;
                    }
                    if (dArray3[0] >= dArray[0] && dArray3[1] >= dArray[1] && dArray3[2] <= dArray[2] && dArray3[3] <= dArray[3]) {
                        vector.removeElementAt(--n);
                        continue;
                    }
                    if (dArray3[0] == dArray[0] && dArray3[2] == dArray[2]) {
                        dArray[1] = Math.min(dArray3[1], dArray[1]);
                        dArray[3] = Math.max(dArray3[3], dArray[3]);
                        vector.removeElementAt(--n);
                        continue;
                    }
                    if (dArray3[1] == dArray[1] && dArray3[3] == dArray[3]) {
                        dArray[0] = Math.min(dArray3[0], dArray[0]);
                        dArray[2] = Math.max(dArray3[2], dArray[2]);
                        vector.removeElementAt(--n);
                        continue;
                    }
                    if (dArray[0] < dArray3[0]) {
                        if (dArray[2] <= dArray3[2] && dArray[1] >= dArray3[1] && dArray[3] <= dArray3[3]) {
                            dArray[3] = dArray3[3];
                            continue;
                        }
                        dArray2 = new double[]{dArray[0], dArray[1], dArray3[0], dArray[3]};
                        this.addHighlightArea(dArray2, n);
                        dArray[0] = dArray3[0];
                    }
                    if (dArray[2] > dArray3[2]) {
                        if (dArray[1] >= dArray3[1] && dArray[3] <= dArray3[3]) {
                            dArray[0] = dArray3[2];
                            continue;
                        }
                        dArray2 = new double[]{dArray3[2], dArray[1], dArray[2], dArray[3]};
                        this.addHighlightArea(dArray2, n);
                        dArray[2] = dArray3[2];
                    }
                    if (dArray3[0] == dArray[0] && dArray3[2] == dArray[2]) {
                        dArray[1] = Math.min(dArray3[1], dArray[1]);
                        dArray[3] = Math.max(dArray3[3], dArray[3]);
                        vector.removeElementAt(--n);
                        continue;
                    }
                    if (dArray[1] < dArray3[1]) {
                        if (dArray[3] > dArray3[3]) {
                            dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray3[1]};
                            this.addHighlightArea(dArray2, n);
                            dArray[1] = dArray3[3];
                            continue;
                        }
                        dArray[3] = dArray3[1];
                        continue;
                    }
                    if (dArray[3] > dArray3[3]) {
                        dArray[1] = dArray3[3];
                        continue;
                    }
                    return;
                }
            }
            vector.addElement(dArray);
            if (vector.size() == 1) {
                this.highlightXmin = dArray[0];
                this.highlightYmin = dArray[1];
                this.highlightXmax = dArray[2];
                this.highlightYmax = dArray[3];
            } else {
                if (this.highlightXmin > dArray[0]) {
                    this.highlightXmin = dArray[0];
                }
                if (this.highlightYmin > dArray[1]) {
                    this.highlightYmin = dArray[1];
                }
                if (this.highlightXmax < dArray[2]) {
                    this.highlightXmax = dArray[2];
                }
                if (this.highlightYmax < dArray[3]) {
                    this.highlightYmax = dArray[3];
                }
            }
        }
    }

    private void clearBorder(Component component, Rectangle rectangle, Graphics graphics) {
        Dimension dimension = component.getSize();
        this.setBorder(dimension, rectangle);
        if (this.borderNW.height > 0) {
            graphics.clearRect(0, 0, rectangle.width + this.borderSE.width + this.borderNW.width, this.borderNW.height);
        }
        if (this.borderNW.width > 0) {
            graphics.clearRect(0, this.borderNW.height, this.borderNW.width, rectangle.height);
        }
        if (this.borderSE.width > 0) {
            graphics.clearRect(rectangle.width + this.borderNW.width, this.borderNW.height, this.borderSE.width, rectangle.height);
        }
        if (this.borderSE.height > 0) {
            graphics.clearRect(0, rectangle.height + this.borderNW.height, rectangle.width + this.borderSE.width + this.borderNW.width, this.borderSE.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawHighlight(Graphics graphics, boolean bl) {
        Vector vector;
        Vector vector2 = vector = this.getHighlightList();
        synchronized (vector2) {
            double d = this.getHorizontalScale();
            double d2 = this.getVerticalScale();
            int n = 0;
            while (n < vector.size()) {
                double[] dArray = (double[])vector.elementAt(n++);
                int n2 = this.borderNW.width + (int)Math.floor(d * dArray[0]);
                int n3 = this.borderNW.height + (int)Math.floor(d2 * dArray[1]);
                int n4 = this.borderNW.width + (int)Math.ceil(d * dArray[2]);
                int n5 = this.borderNW.height + (int)Math.ceil(d2 * dArray[3]);
                if (bl) {
                    this.fillRect(graphics, -16777216, 50, n2, n3, n4, n5);
                }
                graphics.setPaintMode();
                graphics.setColor(BLUE);
                graphics.drawRect(n2, n3, n4 - n2, n5 - n3);
            }
        }
    }

    private Rectangle transformBounds(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        rectangle.x -= this.borderNW.width;
        if (rectangle.x < 0) {
            rectangle.width += rectangle.x;
        }
        rectangle.y -= this.borderNW.height;
        if (rectangle.y < 0) {
            rectangle.height += rectangle.y;
        }
        return this.getBounds().intersection(rectangle);
    }

    private void validateBounds(Rectangle rectangle) {
        this.validateBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void validateBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        if (n >= rectangle.x && n2 >= rectangle.y && n + n3 <= rectangle.x + rectangle.width && n2 + n4 <= rectangle.y + rectangle.height) {
            throw new IllegalArgumentException("Invalid target window (" + n + "," + n2 + "," + n3 + "," + n4 + "),getBounds().width=" + this.getBounds().width + ",getBounds().height=" + this.getBounds().height + ")");
        }
    }

    public void fillRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (graphics != null) {
            switch (n) {
                case -1: {
                    break;
                }
                case -16777216: {
                    if (!BROKEN_XOR) {
                        graphics.setColor(BLACK);
                        graphics.setXORMode(WHITE);
                        graphics.fillRect(n3, n4, n5 - n3, n6 - n4);
                        break;
                    }
                    n = 0xFFFF00;
                    n2 = 50;
                }
                default: {
                    Color color = DjVuImage.createColor(n, n2 * 255 / 100);
                    if (color != null) {
                        graphics.setPaintMode();
                        graphics.setColor(color);
                    } else {
                        color = new Color((n ^ 0xFFFFFF) & 0xFFFFFF);
                        graphics.setColor(BLACK);
                        graphics.setXORMode(color);
                    }
                    graphics.fillRect(n3, n4, n5 - n3, n6 - n4);
                    break;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Constructor constructor = null;
        try {
            constructor = (class$java$awt$Color == null ? (class$java$awt$Color = DjVuImage.class$("java.awt.Color")) : class$java$awt$Color).getConstructor(Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        colorConstructor = constructor;
    }
}

