/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu.text;

import com.lizardtech.djvu.BSInputStream;
import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.NumContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public class DjVuText
extends DjVuObject
implements Codec {
    public static final int PAGE = 1;
    public static final int COLUMN = 2;
    public static final int REGION = 3;
    public static final int PARAGRAPH = 4;
    public static final int LINE = 5;
    public static final int WORD = 6;
    public static final int CHARACTER = 7;
    public static final int end_of_column = 11;
    public static final int end_of_region = 29;
    public static final int end_of_paragraph = 31;
    public static final int end_of_line = 10;
    public Zone page_zone = new Zone();
    public boolean isUTF8 = true;
    protected byte[] textByteArray = new byte[0];
    static /* synthetic */ Class class$com$lizardtech$djvu$text$DjVuText;

    public static DjVuText createDjVuText(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (DjVuText)DjVuObject.create(djVuOptions, djVuOptions.getDjVuTextClass(), class$com$lizardtech$djvu$text$DjVuText == null ? (class$com$lizardtech$djvu$text$DjVuText = DjVuText.class$("com.lizardtech.djvu.text.DjVuText")) : class$com$lizardtech$djvu$text$DjVuText);
    }

    public boolean isImageData() {
        return false;
    }

    public int getLength(int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n3 < n2 && n3 < this.textByteArray.length) {
            n3 = DjVuText.nextChar(this.textByteArray, n3);
            ++n4;
        }
        return n4;
    }

    public String getString(int n, int n2) {
        if (this.isUTF8) {
            try {
                return new String(this.textByteArray, n, n2 - n, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.isUTF8 = false;
            }
        }
        return new String(this.textByteArray, n, n2 - n);
    }

    public void setTextByteArray(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                n = DjVuText.nextUTF8Char(byArray, n);
            }
            this.isUTF8 = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.isUTF8 = false;
        }
        this.textByteArray = byArray;
    }

    public void decode(CachedInputStream cachedInputStream) throws IOException {
        byte by;
        int n;
        if ("TXTz".equals(cachedInputStream.getName())) {
            cachedInputStream = CachedInputStream.createCachedInputStream(this).init(BSInputStream.createBSInputStream(this).init(cachedInputStream));
            cachedInputStream.setName("TXTa");
        }
        int n2 = cachedInputStream.read24();
        byte[] byArray = new byte[n2];
        int n3 = cachedInputStream.read(byArray);
        for (n = 0; n < n3 && (by = byArray[n]) != 0; ++n) {
            switch (by) {
                case 11: 
                case 29: 
                case 31: {
                    byArray[n] = 10;
                }
            }
        }
        if (n3 < n2) {
            while (n3 < n2) {
                byArray[n3++] = 0;
            }
            this.setTextByteArray(byArray);
            throw new IOException("DjVuText.corrupt_chunk");
        }
        this.setTextByteArray(byArray);
        n = cachedInputStream.read();
        if (n != -1) {
            if (n != 1) {
                throw new IOException("DjVuText.bad_version=" + n);
            }
            this.page_zone.decode(cachedInputStream, n2);
        }
    }

    public Vector find_text_with_rect(GRect gRect, StringBuffer stringBuffer, int n) {
        Vector vector = new Vector();
        NumContext numContext = new NumContext(0);
        NumContext numContext2 = new NumContext(0);
        this.page_zone.get_text_with_rect(gRect, numContext, numContext2);
        if (numContext.intValue() != numContext2.intValue()) {
            Vector vector2 = new Vector();
            this.page_zone.append_zones(vector2, numContext.intValue(), numContext2.intValue());
            int n2 = 0;
            if (n2 < vector2.size()) {
                do {
                    if (n >= 0) {
                        ((Zone)vector2.elementAt(n2)).get_smallest(vector, n);
                        continue;
                    }
                    ((Zone)vector2.elementAt(n2)).get_smallest(vector);
                } while (++n2 < vector2.size());
            }
        }
        stringBuffer.setLength(0);
        stringBuffer.append(this.getString(numContext.intValue(), numContext2.intValue()));
        return vector;
    }

    public Vector find_text_with_rect(GRect gRect, StringBuffer stringBuffer) {
        return this.find_text_with_rect(gRect, stringBuffer, 0);
    }

    public void get_zones(int n, Zone zone, Vector vector) {
        Zone zone2 = zone;
        for (int i = zone2.ztype; i < n; ++i) {
            for (int j = 0; j < zone2.children.size(); ++j) {
                Zone zone3 = (Zone)zone2.children.elementAt(j);
                if (zone3.ztype == n) {
                    if (vector.contains(zone3)) continue;
                    vector.addElement(zone3);
                    continue;
                }
                if (((Zone)zone2.children.elementAt((int)j)).ztype >= n) continue;
                this.get_zones(n, (Zone)zone2.children.elementAt(j), vector);
            }
        }
    }

    public boolean has_valid_zones() {
        return this.textByteArray.length != 0 && this.page_zone.children.isEmpty() && !this.page_zone.isEmpty();
    }

    public DjVuText init(Enumeration enumeration) throws IOException {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CachedInputStream cachedInputStream = (CachedInputStream)enumeration.nextElement();
                String string = cachedInputStream.getName();
                if (string.startsWith("FORM:")) {
                    this.init(cachedInputStream.getIFFChunks());
                    continue;
                }
                if (!"TXTa".equals(string) && !"TXTz".equals(string)) continue;
                this.decode(cachedInputStream);
            }
        }
        return this;
    }

    public DjVuText init(CachedInputStream cachedInputStream) throws IOException {
        Enumeration enumeration = cachedInputStream.getIFFChunks();
        if (enumeration != null) {
            return this.init(enumeration);
        }
        this.decode(cachedInputStream);
        return this;
    }

    public int length() {
        return this.textByteArray.length;
    }

    public void normalize_text() {
        ByteVector byteVector = new ByteVector();
        this.page_zone.normtext(this.textByteArray, byteVector);
        this.textByteArray = byteVector.toByteArray();
    }

    public int search_string(Vector vector, String string, int n, boolean bl, boolean bl2, boolean bl3) {
        vector.setSize(0);
        byte[] byArray = null;
        if (this.isUTF8) {
            try {
                byArray = (bl2 ? string : string.toLowerCase()).trim().getBytes("UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (byArray == null) {
            byArray = (bl2 ? string : string.toLowerCase()).trim().getBytes();
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("DjVuText.one_word");
        }
        if (this.textByteArray.length == 0 || byArray.length > this.textByteArray.length) {
            return -1;
        }
        if (bl) {
            if (n < 0 || n >= this.textByteArray.length) {
                n = -1;
            }
            while (true) {
                if (++n >= this.textByteArray.length) {
                    return -1;
                }
                if ((this.textByteArray[n] & 0xC0) == 128) continue;
                this.find_zones(vector, byArray, n, bl3, bl2);
                if (!vector.isEmpty()) break;
            }
        } else {
            if (n < 0 || n >= this.textByteArray.length) {
                n = this.textByteArray.length;
            }
            while (--n >= 0) {
                if ((this.textByteArray[n] & 0xC0) == 128) continue;
                this.find_zones(vector, byArray, n, bl3, bl2);
                if (vector.isEmpty()) continue;
                return n;
            }
        }
        return n;
    }

    public int search_string(Vector vector, String string, int n, boolean bl, boolean bl2) {
        return this.search_string(vector, string, n, bl, bl2, false);
    }

    public int startsWith(String string, int n, boolean bl) {
        if (this.isUTF8) {
            try {
                return this.startsWith((bl ? string : string.toLowerCase()).trim().getBytes("UTF-8"), n, bl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.startsWith((bl ? string : string.toLowerCase()).trim().getBytes(), n, bl);
    }

    public String toString() {
        return this.getString(0, this.textByteArray.length);
    }

    private int getChar(byte[] byArray, int n) {
        int n2 = byArray[n++];
        if (!this.isUTF8) {
            return n2;
        }
        switch (n2 & 0xC0) {
            case 128: {
                throw new IllegalStateException("Invalid UTF8");
            }
            case 64: {
                return n2;
            }
        }
        n2 = n2 << 6 | byArray[n++] & 0x7F;
        if ((n2 & 0x800) == 0) {
            return n2 & 0x7FF;
        }
        if (((n2 = n2 << 6 | byArray[n++] & 0x7F) & 0x10000) == 0) {
            return n2 & 0xFFFF;
        }
        if (((n2 = n2 << 6 | byArray[n++] & 0x7F) & 0x200000) == 0) {
            return n2 & 0x1FFFFF;
        }
        if (((n2 = n2 << 6 | byArray[n++] & 0x7F) & 0x4000000) == 0) {
            return n2 & 0x3FFFFFF;
        }
        return n2 << 6 | byArray[n++] & 0x7F;
    }

    private static boolean isJavaIdentifier(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    private static boolean isJavaIdentifier(int n) {
        return (n & 0xFFFF) == n && DjVuText.isJavaIdentifier((char)n);
    }

    private static boolean char_equal(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray[n] != byArray2[n2++]) {
            return false;
        }
        if ((byArray[n++] & 0xC0) < 128) {
            return true;
        }
        while ((byArray[n] & 0xC0) == 128 && (byArray2[n2] & 0xC0) == 128) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return (byArray[n] & 0xC0) != 128 && (byArray2[n2] & 0xC0) != 128;
    }

    private static boolean isspace(int n) {
        return n == 0 || (n & 0xFFFF) == n && Character.isWhitespace((char)n);
    }

    private static int nextChar(byte[] byArray, int n) {
        if (n < byArray.length) {
            while (++n < byArray.length) {
                if ((byArray[n] & 0xC0) == 128) continue;
                return n;
            }
        }
        return n;
    }

    private static int nextUTF8Char(byte[] byArray, int n) throws UnsupportedEncodingException {
        int n2 = byArray[n++];
        switch (n2 & 0xC0) {
            case 128: {
                throw new UnsupportedEncodingException("Invalid UTF8");
            }
            case 64: {
                return n;
            }
        }
        if ((byArray[n] & 0xC0) != 128) {
            throw new UnsupportedEncodingException("Invalid UTF8");
        }
        if (((n2 = n2 << 6 | byArray[n++] & 0x7F) & 0x800) == 0) {
            return n;
        }
        if ((byArray[n] & 0xC0) != 128) {
            throw new UnsupportedEncodingException("Invalid UTF8");
        }
        if (((n2 = n2 << 6 | byArray[n++] & 0x7F) & 0x10000) == 0) {
            return n;
        }
        if ((byArray[n] & 0xC0) != 128) {
            throw new UnsupportedEncodingException("Invalid UTF8");
        }
        if (((n2 = n2 << 6 | byArray[n++] & 0x7F) & 0x200000) == 0) {
            return n;
        }
        if ((byArray[n] & 0xC0) != 128) {
            throw new UnsupportedEncodingException("Invalid UTF8");
        }
        if (((n2 = n2 << 6 | byArray[n++] & 0x7F) & 0x4000000) == 0) {
            return n;
        }
        if ((byArray[n] & 0xC0) != 128) {
            throw new UnsupportedEncodingException("Invalid UTF8");
        }
        return ++n;
    }

    private void find_zones(Vector vector, byte[] byArray, int n, boolean bl, boolean bl2) {
        int n2;
        vector.setSize(0);
        if (!DjVuText.char_equal(byArray, 0, this.textByteArray, n)) {
            if (!bl2) {
                n2 = this.getChar(byArray, 0);
                int n3 = this.getChar(this.textByteArray, n);
                if ((n2 & 0xFFFF) != n2 || (n3 & 0xFFFF) != n3 || Character.toUpperCase((char)n2) != Character.toUpperCase((char)n3)) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((n2 = this.startsWith(byArray, n, bl2)) > n) {
            this.find_smallest_zones(vector, n, n2 - n);
            if (!bl || vector.size() == 0) {
                return;
            }
            Zone zone = (Zone)vector.elementAt(0);
            if (zone == null) {
                return;
            }
            if (zone.ztype > 6 && (zone = zone.get_parent()) == null) {
                return;
            }
            if (zone.text_start == n || zone.ztype != 6 && !DjVuText.isJavaIdentifier(this.getChar(this.textByteArray, DjVuText.prevChar(this.textByteArray, n)))) {
                Zone zone2 = (Zone)vector.elementAt(vector.size() - 1);
                if (zone2 != null && zone2.ztype > 6) {
                    zone2 = zone2.get_parent();
                }
                if (zone2 != null && zone2.text_start + zone2.text_length == n2 || !DjVuText.isJavaIdentifier(this.getChar(this.textByteArray, n2))) {
                    return;
                }
            }
            vector.setSize(0);
        }
    }

    private int firstEndSpace(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (--n3 >= n) {
            if ((byArray[n3] & 0xC0) == 128 || DjVuText.isspace(this.getChar(byArray, n3))) continue;
            return DjVuText.nextChar(byArray, n3);
        }
        return n;
    }

    private static int prevChar(byte[] byArray, int n) {
        if (n >= 0) {
            while (--n >= 0) {
                if ((byArray[n] & 0xC0) == 128) continue;
                return n;
            }
        }
        return n;
    }

    private static int skipSpaces(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (DjVuText.isspace(string.charAt(n++))) continue;
            return n - 1;
        }
        return n2;
    }

    private Vector find_smallest_zones(Vector vector, int n, int n2) {
        if (vector == null) {
            vector = new Vector<Zone>();
        } else {
            vector.setSize(0);
        }
        int n3 = n + n2;
        n = this.skipSpaces(this.textByteArray, n, n2);
        n3 = this.firstEndSpace(this.textByteArray, n, n3 - n);
        if (n == n3) {
            return vector;
        }
        n2 = n3 - n;
        int n4 = 7;
        while (n4 >= 1) {
            int n5 = n;
            while (n5 < n3 && (n5 = this.skipSpaces(this.textByteArray, n5, n2)) != n3) {
                Zone zone = this.get_smallest_zone(n4, n5);
                if (zone == null || n4 != zone.ztype) {
                    --n4;
                    vector.setSize(0);
                    break;
                }
                vector.addElement(zone);
                n5 = zone.text_start + zone.text_length;
            }
            if (vector.size() == 0) continue;
            return vector;
        }
        return vector;
    }

    private Zone get_smallest_zone(int n, int n2) {
        if (this.search_zone(this.page_zone, n2) == n2) {
            return null;
        }
        Zone zone = this.page_zone;
        while (zone.ztype < n) {
            int n3;
            Vector vector = zone.children;
            for (n3 = 0; n3 < vector.size() && this.search_zone((Zone)vector.elementAt(n3), n2) <= n2; ++n3) {
            }
            if (n3 >= vector.size()) break;
            zone = (Zone)vector.elementAt(n3);
        }
        return zone;
    }

    private int nextJavaIdentifier(byte[] byArray, int n) {
        while (n < byArray.length && !DjVuText.isJavaIdentifier(this.getChar(byArray, n))) {
            n = DjVuText.nextChar(byArray, n);
        }
        return n;
    }

    private int nextSpace(String string, int n) {
        int n2 = string.length();
        while (n < n2 && !Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private int nextSpace(byte[] byArray, int n) {
        while (n < byArray.length && !DjVuText.isspace(this.getChar(byArray, n))) {
            n = DjVuText.nextChar(byArray, n);
        }
        return n;
    }

    private int search_zone(Zone zone, int n) {
        int n2 = zone.text_start + zone.text_length;
        return n < zone.text_start || n >= n2 ? n : n2;
    }

    private int skipSpaces(byte[] byArray, int n, int n2) {
        while (n < n2 && DjVuText.isspace(this.getChar(byArray, n))) {
            n = DjVuText.nextChar(byArray, n);
        }
        return n;
    }

    private int skipSpaces(byte[] byArray, int n) {
        return this.skipSpaces(byArray, n, byArray.length);
    }

    private int startsWith(byte[] byArray, int n, boolean bl) {
        if (byArray.length == 0) {
            return n;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = this.getChar(byArray, 0);
        while (n2 < this.textByteArray.length) {
            int n5 = this.getChar(this.textByteArray, n2);
            if (n4 != n5 && (bl || (n4 & 0xFFFF) != n4 || (n5 & 0xFFFF) != n5 || Character.toUpperCase((char)n4) != Character.toUpperCase((char)n5))) {
                return n;
            }
            n3 = DjVuText.nextChar(byArray, n3);
            n2 = DjVuText.nextChar(this.textByteArray, n2);
            if (n3 >= byArray.length) {
                return n2;
            }
            n4 = this.getChar(byArray, n3);
            if (DjVuText.isJavaIdentifier(n4)) continue;
            n5 = this.getChar(this.textByteArray, n2);
            if (DjVuText.isJavaIdentifier(n5)) {
                return n;
            }
            if (!DjVuText.isspace(n4)) continue;
            if ((n3 = this.skipSpaces(byArray, n3)) >= byArray.length) {
                return n2;
            }
            n4 = this.getChar(byArray, n3);
            if (DjVuText.isJavaIdentifier(n4)) {
                n2 = this.nextJavaIdentifier(this.textByteArray, n2);
                continue;
            }
            n2 = this.skipSpaces(this.textByteArray, n2);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ByteVector
    extends ByteArrayOutputStream {
        private ByteVector() {
        }

        public int size() {
            return this.count;
        }

        public int getByte(int n) {
            return this.buf[n];
        }
    }

    public static class Zone
    extends GRect {
        private static final int version = 1;
        public Vector children = new Vector();
        public boolean add_separators = true;
        public int text_length = 0;
        public int text_start = 0;
        public int ztype = 1;
        private Zone zone_parent = null;

        public Zone append_child() {
            Zone zone = new Zone();
            zone.ztype = this.ztype;
            zone.add_separators = this.add_separators;
            zone.zone_parent = this;
            this.children.addElement(zone);
            return zone;
        }

        public void append_zones(Vector vector, int n, int n2) {
            block7: {
                int n3;
                block5: {
                    block6: {
                        n3 = this.text_start + this.text_length;
                        if (this.text_start < n) break block5;
                        if (n3 > n2) break block6;
                        vector.addElement(this);
                        break block7;
                    }
                    if (this.text_start >= n2) break block7;
                    if (this.children.size() > 0) {
                        int n4 = 0;
                        do {
                            ((Zone)this.children.elementAt(n4++)).append_zones(vector, n, n2);
                        } while (this.children.size() > n4);
                    } else {
                        vector.addElement(this);
                    }
                    break block7;
                }
                if (n3 > n) {
                    int n5 = 0;
                    while (n5 < this.children.size()) {
                        ((Zone)this.children.elementAt(n5++)).append_zones(vector, n, n2);
                    }
                }
            }
        }

        public Zone get_parent() {
            return this.zone_parent;
        }

        public void get_smallest(Vector vector) {
            if (this.children.size() > 0) {
                int n = 0;
                do {
                    ((Zone)this.children.elementAt(n++)).get_smallest(vector);
                } while (this.children.size() > n);
            } else {
                vector.addElement(this);
            }
        }

        public void get_smallest(Vector vector, int n) {
            if (this.children.size() > 0) {
                int n2 = 0;
                do {
                    ((Zone)this.children.elementAt(n2++)).get_smallest(vector, n);
                } while (this.children.size() > n2);
            } else if (this.zone_parent != null && this.zone_parent.ztype >= 4) {
                Zone zone = this.zone_parent;
                if (zone.height() < zone.width()) {
                    vector.addElement(new GRect(this.xmin - n, zone.ymin - n, this.width() + 2 * n, zone.height() + 2 * n));
                } else {
                    vector.addElement(new GRect(zone.xmin - n, this.ymin - n, zone.width() + 2 * n, this.height() + 2 * n));
                }
            } else {
                vector.addElement(new GRect(this.xmin - n, this.ymin - n, this.width() + 2 * n, this.height() + 2 * n));
            }
        }

        public void get_text_with_rect(GRect gRect, NumContext numContext, NumContext numContext2) {
            boolean bl;
            boolean bl2 = bl = this.children.size() > 0;
            if (bl ? gRect.contains(this) : Zone.intersects_zone(gRect, this)) {
                int n = this.text_start + this.text_length;
                if (numContext.intValue() == numContext2.intValue()) {
                    numContext.set(this.text_start);
                    numContext2.set(n);
                } else {
                    if (numContext2.intValue() < n) {
                        numContext2.set(n);
                    }
                    if (this.text_start < numContext.intValue()) {
                        numContext.set(this.text_start);
                    }
                }
            } else if (bl && Zone.intersects_zone(gRect, this)) {
                int n = 0;
                do {
                    ((Zone)this.children.elementAt(n)).get_text_with_rect(gRect, numContext, numContext2);
                } while (++n < this.children.size());
            }
        }

        private static boolean intersects_zone(GRect gRect, GRect gRect2) {
            return (gRect.xmin < gRect2.xmin ? gRect.xmax >= gRect2.xmin : gRect.xmin <= gRect2.xmax) && (gRect.ymin < gRect2.ymin ? gRect.ymax >= gRect2.ymin : gRect.ymin <= gRect2.ymax);
        }

        private void cleartext() {
            this.text_start = 0;
            this.text_length = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                ((Zone)this.children.elementAt(i)).cleartext();
            }
        }

        private void decode(InputStream inputStream, int n, Zone zone, Zone zone2) throws IOException {
            this.ztype = inputStream.read();
            if (this.ztype < 1 || this.ztype > 7) {
                throw new IOException("DjVuText.corrupt_text");
            }
            this.xmin = inputStream.read() << 8;
            this.xmin |= inputStream.read();
            this.xmin -= 32768;
            this.ymin = inputStream.read() << 8;
            this.ymin |= inputStream.read();
            this.ymin -= 32768;
            int n2 = inputStream.read() << 8;
            n2 |= inputStream.read();
            n2 -= 32768;
            int n3 = inputStream.read() << 8;
            n3 |= inputStream.read();
            n3 -= 32768;
            this.text_start = inputStream.read() << 8;
            this.text_start |= inputStream.read();
            this.text_start -= 32768;
            this.text_length = inputStream.read() << 16;
            this.text_length |= inputStream.read() << 8;
            this.text_length |= inputStream.read();
            if (zone2 != null) {
                if (this.ztype == 1 || this.ztype == 4 || this.ztype == 5) {
                    this.xmin += zone2.xmin;
                    this.ymin = zone2.ymin - (this.ymin + n3);
                } else {
                    this.xmin += zone2.xmax;
                    this.ymin += zone2.ymin;
                }
                this.text_start += zone2.text_start + zone2.text_length;
            } else if (zone != null) {
                this.xmin += zone.xmin;
                this.ymin = zone.ymax - (this.ymin + n3);
                this.text_start += zone.text_start;
            }
            this.xmax = this.xmin + n2;
            this.ymax = this.ymin + n3;
            int n4 = inputStream.read() << 16;
            n4 |= inputStream.read() << 8;
            n4 |= inputStream.read();
            if (this.isEmpty() || this.text_start < 0 || this.text_start + this.text_length > n) {
                throw new IOException("DjVuText.corrupt_text");
            }
            Zone zone3 = null;
            this.children.setSize(0);
            while (n4-- > 0) {
                Zone zone4 = this.append_child();
                zone4.decode(inputStream, n, this, zone3);
                zone3 = zone4;
            }
        }

        private void decode(InputStream inputStream, int n, Zone zone) throws IOException {
            this.decode(inputStream, n, zone, null);
        }

        private void decode(InputStream inputStream, int n) throws IOException {
            this.decode(inputStream, n, null, null);
        }

        private void normtext(byte[] byArray, ByteVector byteVector) {
            int n;
            if (this.text_length == 0) {
                this.text_start = byteVector.size();
                for (n = 0; n < this.children.size(); ++n) {
                    ((Zone)this.children.elementAt(n)).normtext(byArray, byteVector);
                }
                this.text_length = byteVector.size() - this.text_start;
                if (this.text_length == 0) {
                    return;
                }
            } else {
                n = byteVector.size();
                int n2 = 0;
                int n3 = this.text_start;
                while (n2++ < this.text_length) {
                    byteVector.write(byArray[n3++]);
                }
                this.text_start = n;
                for (n2 = 0; n2 < this.children.size(); ++n2) {
                    ((Zone)this.children.elementAt(n2)).cleartext();
                }
            }
            switch (this.ztype) {
                case 2: {
                    n = 11;
                    break;
                }
                case 3: {
                    n = 29;
                    break;
                }
                case 4: {
                    n = 31;
                    break;
                }
                case 5: {
                    n = 10;
                    break;
                }
                case 6: {
                    n = 32;
                    break;
                }
                default: {
                    return;
                }
            }
            if (byteVector.getByte(byteVector.size() - 1) != n) {
                byteVector.write((byte)n);
                ++this.text_length;
            }
        }
    }
}

