/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu.outline;

import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVmDir;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class Bookmark
implements Codec,
DjVuInterface {
    private DjVmDir djvmDir = null;
    private DjVuObject djvuObject = new DjVuObject();
    private Object object = null;
    private String displayName = null;
    private Vector children = new Vector();
    private boolean urlAsDefaultDisplayName = false;
    private boolean valid = true;
    static /* synthetic */ Class class$com$lizardtech$djvu$outline$Bookmark;

    public boolean isImageData() {
        return false;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        int n;
        URL uRL;
        DjVmDir djVmDir;
        String string = this.displayName;
        if (string == null && this.urlAsDefaultDisplayName && (djVmDir = this.getDjVmDir()) != null && (uRL = djVmDir.getInitURL()) != null && (n = (string = ((Object)uRL).toString()).lastIndexOf(47)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void setDjVmDir(DjVmDir djVmDir) {
        if (djVmDir != null && this.size() == 0) {
            this.urlAsDefaultDisplayName = true;
            int n = 0;
            Vector vector = djVmDir.get_files_list();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Bookmark bookmark = Bookmark.createBookmark(this);
                DjVmDir.File file = (DjVmDir.File)enumeration.nextElement();
                if (!file.is_page()) continue;
                bookmark.setDisplayName(file.get_title());
                bookmark.setObject(new Integer(n++));
                this.addElement(bookmark);
            }
        }
        this.setDjVmDir(djVmDir, this.elements());
    }

    public DjVmDir getDjVmDir() {
        return this.djvmDir;
    }

    public void setDjVuOptions(DjVuOptions djVuOptions) {
        this.djvuObject.setDjVuOptions(djVuOptions);
    }

    public DjVuOptions getDjVuOptions() {
        return this.djvuObject.getDjVuOptions();
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public int getPageno() {
        Object object = this.getObject();
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (!(object instanceof String)) {
            return -1;
        }
        DjVmDir djVmDir = this.getDjVmDir();
        if (djVmDir == null) {
            return -1;
        }
        int n = djVmDir.getPageno((String)object);
        if (n >= 0) {
            this.setObject(new Integer(n));
        }
        return n;
    }

    public void addElement(Bookmark bookmark) {
        this.getChildren().addElement(bookmark);
    }

    public static Bookmark createBookmark(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (Bookmark)DjVuObject.create(djVuOptions, djVuOptions.getBookmarkClass(), class$com$lizardtech$djvu$outline$Bookmark == null ? (class$com$lizardtech$djvu$outline$Bookmark = Bookmark.class$("com.lizardtech.djvu.outline.Bookmark")) : class$com$lizardtech$djvu$outline$Bookmark);
    }

    public synchronized void setSize(int n) {
        this.setValid(false);
        this.getChildren().setSize(n);
        this.setValid(true);
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void decode(CachedInputStream cachedInputStream) {
        this.setSize(0);
        this.setObject(null);
        this.setDisplayName(null);
        this.setValid(false);
        try {
            for (int i = cachedInputStream.read16(); i > 0; i -= this.readElement(cachedInputStream)) {
            }
            this.flatten();
            this.setValid(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public Bookmark elementAt(int n) {
        return (Bookmark)this.getChildren().elementAt(n);
    }

    public Enumeration elements() {
        return this.getChildren().elements();
    }

    public int size() {
        return this.getChildren().size();
    }

    protected void flatten() {
        Object object = this.elements();
        while (object.hasMoreElements()) {
            ((Bookmark)object.nextElement()).flatten();
        }
        while (this.size() == 1) {
            object = this.getDisplayName();
            Bookmark bookmark = this.elementAt(0);
            if (object == null) {
                this.setDisplayName(bookmark.getDisplayName());
                this.setObject(bookmark.getObject());
            } else if (bookmark.getDisplayName() != null) break;
            this.setSize(0);
            Enumeration enumeration = bookmark.elements();
            while (enumeration.hasMoreElements()) {
                this.addElement((Bookmark)enumeration.nextElement());
            }
        }
    }

    private void setDjVmDir(DjVmDir djVmDir, Enumeration enumeration) {
        this.djvmDir = djVmDir;
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)enumeration.nextElement();
            bookmark.setDjVmDir(djVmDir, bookmark.elements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readElement(CachedInputStream cachedInputStream) throws IOException {
        Bookmark bookmark = Bookmark.createBookmark(this);
        int n = cachedInputStream.read();
        if (n < 0) {
            throw new EOFException("Unexpected EOF");
        }
        int n2 = cachedInputStream.read24();
        if (n2 < 0) {
            throw new EOFException("Unexpected EOF");
        }
        if (n2 > 0) {
            bookmark.setDisplayName(cachedInputStream.readSizedUTF(n2));
        }
        if ((n2 = cachedInputStream.read24()) < 0) {
            throw new EOFException("Unexpected EOF");
        }
        if (n2 > 0) {
            bookmark.setObject(cachedInputStream.readSizedUTF(n2));
        }
        int n3 = 1;
        try {
            if (n > 0) {
                bookmark.setValid(false);
                for (int i = 0; i < n; ++i) {
                    n3 += bookmark.readElement(cachedInputStream);
                }
                bookmark.setValid(true);
            }
        }
        finally {
            this.addElement(bookmark);
        }
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

