/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu.anno;

import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.Hyperlink;
import com.lizardtech.djvu.anno.Mapper;
import java.util.Vector;

public class Rect
extends DjVuObject
implements Hyperlink {
    public static final int MAP_RECT = 0;
    public static final int MAP_OVAL = 1;
    public static final int MAP_POLY = 2;
    public static final int MAP_TEXT = 3;
    public static final int MAP_LINE = 4;
    public static final int NO_BORDER = 0;
    public static final int XOR_BORDER = 1;
    public static final int SOLID_BORDER = 2;
    public static final int SHADOW_IN_BORDER = 3;
    public static final int SHADOW_OUT_BORDER = 4;
    public static final int SHADOW_EIN_BORDER = 5;
    public static final int SHADOW_EOUT_BORDER = 6;
    public static final String MAPAREA_TAG = "maparea";
    public static final String RECT_TAG = "rect";
    public static final String NO_BORDER_TAG = "none";
    public static final String XOR_BORDER_TAG = "xor";
    public static final String SOLID_BORDER_TAG = "border";
    public static final String SHADOW_IN_BORDER_TAG = "shadow_in";
    public static final String SHADOW_OUT_BORDER_TAG = "shadow_out";
    public static final String SHADOW_EIN_BORDER_TAG = "shadow_ein";
    public static final String SHADOW_EOUT_BORDER_TAG = "shadow_eout";
    public static final String BORDER_AVIS_TAG = "border_avis";
    public static final String HILITE_TAG = "hilite";
    public static final String ARROW_TAG = "arrow";
    public static final String URL_TAG = "url";
    public static final String TARGET_SELF = "_self";
    public static final String PUSHPIN_TAG = "pushpin";
    public static final String BGCOLOR_TAG = "backclr";
    public static final String TEXTCOLOR_TAG = "textclr";
    public static final String LINECOLOR_TAG = "lineclr";
    public static final String LINE_ARROW_TAG = "arrow";
    public static final String LINE_WIDTH_TAG = "width";
    public static final String OPACITY_TAG = "opacity";
    public static final int NO_HILITE = -1;
    public static final int XOR_HILITE = -16777216;
    private final GRect bounds = new GRect();
    private int border_color = 255;
    private int hilite_color = -1;
    private int text_color = 0;
    private int bg_color = -1;
    private int line_color = -16777216;
    private int opacity = 50;
    private int line_width = 1;
    private String comment = null;
    private String target = "_self";
    private String url = null;
    private int[] xx = null;
    private int[] yy = null;
    private boolean border_always_visible = false;
    private boolean visible = false;
    private boolean pushpin = false;
    private boolean arrow = false;
    private int border_type = 0;
    private int border_width = 1;
    private long pageInfoHeight = 0L;
    private long pageInfoWidth = 0L;
    private long pageScaledHeight = 0L;
    private long pageScaledWidth = 0L;
    static /* synthetic */ Class class$com$lizardtech$djvu$anno$Rect;

    public void setBorderAlwaysVisible(boolean bl) {
        this.border_always_visible = bl;
        this.setVisible(bl);
    }

    public boolean isBorderAlwaysVisible() {
        return this.border_always_visible;
    }

    public void setPushpin(boolean bl) {
        this.pushpin = bl;
    }

    public boolean isPushpin() {
        return this.pushpin;
    }

    public void setArrow(boolean bl) {
        this.arrow = bl;
    }

    public boolean isArrow() {
        return this.arrow;
    }

    public void setBorderColor(Number number) {
        this.border_color = number.intValue();
    }

    public int getBorderColor() {
        return this.border_color;
    }

    public void setBorderType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.border_type = n;
                return;
            }
        }
        this.border_type = 0;
    }

    public int getBorderType() {
        return this.border_type;
    }

    public void setBorderWidth(int n) {
        this.border_width = n;
    }

    public int getBorderWidth() {
        return this.border_width;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setHiliteColor(Number number) {
        this.hilite_color = number.intValue();
    }

    public int getHiliteColor() {
        return this.hilite_color;
    }

    public void setTextColor(Number number) {
        this.text_color = number.intValue();
    }

    public int getTextColor() {
        return this.text_color;
    }

    public void setBgColor(Number number) {
        this.bg_color = number.intValue();
    }

    public int getBgColor() {
        return this.bg_color;
    }

    public void setLineColor(Number number) {
        this.line_color = number.intValue();
    }

    public void setLineWidth(Number number) {
        this.line_width = number.intValue();
    }

    public int getLineColor() {
        return this.line_color;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setOpacity(Number number) {
        this.opacity = number.intValue();
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getMapType() {
        return 0;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getTarget() {
        return this.target;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible || this.isBorderAlwaysVisible() && !this.isPushpin();
    }

    public static Rect createRect(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (Rect)DjVuObject.create(djVuOptions, djVuOptions.getAnnoRectClass(), class$com$lizardtech$djvu$anno$Rect == null ? (class$com$lizardtech$djvu$anno$Rect = Rect.class$("com.lizardtech.djvu.anno.Rect")) : class$com$lizardtech$djvu$anno$Rect);
    }

    public GRect getBounds() {
        return this.bounds;
    }

    public boolean isEmpty() {
        return this.getBounds().isEmpty();
    }

    public final void setPageSize(int n, int n2, int n3, int n4) {
        if (this.pageInfoHeight != (long)n2 || this.pageInfoWidth != (long)n || this.pageScaledHeight != (long)n4 || this.pageScaledWidth != (long)n3) {
            this.pageInfoHeight = n2;
            this.pageInfoWidth = n;
            this.pageScaledHeight = n4;
            this.pageScaledWidth = n3;
            this.xx = null;
            this.yy = null;
        }
    }

    public Vector getPoints() {
        GRect gRect = this.getBounds();
        int[] nArray = new int[]{gRect.xmin, gRect.ymin};
        int[] nArray2 = new int[]{gRect.xmax, gRect.ymax};
        Vector<int[]> vector = new Vector<int[]>();
        vector.addElement(nArray);
        vector.addElement(nArray2);
        return vector;
    }

    public final int[] getXCoordinates() {
        int[] nArray = this.xx;
        if (nArray == null) {
            nArray = this.computeArray(false);
        }
        return nArray;
    }

    public final int[] getYCoordinates() {
        int[] nArray = this.yy;
        if (nArray == null) {
            nArray = this.computeArray(true);
        }
        return nArray;
    }

    public final int[] computeArray(boolean bl) {
        Vector vector = this.getPoints();
        int[] nArray = new int[vector.size()];
        int[] nArray2 = new int[vector.size()];
        int n = vector.size();
        while (n-- > 0) {
            int[] nArray3 = (int[])vector.elementAt(n);
            nArray[n] = this.scaleX(nArray3[0]);
            nArray2[n] = this.scaleY(nArray3[1]);
        }
        this.xx = nArray;
        this.yy = nArray2;
        return bl ? nArray2 : nArray;
    }

    public boolean isValid() {
        GRect gRect = this.getBounds();
        if (gRect.xmax == gRect.xmin) {
            return false;
        }
        if (gRect.ymax == gRect.ymin) {
            return false;
        }
        if ((this.border_type == 1 || this.border_type == 2) && this.border_width != 1) {
            return false;
        }
        return this.border_type != 3 && this.border_type != 4 && this.border_type != 5 && this.border_type != 6 || this.border_width >= 3 && this.border_width <= 32;
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public String get_shape_name() {
        return RECT_TAG;
    }

    public Rect init(GRect gRect) {
        GRect gRect2 = this.getBounds();
        gRect2.xmin = gRect.xmin;
        gRect2.xmax = gRect.xmax;
        gRect2.ymin = gRect.ymin;
        gRect2.ymax = gRect.ymax;
        return this;
    }

    public void map(Mapper mapper) {
        mapper.map(this.getBounds());
    }

    public void move(int n, int n2) {
        if (n != 0 || n2 != 0) {
            GRect gRect = this.getBounds();
            gRect.xmin += n;
            gRect.ymin += n2;
            gRect.xmax += n;
            gRect.ymax += n2;
        }
        this.reset();
    }

    public void resize(int n, int n2) {
        GRect gRect = this.getBounds();
        gRect.xmax = gRect.xmin + n;
        gRect.ymax = gRect.ymin + n2;
        this.reset();
    }

    public void rotateArea(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        int n4 = 0;
        GRect gRect = this.getBounds();
        switch (n %= 4) {
            case 1: {
                n4 = gRect.xmin;
                gRect.xmin = n3 - gRect.ymin;
                gRect.ymin = n4;
                n4 = gRect.xmax;
                gRect.xmax = n3 - gRect.ymax;
                gRect.ymax = n4;
                break;
            }
            case 2: {
                gRect.xmin = n2 - gRect.xmin;
                gRect.ymin = n2 - gRect.ymin;
                gRect.xmax = n3 - gRect.xmax;
                gRect.ymax = n3 - gRect.ymax;
                break;
            }
            case 3: {
                n4 = gRect.xmin;
                gRect.xmin = gRect.ymin;
                gRect.ymin = n2 - n4;
                n4 = gRect.xmax;
                gRect.xmax = gRect.ymax;
                gRect.ymax = n2 - n4;
            }
        }
        if (gRect.xmin > gRect.xmax) {
            n4 = gRect.xmin;
            gRect.xmin = gRect.xmax;
            gRect.xmax = n4;
        }
        if (gRect.ymin > gRect.ymax) {
            n4 = gRect.ymin;
            gRect.ymin = gRect.ymax;
            gRect.ymax = n4;
        }
        this.reset();
    }

    public void transform(GRect gRect) {
        GRect gRect2 = this.getBounds();
        gRect2.xmin = gRect.xmin;
        gRect2.ymin = gRect.ymin;
        gRect2.xmax = gRect.xmax;
        gRect2.ymax = gRect.ymax;
        this.reset();
    }

    public void unmap(Mapper mapper) {
        mapper.unmap(this.getBounds());
    }

    protected final long getInfoHeight() {
        return this.pageInfoHeight;
    }

    protected final long getInfoWidth() {
        return this.pageInfoWidth;
    }

    protected final long getScaledHeight() {
        return this.pageScaledHeight;
    }

    protected final long getScaledWidth() {
        return this.pageScaledWidth;
    }

    protected void reset() {
        this.xx = null;
        this.yy = null;
    }

    private int scaleX(int n) {
        if (this.pageInfoWidth != 0L && this.pageScaledWidth != 0L && this.pageScaledWidth != this.pageInfoWidth) {
            n = (int)(this.pageScaledWidth * (long)n / this.pageInfoWidth);
        }
        return n;
    }

    private int scaleY(int n) {
        if (this.pageInfoHeight != 0L) {
            n = this.pageScaledHeight != 0L && this.pageScaledHeight != this.pageInfoHeight ? (int)((this.pageInfoHeight - (long)n) * this.pageScaledHeight / this.pageInfoHeight) : (int)this.pageInfoHeight - n;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

