/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu.anno;

import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.anno.Mapper;
import com.lizardtech.djvu.anno.Rect;
import java.util.Vector;

public class Poly
extends Rect {
    public static final String POLY_TAG = "poly";
    private Boolean hasValidData = null;
    private GRect bounds = null;
    private Vector pointVector = new Vector();
    private boolean open = false;
    static /* synthetic */ Class class$com$lizardtech$djvu$anno$Poly;

    public GRect getBounds() {
        GRect gRect = this.bounds;
        if (this.bounds == null) {
            int n;
            int n2;
            int[] nArray = this.getPoint(0);
            int n3 = n2 = nArray[0];
            int n4 = n = nArray[1];
            for (int i = 1; i < this.pointVector.size(); ++i) {
                nArray = this.getPoint(i);
                if (n2 > nArray[0]) {
                    n2 = nArray[0];
                } else if (n3 < nArray[0]) {
                    n3 = nArray[0];
                }
                if (n > nArray[1]) {
                    n = nArray[1];
                    continue;
                }
                if (n4 >= nArray[1]) continue;
                n4 = nArray[1];
            }
            this.bounds = gRect = new GRect(n2, n, n3 - n2, n4 - n);
        }
        return gRect;
    }

    public int getMapType() {
        return 2;
    }

    public static Poly createPoly(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (Poly)DjVuObject.create(djVuOptions, djVuOptions.getAnnoPolyClass(), class$com$lizardtech$djvu$anno$Poly == null ? (class$com$lizardtech$djvu$anno$Poly = Poly.class$("com.lizardtech.djvu.anno.Poly")) : class$com$lizardtech$djvu$anno$Poly);
    }

    public boolean isEmpty() {
        return !this.isOpen() && !this.isDataValid();
    }

    public boolean isDataValid() {
        Boolean bl = this.hasValidData;
        if (bl == null) {
            int n = this.pointVector.size();
            if (n < 2 || n < 3 && !this.isOpen()) {
                this.hasValidData = new Boolean(false);
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                for (int j = i + 2; j < this.size(); ++j) {
                    if (i == (j + 1) % this.pointVector.size() || !Poly.do_segments_intersect(this.getPoint(i)[0], this.getPoint(i)[1], this.getPoint(i + 1)[0], this.getPoint(i + 1)[1], this.getPoint(j), this.getPoint(j + 1))) continue;
                    this.hasValidData = new Boolean(false);
                    return false;
                }
            }
            bl = this.hasValidData = new Boolean(true);
        }
        return bl;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Vector getPoints() {
        return this.pointVector;
    }

    public String getShapeName() {
        return POLY_TAG;
    }

    public boolean isValid() {
        int n = this.getBorderType();
        int n2 = this.getHiliteColor();
        return (n == 0 || n == 2 || n == 1) && n2 == -1 && super.isValid();
    }

    public int add_vertex(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        this.pointVector.addElement(nArray);
        return this.pointVector.size();
    }

    public boolean contains(int n, int n2) {
        int n3;
        if (this.isOpen()) {
            return false;
        }
        GRect gRect = this.getBounds();
        if (!gRect.contains(n, n2)) {
            return false;
        }
        boolean bl = false;
        int n4 = n3 = this.pointVector.size();
        int n5 = 0;
        while (--n4 >= 0) {
            block6: {
                block8: {
                    int[] nArray;
                    int[] nArray2;
                    block7: {
                        nArray2 = this.getPoint(n4);
                        if (nArray2[0] >= (nArray = this.getPoint(n5))[0] ? n < nArray[0] || n > nArray2[0] : n < nArray2[0] || n > nArray[0]) break block6;
                        if (nArray[0] != nArray2[0]) break block7;
                        if (nArray2[0] <= n2) break block8;
                        break block6;
                    }
                    int n6 = nArray2[1] + (int)Math.ceil((double)(nArray[1] - nArray2[1]) / (double)(nArray[0] - nArray2[0]) * (double)(n - nArray2[0]));
                    if (n6 > n2 || (nArray2[1] >= nArray[1] ? n6 < nArray[1] || n6 > nArray2[1] : n6 < nArray2[1] || n6 > nArray[1])) break block6;
                }
                bl = !bl;
            }
            n5 = n4;
        }
        return bl;
    }

    public boolean does_side_cross_rect(GRect gRect, int n) {
        int[] nArray;
        int[] nArray2 = this.getPoint(n);
        int n2 = nArray2[0] < (nArray = this.getPoint(n + 1))[0] ? nArray2[0] : nArray[0];
        int n3 = nArray2[1] < nArray[1] ? nArray2[1] : nArray[1];
        int n4 = nArray2[0] + nArray[0] - n2;
        int n5 = nArray2[1] + nArray[1] - n3;
        if (n4 < gRect.xmin || n2 > gRect.xmax || n5 < gRect.ymin || n3 > gRect.ymax) {
            return false;
        }
        return nArray2[0] >= gRect.xmin && nArray2[0] <= gRect.xmax && nArray2[1] >= gRect.ymin && nArray2[1] <= gRect.ymax || nArray[0] >= gRect.xmin && nArray[0] <= gRect.xmax && nArray[1] >= gRect.ymin && nArray[1] <= gRect.ymax || Poly.do_segments_intersect(gRect.xmin, gRect.ymin, gRect.xmax, gRect.ymax, nArray2, nArray) || Poly.do_segments_intersect(gRect.xmax, gRect.ymin, gRect.xmin, gRect.ymax, nArray2, nArray);
    }

    public Poly init(int[] nArray, int[] nArray2, int n, boolean bl) {
        int n2;
        this.setOpen(bl);
        for (n2 = 0; n2 < n - 1; ++n2) {
            this.add_vertex(nArray[n2], nArray2[n2]);
        }
        if (nArray[n2] != nArray[0] || nArray2[n2] != nArray2[0]) {
            this.add_vertex(nArray[n2], nArray2[n2]);
        }
        this.optimize_data();
        return this;
    }

    public Poly init(int[] nArray, int[] nArray2, int n) {
        return this.init(nArray, nArray2, n, false);
    }

    public void map(Mapper mapper) {
        for (int i = 0; i < this.pointVector.size(); ++i) {
            int[] nArray = this.getPoint(i);
            nArray[0] = mapper.mapX(nArray[0], nArray[1]);
            nArray[1] = mapper.mapY(nArray[0], nArray[1]);
        }
        this.reset();
    }

    public void move(int n, int n2) {
        if (n != 0 || n2 != 0) {
            for (int i = 0; i < this.pointVector.size(); ++i) {
                int[] nArray = this.getPoint(i);
                nArray[0] = nArray[0] + n;
                nArray[1] = nArray[1] + n2;
            }
            if (this.bounds != null) {
                super.move(n, n2);
            }
        }
    }

    public void move_vertex(int n, int n2, int n3) {
        int[] nArray = this.getPoint(n);
        nArray[0] = n2;
        nArray[1] = n3;
        this.reset();
    }

    public void optimize_data() {
        int n = 0;
        while (n < this.size()) {
            if (this.getPoint(n)[0] == this.getPoint(n + 1)[0] && this.getPoint(n)[1] == this.getPoint(n + 1)[1]) {
                this.removePoint(n);
                continue;
            }
            ++n;
        }
        n = 0;
        while (n < this.size()) {
            if ((this.isOpen() && n + 1 < this.size() || !this.isOpen()) && Poly.are_segments_parallel(this.getPoint(n), this.getPoint(n + 1), this.getPoint(n + 1), this.getPoint(n + 2))) {
                this.removePoint(n + 1);
                continue;
            }
            ++n;
        }
    }

    public void resize(int n, int n2) {
        GRect gRect = this.getBounds();
        this.reset();
        int n3 = gRect.width();
        int n4 = gRect.height();
        if (n3 != n || n4 != n2) {
            for (int i = 0; i < this.pointVector.size(); ++i) {
                int[] nArray = this.getPoint(i);
                nArray[0] = gRect.xmin + (nArray[0] - gRect.xmin) * n / n3;
                nArray[1] = gRect.ymin + (nArray[1] - gRect.ymin) * n2 / n4;
            }
        }
    }

    public void rotateArea(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        switch (n %= 4) {
            case 1: {
                for (n5 = 0; n5 < this.pointVector.size(); ++n5) {
                    int[] nArray = this.getPoint(n5);
                    n4 = nArray[0];
                    nArray[0] = n3 - nArray[1];
                    nArray[1] = n4;
                }
                break;
            }
            case 2: {
                for (n5 = 0; n5 < this.pointVector.size(); ++n5) {
                    int[] nArray = this.getPoint(n5);
                    nArray[0] = n2 - nArray[0];
                    nArray[1] = n3 - nArray[1];
                }
                break;
            }
            case 3: {
                for (n5 = 0; n5 < this.pointVector.size(); ++n5) {
                    int[] nArray = this.getPoint(n5);
                    n4 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n2 - n4;
                }
                break;
            }
        }
        this.reset();
    }

    public int size() {
        return this.isOpen() ? this.pointVector.size() - 1 : this.pointVector.size();
    }

    public void transform(GRect gRect) {
        GRect gRect2 = this.getBounds();
        if (gRect.xmin != gRect2.xmin || gRect.ymin != gRect2.ymin || gRect.xmax != gRect2.xmax || gRect.ymax != gRect2.ymax) {
            int n = gRect2.xmax - gRect2.xmin;
            int n2 = gRect2.ymax - gRect2.ymin;
            int n3 = gRect2.xmin;
            int n4 = gRect2.ymin;
            for (int i = 0; i < this.pointVector.size(); ++i) {
                int[] nArray = this.getPoint(i);
                nArray[0] = gRect.xmin + (nArray[0] - n3) * gRect.width() / n;
                nArray[1] = gRect.ymin + (nArray[1] - n4) * gRect.height() / n2;
            }
            this.reset();
        }
    }

    public void unmap(Mapper mapper) {
        for (int i = 0; i < this.pointVector.size(); ++i) {
            int[] nArray = this.getPoint(i);
            nArray[0] = mapper.unmapX(nArray[0], nArray[1]);
            nArray[1] = mapper.unmapY(nArray[0], nArray[1]);
        }
        this.reset();
    }

    public void reset() {
        this.bounds = null;
        this.hasValidData = null;
        super.reset();
    }

    private int[] getPoint(int n) {
        return (int[])this.pointVector.elementAt(n % this.pointVector.size());
    }

    private static boolean are_segments_parallel(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return (nArray2[0] - nArray[0]) * (nArray4[1] - nArray3[1]) - (nArray2[1] - nArray[1]) * (nArray4[0] - nArray3[0]) == 0;
    }

    private static boolean do_segments_intersect(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5 = (n - nArray[0]) * (nArray2[1] - nArray[1]) - (n2 - nArray[1]) * (nArray2[0] - nArray[0]);
        int n6 = (n3 - nArray[0]) * (nArray2[1] - nArray[1]) - (n4 - nArray[1]) * (nArray2[0] - nArray[0]);
        int n7 = (nArray[0] - n) * (n4 - n2) - (nArray[1] - n2) * (n3 - n);
        int n8 = (nArray2[0] - n) * (n4 - n2) - (nArray2[1] - n2) * (n3 - n);
        if (n5 == 0 && n6 == 0) {
            return Poly.is_projection_on_segment(n, n2, nArray[0], nArray[1], nArray2[0], nArray2[1]) || Poly.is_projection_on_segment(n3, n4, nArray[0], nArray[1], nArray2[0], nArray2[1]) || Poly.is_projection_on_segment(nArray[0], nArray[1], n, n2, n3, n4) || Poly.is_projection_on_segment(nArray2[0], nArray2[1], n, n2, n3, n4);
        }
        int n9 = Poly.sign(n5) * Poly.sign(n6);
        int n10 = Poly.sign(n7) * Poly.sign(n8);
        return n9 <= 0 && n10 <= 0;
    }

    private static boolean is_projection_on_segment(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n - n3) * (n5 - n3) + (n2 - n4) * (n6 - n4);
        int n8 = (n - n5) * (n5 - n3) + (n2 - n6) * (n6 - n4);
        return Poly.sign(n7) * Poly.sign(n8) <= 0;
    }

    private void removePoint(int n) {
        this.pointVector.removeElementAt(n % this.pointVector.size());
    }

    private static int sign(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

