/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu.anno;

import com.lizardtech.djvu.BSInputStream;
import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.NumContext;
import com.lizardtech.djvu.anno.Line;
import com.lizardtech.djvu.anno.Oval;
import com.lizardtech.djvu.anno.Poly;
import com.lizardtech.djvu.anno.Rect;
import com.lizardtech.djvu.anno.Text;
import java.io.IOException;
import java.util.Vector;

public class DjVuAnno
extends DjVuObject
implements Codec {
    private static final String PNOTE_TAG = "pnote";
    private static final String BACKGROUND_COLOR_TAG = "background";
    private static final String ZOOM_TAG = "zoom";
    private static final String MODE_TAG = "mode";
    private static final String ALIGN_TAG = "align";
    public static final long DEFAULT_BG_COLOR = -1L;
    public static final String[] ZOOM_STRING_ARRAY = new String[]{"default", "page", "width", "one2one", "stretch"};
    public static final String[] MODE_STRING_ARRAY = new String[]{"default", "color", "fore", "back", "bw"};
    public static final String[] ALIGN_STRING_ARRAY = new String[]{"default", "left", "center", "right", "top", "bottom"};
    public static final int UNSPEC = 0;
    public static final int COLOR = 1;
    public static final int FOREGROUND = 2;
    public static final int BACKGROUND = 3;
    public static final int BITONAL = 4;
    public static final int STRETCH = -4;
    public static final int ONE2ONE = -3;
    public static final int FIT_WIDTH = -2;
    public static final int FIT_PAGE = -1;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    private String raw = null;
    private Vector map_area = new Vector();
    private int hor_align = 0;
    private int mode = 0;
    private int ver_align = 0;
    private int zoom = 0;
    private long bg_color = -1L;
    static /* synthetic */ Class class$com$lizardtech$djvu$anno$DjVuAnno;

    public boolean isImageData() {
        return false;
    }

    public static DjVuAnno createDjVuAnno(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (DjVuAnno)DjVuObject.create(djVuOptions, djVuOptions.getDjVuAnnoClass(), class$com$lizardtech$djvu$anno$DjVuAnno == null ? (class$com$lizardtech$djvu$anno$DjVuAnno = DjVuAnno.class$("com.lizardtech.djvu.anno.DjVuAnno")) : class$com$lizardtech$djvu$anno$DjVuAnno);
    }

    public void setHorAlign(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.hor_align = n;
                return;
            }
        }
        this.hor_align = 0;
    }

    public int getHorAlign() {
        return this.hor_align;
    }

    public void setMapArea(Vector vector) {
        this.map_area = vector;
    }

    public Vector getMapArea() {
        return this.map_area;
    }

    public void setMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mode = n;
                return;
            }
        }
        this.mode = 0;
    }

    public int getMode() {
        return this.mode;
    }

    public void setRaw(StringBuffer stringBuffer) {
        int n;
        String string = this.raw;
        int n2 = n = stringBuffer != null ? stringBuffer.length() : 0;
        while (n > 0) {
            if (Character.isWhitespace(stringBuffer.charAt(--n))) continue;
            ++n;
            break;
        }
        if (n == 0) {
            this.raw = null;
        } else {
            stringBuffer.setLength(n);
            this.raw = stringBuffer.toString();
        }
        if (!(string == this.raw || string != null && string.equals(this.raw))) {
            this.decode(new LispParser(this.raw));
        }
    }

    public void setRaw(String string) {
        this.setRaw(string != null ? new StringBuffer(string) : null);
    }

    public String getRaw() {
        return this.raw;
    }

    public void setVerAlign(int n) {
        switch (n) {
            case 2: 
            case 4: 
            case 5: {
                this.ver_align = n;
                return;
            }
        }
        this.ver_align = 0;
    }

    public int getVerAlign() {
        return this.ver_align;
    }

    public void setZoom(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                this.zoom = n;
                return;
            }
        }
        this.zoom = n <= 0 ? 0 : n;
    }

    public int getZoom() {
        return this.zoom;
    }

    public static int cvt_color(String string, int n) {
        if (string != null && string.length() >= 2 && string.charAt(0) == '#') {
            try {
                n = (int)Long.parseLong(string.substring(1), 16);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return n;
    }

    public void decode(CachedInputStream cachedInputStream) throws IOException {
        String string;
        if ("ANTz".equals(cachedInputStream.getName())) {
            cachedInputStream = CachedInputStream.createCachedInputStream(this).init(BSInputStream.createBSInputStream(this).init(cachedInputStream));
            cachedInputStream.setName("ANTa");
        }
        if ((string = cachedInputStream.readFullyUTF()) != null && string.length() > 0) {
            String string2 = this.getRaw();
            this.setRaw(string2 != null ? string2 + string : string);
        }
    }

    public long get_bg_color() {
        return this.bg_color;
    }

    public DjVuAnno init(CachedInputStream cachedInputStream) throws IOException {
        this.setRaw(((CachedInputStream)cachedInputStream.clone()).readFullyUTF());
        return this;
    }

    public boolean is_empty() {
        return this.getRaw() == null;
    }

    public void set_bg_color(long l) {
        this.bg_color = l;
    }

    private static long convert_bg_color(String string) {
        return string == null || string.length() == 0 ? -1L : (long)DjVuAnno.cvt_color(string, 0xFFFFFF);
    }

    private static int decode_comp(char c, char c2) {
        int n = 0;
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                n = c - 48;
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                n = 10 + c - 65;
                break;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                n = 10 + c - 97;
                break;
            }
            default: {
                return 0;
            }
        }
        switch (c2) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return n << 4 | c2 - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return n << 4 | 10 + c2 - 65;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return n << 4 | 10 + c2 - 97;
            }
        }
        return n;
    }

    private static void del_all_items(String string, LispParser lispParser) {
        int n = lispParser.size();
        while (n > 0) {
            NamedVector namedVector;
            Object e;
            if (!((e = lispParser.elementAt(--n)) instanceof NamedVector) || !string.equals((namedVector = (NamedVector)e).getName())) continue;
            lispParser.removeElementAt(n);
        }
    }

    private static int lookupAlign(String string) {
        int n = 0;
        while (++n < ALIGN_STRING_ARRAY.length) {
            if (!ALIGN_STRING_ARRAY[n].equals(string)) continue;
            return n;
        }
        return 0;
    }

    private static int lookupMode(String string) {
        int n = 0;
        while (++n < MODE_STRING_ARRAY.length) {
            if (!MODE_STRING_ARRAY[n].equals(string)) continue;
            return n;
        }
        return 0;
    }

    private static int lookupZoom(String string, boolean bl) {
        int n = 0;
        while (++n < ZOOM_STRING_ARRAY.length) {
            if (!ZOOM_STRING_ARRAY[n].equals(string)) continue;
            return -n;
        }
        try {
            if (string.charAt(0) == 'd') {
                return Integer.parseInt(string.substring(1));
            }
            if (bl) {
                return Integer.parseInt(string);
            }
            throw new IllegalArgumentException("DjVuAnno.bad_zoom");
        }
        catch (RuntimeException runtimeException) {
            if (!bl) {
                throw runtimeException;
            }
            return 0;
        }
    }

    private static int parseHorAlign(LispParser lispParser) {
        NamedVector namedVector = lispParser.getNamedVector(ALIGN_TAG);
        return namedVector != null && namedVector.size() > 0 ? DjVuAnno.lookupAlign(namedVector.elementAt(0).toString()) : 0;
    }

    private void decode(LispParser lispParser) {
        this.set_bg_color(DjVuAnno.parse_bg_color(lispParser));
        this.setZoom(DjVuAnno.parseZoom(lispParser));
        this.setMode(DjVuAnno.parseMode(lispParser));
        this.setHorAlign(DjVuAnno.parseHorAlign(lispParser));
        this.setVerAlign(DjVuAnno.parseVerAlign(lispParser));
        this.setMapArea(this.parseMapArea(lispParser));
    }

    private static int parseVerAlign(LispParser lispParser) {
        NamedVector namedVector = lispParser.getNamedVector(ALIGN_TAG);
        return namedVector != null && namedVector.size() > 1 ? DjVuAnno.lookupAlign(namedVector.elementAt(1).toString()) : 0;
    }

    private static int parseZoom(LispParser lispParser) {
        NamedVector namedVector = lispParser.getNamedVector(ZOOM_TAG);
        return namedVector != null && namedVector.size() > 0 ? DjVuAnno.lookupZoom(namedVector.elementAt(0).toString(), true) : 0;
    }

    private static long parse_bg_color(LispParser lispParser) {
        long l = -1L;
        try {
            NamedVector namedVector = lispParser.getNamedVector(BACKGROUND_COLOR_TAG);
            if (namedVector != null && namedVector.size() == 1) {
                l = DjVuAnno.convert_bg_color(namedVector.elementAt(0).toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    private Vector parseMapArea(LispParser lispParser) {
        Vector<Rect> vector = new Vector<Rect>();
        for (int i = 0; i < lispParser.size(); ++i) {
            NamedVector namedVector;
            String string;
            Object e = lispParser.elementAt(i);
            if (!(e instanceof NamedVector) || !"maparea".equals(string = (namedVector = (NamedVector)e).getName())) continue;
            try {
                int n;
                int n2;
                Object object;
                Object object2;
                String string2 = null;
                String string3 = "_self";
                Object e2 = namedVector.elementAt(0);
                if (e2 instanceof NamedVector) {
                    object2 = (NamedVector)e2;
                    if (!"url".equals(((NamedVector)object2).getName())) {
                        throw new IllegalArgumentException("DjVuAnno.bad_url");
                    }
                    string2 = ((Vector)object2).elementAt(0).toString();
                    string3 = ((Vector)object2).elementAt(1).toString();
                } else {
                    string2 = (String)e2;
                }
                object2 = (String)namedVector.elementAt(1);
                Object e3 = namedVector.elementAt(2);
                Rect rect = null;
                if (e3 instanceof NamedVector) {
                    NamedVector namedVector2 = (NamedVector)e3;
                    if ("rect".equals(namedVector2.getName())) {
                        object = new GRect(((Number)namedVector2.elementAt(0)).intValue(), ((Number)namedVector2.elementAt(1)).intValue(), ((Number)namedVector2.elementAt(2)).intValue(), ((Number)namedVector2.elementAt(3)).intValue());
                        rect = Rect.createRect(this).init((GRect)object);
                    } else if ("line".equals(namedVector2.getName())) {
                        int n3 = ((Number)namedVector2.elementAt(0)).intValue();
                        int n4 = ((Number)namedVector2.elementAt(1)).intValue();
                        int n5 = ((Number)namedVector2.elementAt(2)).intValue();
                        n2 = ((Number)namedVector2.elementAt(3)).intValue();
                        rect = Line.createLine(this).init(n3, n4, n5, n2);
                    } else if ("poly".equals(namedVector2.getName())) {
                        int n6 = namedVector2.size() / 2;
                        int[] nArray = new int[n6];
                        int[] nArray2 = new int[n6];
                        n2 = 0;
                        n = 0;
                        while (n < namedVector2.size()) {
                            nArray[n2] = ((Number)namedVector2.elementAt(n++)).intValue();
                            nArray2[n2] = ((Number)namedVector2.elementAt(n++)).intValue();
                            ++n2;
                        }
                        rect = Poly.createPoly(this).init(nArray, nArray2, n6);
                    } else if ("oval".equals(namedVector2.getName())) {
                        object = new GRect(((Number)namedVector2.elementAt(0)).intValue(), ((Number)namedVector2.elementAt(1)).intValue(), ((Number)namedVector2.elementAt(2)).intValue(), ((Number)namedVector2.elementAt(3)).intValue());
                        rect = Oval.createOval(this).init((GRect)object);
                    } else if ("text".equals(namedVector2.getName())) {
                        object = new GRect(((Number)namedVector2.elementAt(0)).intValue(), ((Number)namedVector2.elementAt(1)).intValue(), ((Number)namedVector2.elementAt(2)).intValue(), ((Number)namedVector2.elementAt(3)).intValue());
                        rect = Text.createText(this).init((GRect)object);
                    }
                }
                if (rect == null || rect.isEmpty()) continue;
                rect.setURL(string2);
                rect.setTarget(string3);
                rect.setComment((String)object2);
                for (int j = 3; j < namedVector.size(); ++j) {
                    object = namedVector.elementAt(j);
                    if (!(object instanceof NamedVector)) continue;
                    NamedVector namedVector3 = (NamedVector)object;
                    String string4 = namedVector3.getName();
                    if ("border_avis".equals(string4)) {
                        rect.setBorderAlwaysVisible(true);
                        continue;
                    }
                    if ("arrow".equals(string4)) {
                        rect.setArrow(true);
                        continue;
                    }
                    if ("pushpin".equals(string4)) {
                        rect.setPushpin(true);
                        continue;
                    }
                    if ("hilite".equals(string4)) {
                        Object e4 = namedVector3.elementAt(0);
                        if (!(e4 instanceof Symbol)) continue;
                        rect.setHiliteColor(new Integer(DjVuAnno.cvt_color(e4.toString(), 255)));
                        continue;
                    }
                    if ("lineclr".equals(string4)) {
                        Object e5 = namedVector3.elementAt(0);
                        if (!(e5 instanceof Symbol)) continue;
                        rect.setLineColor(new Integer(DjVuAnno.cvt_color(e5.toString(), 255)));
                        continue;
                    }
                    if ("backclr".equals(string4)) {
                        Object e6 = namedVector3.elementAt(0);
                        if (!(e6 instanceof Symbol)) continue;
                        rect.setBgColor(new Integer(DjVuAnno.cvt_color(e6.toString(), 255)));
                        continue;
                    }
                    if ("textclr".equals(string4)) {
                        Object e7 = namedVector3.elementAt(0);
                        if (!(e7 instanceof Symbol)) continue;
                        rect.setTextColor(new Integer(DjVuAnno.cvt_color(e7.toString(), 255)));
                        continue;
                    }
                    if ("opacity".equals(string4)) {
                        Object e8 = namedVector3.elementAt(0);
                        if (!(e8 instanceof Integer)) continue;
                        rect.setOpacity((Integer)e8);
                        continue;
                    }
                    if ("width".equals(string4)) {
                        Object e9 = namedVector3.elementAt(0);
                        if (!(e9 instanceof Integer)) continue;
                        rect.setLineWidth((Integer)e9);
                        continue;
                    }
                    int n7 = "none".equals(string4) ? 0 : ("xor".equals(string4) ? 1 : ("border".equals(string4) ? 2 : ("shadow_in".equals(string4) ? 3 : ("shadow_out".equals(string4) ? 4 : ("shadow_ein".equals(string4) ? 5 : (n2 = "shadow_eout".equals(string4) ? 6 : -1))))));
                    if (n2 < 0) continue;
                    rect.setBorderType(n2);
                    for (n = 0; n < namedVector3.size(); ++n) {
                        Object e10 = namedVector3.elementAt(n);
                        if (e10 instanceof Symbol) {
                            rect.setBorderColor(new Integer(DjVuAnno.cvt_color(e10.toString(), 255)));
                            continue;
                        }
                        if (!(e10 instanceof Number)) continue;
                        rect.setBorderWidth(((Number)e10).intValue());
                    }
                }
                vector.addElement(rect);
                continue;
            }
            catch (Throwable throwable) {
                DjVuObject.printStackTrace(throwable);
            }
        }
        return vector;
    }

    private static int parseMode(LispParser lispParser) {
        NamedVector namedVector = lispParser.getNamedVector(MODE_TAG);
        return namedVector != null && namedVector.size() > 0 ? DjVuAnno.lookupMode(namedVector.elementAt(0).toString()) : 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class Symbol {
        private final String symbol;

        Symbol(String string) {
            this.symbol = string;
        }

        public String toString() {
            return this.symbol;
        }
    }

    static class NamedVector
    extends Vector {
        private final String name;

        NamedVector(String string) {
            this.name = string;
        }

        final String getName() {
            return this.name;
        }
    }

    static class LispParser
    extends NamedVector {
        public LispParser(String string) {
            super("toplevel");
            NumContext numContext = new NumContext(0);
            LispParser.parse(this, string, numContext);
        }

        public NamedVector getNamedVector(String string, boolean bl) {
            if (bl) {
                int n = this.size();
                while (--n >= 0) {
                    Object e = this.elementAt(n);
                    if (!(e instanceof NamedVector) || !string.equals(((NamedVector)e).getName())) continue;
                    return (NamedVector)e;
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    NamedVector namedVector;
                    Object e = this.elementAt(i);
                    if (!(e instanceof NamedVector) || !string.equals((namedVector = (NamedVector)e).getName())) continue;
                    return namedVector;
                }
            }
            return null;
        }

        public NamedVector getNamedVector(String string) {
            return this.getNamedVector(string, true);
        }

        private static Token getToken(String string, NumContext numContext) {
            int n = LispParser.skip_white_space(string, numContext.intValue());
            char c = string.charAt(n);
            switch (c) {
                case '(': {
                    numContext.set(n + 1);
                    return new Token(0, null);
                }
                case ')': {
                    numContext.set(n + 1);
                    return new Token(1, null);
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int n2;
                    int n3 = n;
                    for (n2 = n3 + 1; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
                    }
                    numContext.set(n2);
                    return new Token(2, new Integer(string.substring(n3, n2)));
                }
                case '\"': {
                    StringBuffer stringBuffer = new StringBuffer();
                    char c2 = '\u0000';
                    int n4 = 0;
                    while (true) {
                        if ((c2 = string.charAt(++n)) == '\\') {
                            ++n4;
                        } else if (c2 == '\"') {
                            stringBuffer.setLength(stringBuffer.length() - (n4 + 1) / 2);
                            if ((n4 & 1) == 0) break;
                            n4 = 0;
                        } else {
                            n4 = 0;
                        }
                        stringBuffer.append(c2);
                    }
                    numContext.set(n + 1);
                    return new Token(2, stringBuffer.toString());
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            while (true) {
                char c3;
                if ((c3 = string.charAt(++n)) == ')') {
                    --n;
                    break;
                }
                if (Character.isWhitespace(c3)) break;
                stringBuffer.append(c3);
            }
            numContext.set(n + 1);
            return new Token(2, new Symbol(stringBuffer.toString()));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void parse(NamedVector namedVector, String string, NumContext numContext) {
            try {
                block6: while (numContext.intValue() < string.length()) {
                    Token token = LispParser.getToken(string, numContext);
                    switch (token.type) {
                        case 0: {
                            if (Character.isWhitespace(string.charAt(numContext.intValue()))) {
                                throw new IllegalArgumentException("Expected Token");
                            }
                            Token token2 = LispParser.getToken(string, numContext);
                            Symbol symbol = (Symbol)token2.object;
                            NamedVector namedVector2 = new NamedVector(symbol.toString());
                            LispParser.parse(namedVector2, string, numContext);
                            namedVector.addElement(namedVector2);
                            continue block6;
                        }
                        case 1: {
                            return;
                        }
                    }
                    namedVector.addElement(token.object);
                }
                return;
            }
            catch (Throwable throwable) {
                DjVuObject.printStackTrace(throwable);
            }
        }

        private static int skip_white_space(String string, int n) {
            while (Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            return n;
        }

        static final class Token {
            static final int OPEN_PAR = 0;
            static final int CLOSE_PAR = 1;
            static final int OBJECT = 2;
            final Object object;
            final int type;

            Token(int n, Object object) {
                this.type = n;
                this.object = object;
            }
        }
    }
}

