/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.JB2Decode;
import com.lizardtech.djvu.JB2Shape;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class JB2Dict
extends DjVuObject
implements Cloneable,
Codec {
    public String comment = "";
    private JB2Dict inherited_dict = null;
    private Vector shapes = new Vector();
    private int inherited_shapes = 0;
    static /* synthetic */ Class class$com$lizardtech$djvu$JB2Dict;

    public boolean isImageData() {
        return false;
    }

    public static JB2Dict createJB2Dict(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (JB2Dict)DjVuObject.create(djVuOptions, djVuOptions.getJB2DictClass(), class$com$lizardtech$djvu$JB2Dict == null ? (class$com$lizardtech$djvu$JB2Dict = JB2Dict.class$("com.lizardtech.djvu.JB2Dict")) : class$com$lizardtech$djvu$JB2Dict);
    }

    public Object clone() {
        JB2Dict jB2Dict = this;
        try {
            jB2Dict = (JB2Dict)super.clone();
            if (this.get_inherited_dict() != null) {
                jB2Dict.set_inherited_dict((JB2Dict)this.get_inherited_dict().clone(), true);
            }
            if (this.shapes != null) {
                Vector<Object> vector;
                jB2Dict.shapes = vector = new Vector<Object>();
                Enumeration enumeration = this.shapes.elements();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(((JB2Shape)enumeration.nextElement()).clone());
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return jB2Dict;
    }

    public final JB2Dict get_inherited_dict() {
        return this.inherited_dict;
    }

    public final int get_inherited_shapes() {
        return this.inherited_shapes;
    }

    public final int get_shape_count() {
        return this.get_inherited_shapes() + this.shapes.size();
    }

    public int add_shape(JB2Shape jB2Shape) {
        if (jB2Shape.parent >= this.get_shape_count()) {
            throw new IllegalArgumentException("JB2Image bad parent shape");
        }
        int n = this.get_inherited_shapes() + this.shapes.size();
        this.shapes.addElement(jB2Shape);
        return n;
    }

    public final void decode(CachedInputStream cachedInputStream) throws IOException {
        this.decode((CachedInputStream)cachedInputStream.clone(), null);
    }

    public void decode(InputStream inputStream, JB2Dict jB2Dict) throws IOException {
        this.init();
        JB2Decode jB2Decode = JB2Decode.createJB2Decode(this);
        jB2Decode.init(inputStream, jB2Dict);
        jB2Decode.code(this);
    }

    public JB2Shape get_shape(int n) {
        JB2Shape jB2Shape;
        if (n >= this.get_inherited_shapes()) {
            jB2Shape = (JB2Shape)this.shapes.elementAt(n - this.get_inherited_shapes());
        } else if (this.get_inherited_dict() != null) {
            jB2Shape = this.get_inherited_dict().get_shape(n);
        } else {
            throw new IllegalStateException("JB2Image bad number");
        }
        return jB2Shape;
    }

    public void init() {
        this.set_inherited_dict(null);
        this.shapes.setSize(0);
    }

    public void set_inherited_dict(JB2Dict jB2Dict) {
        this.set_inherited_dict(jB2Dict, false);
    }

    public void set_inherited_dict(JB2Dict jB2Dict, boolean bl) {
        if (jB2Dict == null) {
            this.inherited_dict = null;
            this.inherited_shapes = 0;
            return;
        }
        if (!bl) {
            if (this.shapes.size() > 0) {
                throw new IllegalStateException("JB2Image cannot set");
            }
            if (this.get_inherited_dict() != null) {
                throw new IllegalStateException("JB2Image cannot change");
            }
        }
        this.inherited_dict = jB2Dict;
        this.inherited_shapes = jB2Dict.get_shape_count();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

