/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.BitContext;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GBitmap;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.JB2Blit;
import com.lizardtech.djvu.JB2Dict;
import com.lizardtech.djvu.JB2Image;
import com.lizardtech.djvu.JB2Shape;
import com.lizardtech.djvu.NumContext;
import java.io.IOException;
import java.util.Vector;

public abstract class JB2Codec
extends DjVuObject {
    protected static final int BIGPOSITIVE = 262142;
    protected static final int BIGNEGATIVE = -262143;
    protected static final byte START_OF_DATA = 0;
    protected static final byte NEW_MARK = 1;
    protected static final byte NEW_MARK_LIBRARY_ONLY = 2;
    protected static final byte NEW_MARK_IMAGE_ONLY = 3;
    protected static final byte MATCHED_REFINE = 4;
    protected static final byte MATCHED_REFINE_LIBRARY_ONLY = 5;
    protected static final byte MATCHED_REFINE_IMAGE_ONLY = 6;
    protected static final byte MATCHED_COPY = 7;
    protected static final byte NON_MARK_DATA = 8;
    protected static final byte REQUIRED_DICT_OR_RESET = 9;
    protected static final byte PRESERVED_COMMENT = 10;
    protected static final byte END_OF_DATA = 11;
    protected static final Integer MINUS_ONE_OBJECT = new Integer(-1);
    protected final BitContext dist_refinement_flag = new BitContext();
    protected final BitContext offset_type_dist = new BitContext();
    protected final NumContext abs_loc_x = new NumContext();
    protected final NumContext abs_loc_y = new NumContext();
    protected final NumContext abs_size_x = new NumContext();
    protected final NumContext abs_size_y = new NumContext();
    protected final NumContext dist_comment_byte = new NumContext();
    protected final NumContext dist_comment_length = new NumContext();
    protected final NumContext dist_match_index = new NumContext();
    protected final NumContext dist_record_type = new NumContext();
    protected final NumContext image_size_dist = new NumContext();
    protected final NumContext inherited_shape_count_dist = new NumContext();
    protected final NumContext rel_loc_x_current = new NumContext();
    protected final NumContext rel_loc_x_last = new NumContext();
    protected final NumContext rel_loc_y_current = new NumContext();
    protected final NumContext rel_loc_y_last = new NumContext();
    protected final NumContext rel_size_x = new NumContext();
    protected final NumContext rel_size_y = new NumContext();
    protected final Vector bitcells = new Vector();
    protected final Vector leftcell = new Vector();
    protected final Vector lib2shape = new Vector();
    protected final Vector libinfo = new Vector();
    protected final Vector rightcell = new Vector();
    protected final Vector shape2lib = new Vector();
    protected final int[] short_list = new int[3];
    protected byte[] bitdist = new byte[1024];
    protected byte[] cbitdist = new byte[2048];
    protected boolean gotstartrecordp = false;
    protected boolean refinementp = false;
    protected int image_columns = 0;
    protected int image_rows = 0;
    protected int last_bottom = 0;
    protected int last_left = 0;
    protected int last_right = 0;
    protected int last_row_bottom = 0;
    protected int last_row_left = 0;
    protected int short_list_pos = 0;
    private final boolean encoding;

    protected JB2Codec(boolean bl) {
        this.encoding = bl;
        int n = 0;
        while (n < this.bitdist.length) {
            this.bitdist[n++] = 0;
        }
        n = 0;
        while (n < this.cbitdist.length) {
            this.cbitdist[n++] = 0;
        }
        this.bitcells.addElement(new BitContext());
        this.leftcell.addElement(new NumContext());
        this.rightcell.addElement(new NumContext());
    }

    protected int codeNum(int n, int n2, NumContext numContext, int n3) throws IOException {
        boolean bl = false;
        int n4 = 0;
        int n5 = numContext.intValue();
        if (n5 >= this.bitcells.size()) {
            throw new ArrayIndexOutOfBoundsException("JB2Image bad numcontext");
        }
        int n6 = 1;
        int n7 = -1;
        while (n7 != 1) {
            boolean bl2;
            if (n5 == 0) {
                n5 = this.bitcells.size();
                numContext.set(n5);
                BitContext bitContext = new BitContext();
                NumContext numContext2 = new NumContext();
                NumContext numContext3 = new NumContext();
                this.bitcells.addElement(bitContext);
                this.leftcell.addElement(numContext2);
                this.rightcell.addElement(numContext3);
                bl2 = this.encoding ? (n < n4 && n2 >= n4 ? this.codeBit(n3 >= n4, bitContext) : n3 >= n4) : n >= n4 || n2 >= n4 && this.codeBit(false, bitContext);
                numContext = bl2 ? numContext3 : numContext2;
            } else {
                bl2 = this.encoding ? (n < n4 && n2 >= n4 ? this.codeBit(n3 >= n4, (BitContext)this.bitcells.elementAt(n5)) : n3 >= n4) : n >= n4 || n2 >= n4 && this.codeBit(false, (BitContext)this.bitcells.elementAt(n5));
                numContext = (NumContext)(bl2 ? this.rightcell.elementAt(n5) : this.leftcell.elementAt(n5));
            }
            switch (n6) {
                case 1: {
                    boolean bl3 = bl = !bl2;
                    if (bl) {
                        if (this.encoding) {
                            n3 = -n3 - 1;
                        }
                        int n8 = -n - 1;
                        n = -n2 - 1;
                        n2 = n8;
                    }
                    n6 = 2;
                    n4 = 1;
                    break;
                }
                case 2: {
                    if (!bl2) {
                        n6 = 3;
                        n7 = (n4 + 1) / 2;
                        if (n7 == 1) {
                            n4 = 0;
                            break;
                        }
                        n4 -= n7 / 2;
                        break;
                    }
                    n4 = 2 * n4 + 1;
                    break;
                }
                case 3: {
                    if ((n7 /= 2) != 1) {
                        if (!bl2) {
                            n4 -= n7 / 2;
                            break;
                        }
                        n4 += n7 / 2;
                        break;
                    }
                    if (bl2) break;
                    --n4;
                }
            }
            n5 = numContext.intValue();
        }
        return bl ? -n4 - 1 : n4;
    }

    protected abstract void code_absolute_location(JB2Blit var1, int var2, int var3) throws IOException;

    protected abstract void code_bitmap_by_cross_coding(GBitmap var1, GBitmap var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11) throws IOException;

    protected abstract void code_bitmap_directly(GBitmap var1, int var2, int var3, int var4, int var5, int var6) throws IOException;

    protected void code_eventual_lossless_refinement() throws IOException {
        this.refinementp = this.codeBit(this.refinementp, this.dist_refinement_flag);
    }

    protected abstract void code_inherited_shape_count(JB2Dict var1) throws IOException;

    protected final void code_absolute_mark_size(GBitmap gBitmap) throws IOException {
        this.code_absolute_mark_size(gBitmap, 0);
    }

    protected abstract void code_absolute_mark_size(GBitmap var1, int var2) throws IOException;

    protected void code_image_size(JB2Dict jB2Dict) throws IOException {
        this.last_left = 1;
        this.last_row_bottom = 0;
        this.last_right = 0;
        this.last_row_left = 0;
        this.fill_short_list(this.last_row_bottom);
        this.gotstartrecordp = true;
    }

    protected void code_image_size(JB2Image jB2Image) throws IOException {
        this.last_left = 1 + this.image_columns;
        this.last_row_bottom = this.image_rows;
        this.last_right = 0;
        this.last_row_left = 0;
        this.fill_short_list(this.last_row_bottom);
        this.gotstartrecordp = true;
    }

    protected int code_record_A(int n, JB2Dict jB2Dict, JB2Shape jB2Shape) throws IOException {
        GBitmap gBitmap = null;
        int n2 = -1;
        n = this.code_record_type(n);
        JB2Shape jB2Shape2 = jB2Shape;
        switch (n) {
            case 2: 
            case 5: {
                if (!this.encoding) {
                    jB2Shape2 = JB2Shape.createJB2Shape(this).init(-1);
                } else if (jB2Shape2 == null) {
                    jB2Shape2 = JB2Shape.createJB2Shape(this);
                }
                gBitmap = jB2Shape2.getGBitmap();
            }
        }
        switch (n) {
            case 0: {
                this.code_image_size(jB2Dict);
                this.code_eventual_lossless_refinement();
                if (this.encoding) break;
                this.init_library(jB2Dict);
                break;
            }
            case 2: {
                this.code_absolute_mark_size(gBitmap, 4);
                this.code_bitmap_directly(gBitmap);
                break;
            }
            case 5: {
                int n3 = this.code_match_index(jB2Shape2.parent, jB2Dict);
                if (!this.encoding) {
                    jB2Shape2.parent = ((Number)this.lib2shape.elementAt(n3)).intValue();
                }
                GBitmap gBitmap2 = jB2Dict.get_shape(jB2Shape2.parent).getGBitmap();
                GRect gRect = (GRect)this.libinfo.elementAt(n3);
                this.code_relative_mark_size(gBitmap, 1 + gRect.xmax - gRect.xmin, 1 + gRect.ymax - gRect.ymin, 4);
                this.code_bitmap_by_cross_coding(gBitmap, gBitmap2, jB2Shape2.parent);
                break;
            }
            case 10: {
                jB2Dict.comment = this.code_comment(jB2Dict.comment);
                break;
            }
            case 9: {
                if (!this.gotstartrecordp) {
                    this.code_inherited_shape_count(jB2Dict);
                    break;
                }
                this.reset_numcoder();
                break;
            }
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException("JB2Image bad type");
            }
        }
        if (!this.encoding) {
            switch (n) {
                case 2: 
                case 5: {
                    if (jB2Shape != null) {
                        jB2Shape2 = jB2Shape2.duplicate();
                    }
                    n2 = jB2Dict.add_shape(jB2Shape2);
                    this.add_library(n2, jB2Shape2);
                }
            }
        }
        return n;
    }

    protected int code_record_B(int n, JB2Image jB2Image, JB2Shape jB2Shape, JB2Blit jB2Blit) throws IOException {
        GBitmap gBitmap = null;
        int n2 = -1;
        JB2Shape jB2Shape2 = jB2Shape;
        JB2Blit jB2Blit2 = jB2Blit;
        n = this.code_record_type(n);
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                if (jB2Blit2 == null) {
                    jB2Blit2 = new JB2Blit();
                }
            }
            case 2: 
            case 5: {
                if (!this.encoding) {
                    jB2Shape2 = JB2Shape.createJB2Shape(this).init(n == 8 ? -2 : -1);
                } else if (jB2Shape2 == null) {
                    jB2Shape2 = JB2Shape.createJB2Shape(this);
                }
                gBitmap = jB2Shape2.getGBitmap();
                break;
            }
            case 7: {
                if (jB2Blit2 != null) break;
                jB2Blit2 = new JB2Blit();
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        switch (n) {
            case 0: {
                this.code_image_size(jB2Image);
                this.code_eventual_lossless_refinement();
                if (this.encoding) break;
                this.init_library(jB2Image);
                break;
            }
            case 1: {
                bl = true;
                bl2 = true;
                this.code_absolute_mark_size(gBitmap, 4);
                this.code_bitmap_directly(gBitmap);
                this.code_relative_location(jB2Blit2, gBitmap.rows(), gBitmap.columns());
                break;
            }
            case 2: {
                bl = true;
                this.code_absolute_mark_size(gBitmap, 4);
                this.code_bitmap_directly(gBitmap);
                break;
            }
            case 3: {
                bl2 = true;
                this.code_absolute_mark_size(gBitmap, 3);
                this.code_bitmap_directly(gBitmap);
                this.code_relative_location(jB2Blit2, gBitmap.rows(), gBitmap.columns());
                break;
            }
            case 4: {
                bl2 = true;
                bl = true;
                int n3 = this.code_match_index(jB2Shape2.parent, jB2Image);
                if (!this.encoding) {
                    jB2Shape2.parent = ((Number)this.lib2shape.elementAt(n3)).intValue();
                }
                GBitmap gBitmap2 = jB2Image.get_shape(jB2Shape2.parent).getGBitmap();
                GRect gRect = (GRect)this.libinfo.elementAt(n3);
                this.code_relative_mark_size(gBitmap, 1 + gRect.xmax - gRect.xmin, 1 + gRect.ymax - gRect.ymin, 4);
                this.code_bitmap_by_cross_coding(gBitmap, gBitmap2, n3);
                this.code_relative_location(jB2Blit2, gBitmap.rows(), gBitmap.columns());
                break;
            }
            case 5: {
                bl = true;
                int n4 = this.code_match_index(jB2Shape2.parent, jB2Image);
                if (!this.encoding) {
                    jB2Shape2.parent = ((Number)this.lib2shape.elementAt(n4)).intValue();
                }
                GBitmap gBitmap3 = jB2Image.get_shape(jB2Shape2.parent).getGBitmap();
                GRect gRect = (GRect)this.libinfo.elementAt(n4);
                this.code_relative_mark_size(gBitmap, 1 + gRect.xmax - gRect.xmin, 1 + gRect.ymax - gRect.ymin, 4);
                break;
            }
            case 6: {
                bl2 = true;
                int n5 = this.code_match_index(jB2Shape2.parent, jB2Image);
                if (!this.encoding) {
                    jB2Shape2.parent = ((Number)this.lib2shape.elementAt(n5)).intValue();
                }
                GBitmap gBitmap4 = jB2Image.get_shape(jB2Shape2.parent).getGBitmap();
                GRect gRect = (GRect)this.libinfo.elementAt(n5);
                this.code_relative_mark_size(gBitmap, 1 + gRect.xmax - gRect.xmin, 1 + gRect.ymax - gRect.ymin, 4);
                this.code_bitmap_by_cross_coding(gBitmap, gBitmap4, n5);
                this.code_relative_location(jB2Blit2, gBitmap.rows(), gBitmap.columns());
                break;
            }
            case 7: {
                int n6 = this.code_match_index(jB2Blit2.shapeno(), jB2Image);
                if (!this.encoding) {
                    jB2Blit2.shapeno(((Number)this.lib2shape.elementAt(n6)).intValue());
                }
                gBitmap = jB2Image.get_shape(jB2Blit2.shapeno()).getGBitmap();
                GRect gRect = (GRect)this.libinfo.elementAt(n6);
                jB2Blit2.leftAdd(gRect.xmin);
                jB2Blit2.bottomAdd(gRect.ymin);
                if (jB2Image.reproduce_old_bug) {
                    this.code_relative_location(jB2Blit2, gBitmap.rows(), gBitmap.columns());
                } else {
                    this.code_relative_location(jB2Blit2, 1 + gRect.ymax - gRect.ymin, 1 + gRect.xmax - gRect.xmin);
                }
                jB2Blit2.leftSubtract(gRect.xmin);
                jB2Blit2.bottomSubtract(gRect.ymin);
                break;
            }
            case 8: {
                bl2 = true;
                this.code_absolute_mark_size(gBitmap, 3);
                this.code_bitmap_directly(gBitmap);
                this.code_absolute_location(jB2Blit2, gBitmap.rows(), gBitmap.columns());
                break;
            }
            case 10: {
                jB2Image.comment = this.code_comment(jB2Image.comment);
                break;
            }
            case 9: {
                if (!this.gotstartrecordp) {
                    this.code_inherited_shape_count(jB2Image);
                    break;
                }
                this.reset_numcoder();
                break;
            }
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException("JB2Image unknown type");
            }
        }
        if (!this.encoding) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    if (jB2Shape != null) {
                        jB2Shape2 = jB2Shape2.duplicate();
                    }
                    n2 = jB2Image.add_shape(jB2Shape2);
                    this.shape2lib(n2, MINUS_ONE_OBJECT);
                    if (bl) {
                        this.add_library(n2, jB2Shape2);
                    }
                    if (!bl2) break;
                    jB2Blit2.shapeno(n2);
                    if (jB2Blit != null) {
                        jB2Blit2 = (JB2Blit)jB2Blit.clone();
                    }
                    jB2Image.add_blit(jB2Blit2);
                    break;
                }
                case 7: {
                    if (jB2Blit != null) {
                        jB2Blit2 = (JB2Blit)jB2Blit.clone();
                    }
                    jB2Image.add_blit(jB2Blit2);
                }
            }
        }
        return n;
    }

    protected final void code_relative_mark_size(GBitmap gBitmap, int n, int n2) throws IOException {
        this.code_relative_mark_size(gBitmap, n, n2, 0);
    }

    protected final void fill_short_list(int n) {
        this.short_list[1] = this.short_list[2] = n;
        this.short_list[0] = this.short_list[2];
        this.short_list_pos = 0;
    }

    protected final int get_cross_context(GBitmap gBitmap, GBitmap gBitmap2, int n, int n2, int n3, int n4, int n5, int n6) {
        return gBitmap.getByteAt(n + n6 - 1) << 10 | gBitmap.getByteAt(n + n6) << 9 | gBitmap.getByteAt(n + n6 + 1) << 8 | gBitmap.getByteAt(n2 + n6 - 1) << 7 | gBitmap2.getByteAt(n3 + n6) << 6 | gBitmap2.getByteAt(n4 + n6 - 1) << 5 | gBitmap2.getByteAt(n4 + n6) << 4 | gBitmap2.getByteAt(n4 + n6 + 1) << 3 | gBitmap2.getByteAt(n5 + n6 - 1) << 2 | gBitmap2.getByteAt(n5 + n6) << 1 | gBitmap2.getByteAt(n5 + n6 + 1);
    }

    protected final int get_direct_context(GBitmap gBitmap, int n, int n2, int n3, int n4) {
        return gBitmap.getByteAt(n + n4 - 1) << 9 | gBitmap.getByteAt(n + n4) << 8 | gBitmap.getByteAt(n + n4 + 1) << 7 | gBitmap.getByteAt(n2 + n4 - 2) << 6 | gBitmap.getByteAt(n2 + n4 - 1) << 5 | gBitmap.getByteAt(n2 + n4) << 4 | gBitmap.getByteAt(n2 + n4 + 1) << 3 | gBitmap.getByteAt(n2 + n4 + 2) << 2 | gBitmap.getByteAt(n3 + n4 - 2) << 1 | gBitmap.getByteAt(n3 + n4 - 1);
    }

    protected abstract void code_relative_mark_size(GBitmap var1, int var2, int var3, int var4) throws IOException;

    protected abstract int get_diff(int var1, NumContext var2) throws IOException;

    protected int add_library(int n, JB2Shape jB2Shape) {
        int n2 = this.lib2shape.size();
        this.lib2shape.addElement(new Integer(n));
        this.shape2lib(n, new Integer(n2));
        this.libinfo.addElement(jB2Shape.getGBitmap().compute_bounding_box());
        return n2;
    }

    protected void reset_numcoder() {
        this.dist_comment_byte.set(0);
        this.dist_comment_length.set(0);
        this.dist_record_type.set(0);
        this.dist_match_index.set(0);
        this.abs_loc_x.set(0);
        this.abs_loc_y.set(0);
        this.abs_size_x.set(0);
        this.abs_size_y.set(0);
        this.image_size_dist.set(0);
        this.inherited_shape_count_dist.set(0);
        this.rel_loc_x_current.set(0);
        this.rel_loc_x_last.set(0);
        this.rel_loc_y_current.set(0);
        this.rel_loc_y_last.set(0);
        this.rel_size_x.set(0);
        this.rel_size_y.set(0);
        this.bitcells.setSize(0);
        this.leftcell.setSize(0);
        this.rightcell.setSize(0);
        this.bitcells.addElement(new BitContext());
        this.leftcell.addElement(new NumContext());
        this.rightcell.addElement(new NumContext());
        if (DjVuOptions.COLLECT_GARBAGE) {
            System.gc();
        }
    }

    protected final void shape2lib(int n, Number number) {
        int n2 = this.shape2lib.size();
        if (n2 <= n) {
            while (n2++ < n) {
                this.shape2lib.addElement(MINUS_ONE_OBJECT);
            }
            this.shape2lib.addElement(number);
        } else {
            this.shape2lib.setElementAt(number, n);
        }
    }

    protected final int shift_cross_context(GBitmap gBitmap, GBitmap gBitmap2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n << 1 & 0x636 | gBitmap.getByteAt(n3 + n8 + 1) << 8 | gBitmap2.getByteAt(n5 + n8) << 6 | gBitmap2.getByteAt(n6 + n8 + 1) << 3 | gBitmap2.getByteAt(n7 + n8 + 1) | n2 << 7;
    }

    protected final int shift_direct_context(GBitmap gBitmap, int n, int n2, int n3, int n4, int n5, int n6) {
        return n << 1 & 0x37A | gBitmap.getByteAt(n4 + n6 + 2) << 2 | gBitmap.getByteAt(n3 + n6 + 1) << 7 | n2;
    }

    protected abstract boolean codeBit(boolean var1, BitContext var2) throws IOException;

    protected abstract int codeBit(boolean var1, byte[] var2, int var3) throws IOException;

    protected abstract String code_comment(String var1) throws IOException;

    protected abstract int code_match_index(int var1, JB2Dict var2) throws IOException;

    protected abstract int code_record_type(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void code_bitmap_by_cross_coding(GBitmap gBitmap, GBitmap gBitmap2, int n) throws IOException {
        GBitmap gBitmap3 = gBitmap;
        synchronized (gBitmap3) {
            int n2 = gBitmap2.columns();
            int n3 = gBitmap.columns();
            int n4 = gBitmap.rows();
            GRect gRect = (GRect)this.libinfo.elementAt(n);
            int n5 = 1 + n3 / 2 - n3 - ((1 + gRect.xmax - gRect.xmin) / 2 - gRect.xmax);
            int n6 = 1 + n4 / 2 - n4 - ((1 + gRect.ymax - gRect.ymin) / 2 - gRect.ymax);
            gBitmap.setMinimumBorder(2);
            gBitmap2.setMinimumBorder(2 - n5);
            gBitmap2.setMinimumBorder(2 + n3 + n5 - n2);
            int n7 = n4 - 1;
            int n8 = n7 + n6;
            this.code_bitmap_by_cross_coding(gBitmap, gBitmap2, n5, n3, n7, n8, gBitmap.rowOffset(n7 + 1), gBitmap.rowOffset(n7), gBitmap2.rowOffset(n8 + 1) + n5, gBitmap2.rowOffset(n8) + n5, gBitmap2.rowOffset(n8 - 1) + n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void code_bitmap_directly(GBitmap gBitmap) throws IOException {
        GBitmap gBitmap2 = gBitmap;
        synchronized (gBitmap2) {
            gBitmap.setMinimumBorder(3);
            int n = gBitmap.rows() - 1;
            this.code_bitmap_directly(gBitmap, gBitmap.columns(), n, gBitmap.rowOffset(n + 2), gBitmap.rowOffset(n + 1), gBitmap.rowOffset(n));
        }
    }

    protected void code_relative_location(JB2Blit jB2Blit, int n, int n2) throws IOException {
        boolean bl;
        if (!this.gotstartrecordp) {
            throw new IllegalStateException("JB2Image no start");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.encoding) {
            n4 = jB2Blit.left() + 1;
            n3 = jB2Blit.bottom() + 1;
            n6 = n4 + n2 - 1;
            n5 = n3 + n - 1;
        }
        if (bl = this.codeBit(n4 < this.last_left, this.offset_type_dist)) {
            int n7 = this.get_diff(n4 - this.last_row_left, this.rel_loc_x_last);
            int n8 = this.get_diff(n5 - this.last_row_bottom, this.rel_loc_y_last);
            if (!this.encoding) {
                n4 = this.last_row_left + n7;
                n5 = this.last_row_bottom + n8;
                n6 = n4 + n2 - 1;
                n3 = n5 - n + 1;
            }
            this.last_left = this.last_row_left = n4;
            this.last_right = n6;
            this.last_bottom = this.last_row_bottom = n3;
            this.fill_short_list(n3);
        } else {
            int n9 = this.get_diff(n4 - this.last_right, this.rel_loc_x_current);
            int n10 = this.get_diff(n3 - this.last_bottom, this.rel_loc_y_current);
            if (!this.encoding) {
                n4 = this.last_right + n9;
                n3 = this.last_bottom + n10;
                n6 = n4 + n2 - 1;
                n5 = n3 + n - 1;
            }
            this.last_left = n4;
            this.last_right = n6;
            this.last_bottom = this.update_short_list(n3);
        }
        if (!this.encoding) {
            jB2Blit.bottom(n3 - 1);
            jB2Blit.left(n4 - 1);
        }
    }

    protected void init_library(JB2Dict jB2Dict) {
        int n = jB2Dict.get_inherited_shapes();
        this.shape2lib.setSize(0);
        this.lib2shape.setSize(0);
        this.libinfo.setSize(0);
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(i);
            this.shape2lib.addElement(n2);
            this.lib2shape.addElement(n2);
            JB2Shape jB2Shape = jB2Dict.get_shape(i);
            this.libinfo.addElement(jB2Shape.getGBitmap().compute_bounding_box());
        }
    }

    protected int update_short_list(int n) {
        if (++this.short_list_pos == 3) {
            this.short_list_pos = 0;
        }
        this.short_list[this.short_list_pos] = n;
        return this.short_list[0] >= this.short_list[1] ? (this.short_list[0] > this.short_list[2] ? (this.short_list[1] >= this.short_list[2] ? this.short_list[1] : this.short_list[2]) : this.short_list[0]) : (this.short_list[0] < this.short_list[2] ? (this.short_list[1] >= this.short_list[2] ? this.short_list[2] : this.short_list[1]) : this.short_list[0]);
    }
}

