/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.IWBlock;

final class IWMap
extends DjVuObject
implements Cloneable {
    protected IWBlock[] blocks;
    protected int bh;
    protected int bw;
    protected int ih;
    protected int iw;
    protected int nb;
    protected int top;
    static /* synthetic */ Class class$com$lizardtech$djvu$IWMap;

    public IWMap() {
    }

    public IWMap(int n, int n2) {
        this.init(n, n2);
    }

    static void backward(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = n5 >> 1; i >= n6; i >>= 1) {
            int n7;
            for (n7 = 0; n7 < n2; n7 += i) {
                IWMap.backward_filter(sArray, n, n7, n7 + n3 * n4, n7, i * n4);
            }
            for (n7 = 0; n7 < n3; n7 += i) {
                IWMap.backward_filter(sArray, n, n7 * n4, n7 * n4 + n2, n7 * n4, i);
            }
        }
    }

    static void backward_filter(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8 = 3 * n5;
        if (n4 < n2 || n4 > n3) {
            DjVuObject.logError("(_IWCoeff::backward_filter) Out of bounds [b<=z<=e]");
        }
        int n9 = n4;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = n7 = n9 + n5 >= n3 ? 0 : sArray[n + n9 + n5];
        while (n9 + n8 < n3) {
            n12 = n11;
            n11 = n10;
            n10 = n7;
            n7 = sArray[n + n9 + n8];
            int n14 = n + n9;
            sArray[n14] = (short)(sArray[n14] - (9 * (n11 + n10) - (n12 + n7) + 16 >> 5));
            n9 = n9 + n8 - n5;
        }
        while (n9 < n3) {
            n12 = n11;
            n11 = n10;
            n10 = n7;
            n7 = 0;
            int n15 = n + n9;
            sArray[n15] = (short)(sArray[n15] - (9 * (n11 + n10) - (n12 + n7) + 16 >> 5));
            n9 = n9 + n5 + n5;
        }
        n9 = n4 + n5;
        n12 = 0;
        n11 = sArray[n + n9 - n5];
        n10 = n9 + n5 >= n3 ? 0 : sArray[n + n9 + n5];
        int n16 = n7 = n9 + n8 >= n3 ? 0 : sArray[n + n9 + n8];
        if (n9 < n3) {
            n6 = n11;
            if (n9 + n5 < n3) {
                n6 = n11 + n10 + 1 >> 1;
            }
            int n17 = n + n9;
            sArray[n17] = (short)(sArray[n17] + n6);
            n9 = n9 + n5 + n5;
        }
        while (n9 + n8 < n3) {
            n12 = n11;
            n11 = n10;
            n10 = n7;
            n7 = sArray[n + n9 + n8];
            n6 = 9 * (n11 + n10) - (n12 + n7) + 8 >> 4;
            int n18 = n + n9;
            sArray[n18] = (short)(sArray[n18] + n6);
            n9 = n9 + n8 - n5;
        }
        if (n9 + n5 < n3) {
            n12 = n11;
            n11 = n10;
            n10 = n7;
            n7 = 0;
            n6 = n11 + n10 + 1 >> 1;
            int n19 = n + n9;
            sArray[n19] = (short)(sArray[n19] + n6);
            n9 = n9 + n5 + n5;
        }
        if (n9 < n3) {
            n12 = n11;
            n11 = n10;
            n10 = n7;
            n7 = 0;
            n6 = n11;
            int n20 = n + n9;
            sArray[n20] = (short)(sArray[n20] + n6);
        }
    }

    public static IWMap createIWMap(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (IWMap)DjVuObject.create(djVuOptions, djVuOptions.getIWMapClass(), class$com$lizardtech$djvu$IWMap == null ? (class$com$lizardtech$djvu$IWMap = IWMap.class$("com.lizardtech.djvu.IWMap")) : class$com$lizardtech$djvu$IWMap);
    }

    public Object clone() {
        IWMap iWMap = null;
        try {
            iWMap = (IWMap)super.clone();
            IWBlock[] iWBlockArray = (IWBlock[])this.blocks.clone();
            iWMap.blocks = iWBlockArray;
            for (int i = 0; i < this.nb; ++i) {
                iWBlockArray[i] = (IWBlock)iWBlockArray[i].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return iWMap;
    }

    int get_bucket_count() {
        int n = 0;
        for (int i = 0; i < this.nb; ++i) {
            for (int j = 0; j < 64; ++j) {
                if (this.blocks[i].getBlock(j) == null) continue;
                ++n;
            }
        }
        return n;
    }

    void image(int n, byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        short[] sArray = new short[this.bw * this.bh];
        short[] sArray2 = new short[1024];
        int n7 = 0;
        IWBlock[] iWBlockArray = this.blocks;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < this.bh) {
            for (n6 = 0; n6 < this.bw; n6 += 32) {
                iWBlockArray[n8].write_liftblock(sArray2, 0, 64);
                ++n8;
                n9 = n7 + n6;
                n5 = 0;
                n4 = 0;
                while (n5++ < 32) {
                    System.arraycopy(sArray2, n4, sArray, n9, 32);
                    n4 += 32;
                    n9 += this.bw;
                }
            }
            n10 += 32;
            n7 += 32 * this.bw;
        }
        if (bl) {
            IWMap.backward(sArray, 0, this.iw, this.ih, this.bw, 32, 2);
            n7 = 0;
            n10 = 0;
            while (n10 < this.bh) {
                n6 = 0;
                while (n6 < this.bw) {
                    short s = sArray[n7];
                    sArray[n7 + 1] = s;
                    sArray[n7 + this.bw + 1] = s;
                    sArray[n7 + this.bw] = s;
                    n6 += 2;
                    n7 += 2;
                }
                n10 += 2;
                n7 += this.bw;
            }
        } else {
            IWMap.backward(sArray, 0, this.iw, this.ih, this.bw, 32, 1);
        }
        n7 = 0;
        n10 = 0;
        n6 = n;
        while (n10++ < this.ih) {
            n5 = 0;
            n4 = n6;
            while (n5 < this.iw) {
                int n11;
                if ((n11 = sArray[n7 + n5++] + 32 >> 6) < -128) {
                    n11 = -128;
                } else if (n11 > 127) {
                    n11 = 127;
                }
                byArray[n4] = (byte)n11;
                n4 += n3;
            }
            n6 += n2;
            n7 += this.bw;
        }
    }

    void image(int n, GRect gRect, int n2, byte[] byArray, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        for (n9 = 0; n9 < 5 && 32 >> n9 > n; ++n9) {
        }
        int n10 = 1 << n9;
        if (n != 32 >> n9) {
            throw new IllegalArgumentException("(IWMap::image) Unsupported subsampling factor");
        }
        if (gRect.isEmpty()) {
            throw new IllegalArgumentException("(IWMap::image) GRect is empty");
        }
        GRect gRect2 = new GRect(0, 0, (this.iw + n - 1) / n, (this.ih + n - 1) / n);
        if (gRect.xmin < 0 || gRect.ymin < 0 || gRect.xmax > gRect2.xmax || gRect.ymax > gRect2.ymax) {
            throw new IllegalArgumentException("(IWMap::image) GRect is out of bounds: " + gRect.xmin + "," + gRect.ymin + "," + gRect.xmax + "," + gRect.ymax + "," + gRect2.xmax + "," + gRect2.ymax);
        }
        GRect[] gRectArray = new GRect[8];
        GRect[] gRectArray2 = new GRect[8];
        int n11 = 0;
        while (n11 < 8) {
            gRectArray[n11] = new GRect();
            gRectArray2[n11++] = new GRect();
        }
        n11 = 1;
        gRectArray[n9] = (GRect)gRect.clone();
        gRectArray2[n9] = (GRect)gRect.clone();
        for (int i = n9 - 1; i >= 0; --i) {
            gRectArray[i] = gRectArray2[i + 1];
            gRectArray[i].inflate(3 * n11, 3 * n11);
            gRectArray[i].intersect(gRectArray[i], gRect2);
            n11 += n11;
            gRectArray2[i].xmin = gRectArray[i].xmin + n11 - 1 & ~(n11 - 1);
            gRectArray2[i].xmax = gRectArray[i].xmax & ~(n11 - 1);
            gRectArray2[i].ymin = gRectArray[i].ymin + n11 - 1 & ~(n11 - 1);
            gRectArray2[i].ymax = gRectArray[i].ymax & ~(n11 - 1);
        }
        GRect gRect3 = new GRect();
        gRect3.xmin = gRectArray[0].xmin & ~(n10 - 1);
        gRect3.ymin = gRectArray[0].ymin & ~(n10 - 1);
        gRect3.xmax = (gRectArray[0].xmax - 1 & ~(n10 - 1)) + n10;
        gRect3.ymax = (gRectArray[0].ymax - 1 & ~(n10 - 1)) + n10;
        int n12 = gRect3.width();
        short[] sArray = new short[n12 * gRect3.height()];
        int n13 = this.bw >> 5;
        int n14 = (gRect3.ymin >> n9) * n13 + (gRect3.xmin >> n9);
        short[] sArray2 = new short[1024];
        int n15 = gRect3.ymin;
        int n16 = 0;
        while (n15 < gRect3.ymax) {
            n8 = gRect3.xmin;
            n7 = n14;
            n6 = n16;
            while (n8 < gRect3.xmax) {
                IWBlock iWBlock = this.blocks[n7];
                n5 = n9;
                if (n9 > 2 && (n8 + 31 < gRectArray[2].xmin || n8 > gRectArray[2].xmax || n15 + 31 < gRectArray[2].ymin || n15 > gRectArray[2].ymax)) {
                    n5 = 2;
                }
                int n17 = (1 << n5 + n5) + 15 >> 4;
                int n18 = 1 << n9 - n5;
                int n19 = n12 << n9 - n5;
                int n20 = 32 >> n5;
                int n21 = n20 << 5;
                iWBlock.write_liftblock(sArray2, 0, n17);
                int n22 = 0;
                int n23 = 0;
                int n24 = n6;
                while (n22 < n10) {
                    int n25 = 0;
                    while (n25 < n10) {
                        sArray[n24 + n25] = sArray2[n23];
                        n25 += n18;
                        n23 += n20;
                    }
                    n22 += n18;
                    n24 += n19;
                    n23 += n21 - 32;
                }
                n8 += n10;
                ++n7;
                n6 += n10;
            }
            n15 += n10;
            n16 += n12 << n9;
            n14 += n13;
        }
        n11 = n10;
        for (n15 = 0; n15 < n9; ++n15) {
            GRect gRect4 = gRectArray[n15];
            gRect4.xmin &= ~(n11 - 1);
            gRect4.ymin &= ~(n11 - 1);
            gRect4.translate(-gRect3.xmin, -gRect3.ymin);
            if (bl && n15 >= 4) {
                n8 = gRect4.ymin;
                n7 = gRect4.ymin * n12;
                while (n8 < gRect4.ymax) {
                    for (n6 = gRect4.xmin; n6 < gRect4.xmax; n6 += 2) {
                        short s = sArray[n7 + n6];
                        sArray[n7 + n6 + 1] = s;
                        sArray[n7 + n6 + n12 + 1] = s;
                        sArray[n7 + n6 + n12] = s;
                    }
                    n8 += 2;
                    n7 += n12 + n12;
                }
                break;
            }
            IWMap.backward(sArray, gRect4.ymin * n12 + gRect4.xmin, gRect4.width(), gRect4.height(), n12, n11, n11 >> 1);
            n11 >>= 1;
        }
        GRect gRect5 = (GRect)gRect.clone();
        gRect5.translate(-gRect3.xmin, -gRect3.ymin);
        n16 = gRect5.ymin;
        n8 = gRect5.ymin * n12;
        n7 = n2;
        while (n16++ < gRect5.ymax) {
            n6 = gRect5.xmin;
            int n26 = n7;
            while (n6 < gRect5.xmax) {
                n5 = sArray[n8 + n6] + 32 >> 6;
                if (n5 < -128) {
                    n5 = -128;
                } else if (n5 > 127) {
                    n5 = 127;
                }
                byArray[n26] = (byte)n5;
                ++n6;
                n26 += n4;
            }
            n7 += n3;
            n8 += n12;
        }
    }

    IWMap init(int n, int n2) {
        this.iw = n;
        this.ih = n2;
        this.bw = n + 32 - 1 & 0xFFFFFFE0;
        this.bh = n2 + 32 - 1 & 0xFFFFFFE0;
        this.nb = this.bw * this.bh / 1024;
        this.blocks = new IWBlock[this.nb];
        for (int i = 0; i < this.nb; ++i) {
            this.blocks[i] = IWBlock.createIWBlock(this);
        }
        return this;
    }

    void slashres(int n) {
        int n2 = 1;
        if (n < 2) {
            return;
        }
        if (n < 4) {
            n2 = 16;
        } else if (n < 8) {
            n2 = 4;
        }
        for (int i = 0; i < this.nb; ++i) {
            for (int j = n2; j < 64; ++j) {
                this.blocks[i].clearBlock(j);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

