/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DjVuObject;

public class GRect
extends DjVuObject
implements Cloneable {
    public int xmax;
    public int xmin;
    public int ymax;
    public int ymin;

    public GRect() {
        this.ymax = 0;
        this.ymin = 0;
        this.xmax = 0;
        this.xmin = 0;
    }

    public GRect(int n, int n2, int n3, int n4) {
        this.xmin = n;
        this.ymin = n2;
        this.xmax = n + n3;
        this.ymax = n2 + n4;
    }

    public boolean isEmpty() {
        return this.xmin >= this.xmax || this.ymin >= this.ymax;
    }

    public long area() {
        return (long)(this.xmax - this.xmin) * (long)(this.ymax - this.ymin);
    }

    public void clear() {
        this.ymax = 0;
        this.ymin = 0;
        this.xmax = 0;
        this.xmin = 0;
    }

    public Object clone() {
        GRect gRect = null;
        try {
            gRect = (GRect)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return gRect;
    }

    public boolean contains(int n, int n2) {
        return n >= this.xmin && n < this.xmax && n2 >= this.ymin && n2 < this.ymax;
    }

    public boolean contains(GRect gRect) {
        return gRect.isEmpty() || this.contains(gRect.xmin, gRect.ymin) && this.contains(gRect.xmax - 1, gRect.ymax - 1);
    }

    public boolean equals(Object object) {
        if (object instanceof GRect) {
            GRect gRect = (GRect)object;
            boolean bl = this.isEmpty();
            boolean bl2 = gRect.isEmpty();
            return (bl || bl2) && bl && bl2 || this.xmin == gRect.xmin && this.xmax == gRect.xmax && this.ymin == gRect.ymin && this.ymax == gRect.ymax;
        }
        return false;
    }

    public int height() {
        return this.ymax - this.ymin;
    }

    public boolean inflate(int n, int n2) {
        this.xmin -= n;
        this.xmax += n;
        this.ymin -= n2;
        this.ymax += n2;
        if (!this.isEmpty()) {
            return true;
        }
        this.ymax = 0;
        this.xmax = 0;
        this.ymin = 0;
        this.xmin = 0;
        return false;
    }

    public boolean intersect(GRect gRect, GRect gRect2) {
        this.xmin = Math.max(gRect.xmin, gRect2.xmin);
        this.xmax = Math.min(gRect.xmax, gRect2.xmax);
        this.ymin = Math.max(gRect.ymin, gRect2.ymin);
        this.ymax = Math.min(gRect.ymax, gRect2.ymax);
        if (this.isEmpty()) {
            this.ymax = 0;
            this.xmax = 0;
            this.ymin = 0;
            this.xmin = 0;
            return false;
        }
        return true;
    }

    public boolean recthull(GRect gRect, GRect gRect2) {
        if (gRect.isEmpty()) {
            this.xmin = gRect2.xmin;
            this.xmax = gRect2.xmax;
            this.ymin = gRect2.ymin;
            this.ymax = gRect2.ymax;
            return !this.isEmpty();
        }
        if (gRect2.isEmpty()) {
            this.xmin = gRect.xmin;
            this.xmax = gRect.xmax;
            this.ymin = gRect.ymin;
            this.ymax = gRect.ymax;
            return !this.isEmpty();
        }
        this.xmin = Math.min(gRect.xmin, gRect2.xmin);
        this.xmax = Math.max(gRect.xmax, gRect2.xmax);
        this.ymin = Math.min(gRect.ymin, gRect2.ymin);
        this.ymax = Math.max(gRect.ymax, gRect2.ymax);
        return true;
    }

    public boolean translate(int n, int n2) {
        if (!this.isEmpty()) {
            this.xmin += n;
            this.xmax += n;
            this.ymin += n2;
            this.ymax += n2;
            return true;
        }
        this.ymax = 0;
        this.xmax = 0;
        this.ymin = 0;
        this.xmin = 0;
        return false;
    }

    public int width() {
        return this.xmax - this.xmin;
    }
}

