/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.GPixel;
import com.lizardtech.djvu.GPixelReference;
import java.util.Hashtable;

public abstract class GMap
extends DjVuObject
implements Cloneable {
    public final Hashtable properties = new Hashtable();
    protected final int ncolors;
    protected final int redOffset;
    protected final int greenOffset;
    protected final int blueOffset;
    protected int ncolumns = 0;
    protected int nrows = 0;
    protected final boolean needRamp;
    protected byte[] data = null;

    public GMap(int n, int n2, int n3, int n4, boolean bl) {
        this.ncolors = n;
        this.needRamp = bl;
        this.redOffset = n2;
        this.greenOffset = n3;
        this.blueOffset = n4;
    }

    public final int columns() {
        return this.ncolumns;
    }

    public abstract void fill(GMap var1, int var2, int var3);

    public void fillRGBPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this.createGPixelReference(0).fillRGBPixels(n, n2, n3, n4, nArray, n5, n6);
    }

    public final int rows() {
        return this.nrows;
    }

    public abstract GMap translate(int var1, int var2, GMap var3);

    public Object clone() {
        GMap gMap = null;
        try {
            gMap = (GMap)super.clone();
            if (this.data != null) {
                gMap.data = (byte[])this.data.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return gMap;
    }

    public final byte[] getData() {
        return this.data;
    }

    public int rowOffset(int n) {
        return n * this.getRowSize();
    }

    public int getRowSize() {
        return this.columns();
    }

    public final int getColorSize() {
        return this.ncolors;
    }

    public final int getRedOffset() {
        return this.redOffset;
    }

    public final int getGreenOffset() {
        return this.greenOffset;
    }

    public final int getBlueOffset() {
        return this.blueOffset;
    }

    public GPixelReference createGPixelReference(int n) {
        return new GPixelReference(this, n);
    }

    public GPixelReference createGPixelReference(int n, int n2) {
        return new GPixelReference(this, n, n2);
    }

    public GPixel ramp(GPixelReference gPixelReference) {
        return gPixelReference;
    }

    public boolean isRampNeeded() {
        return this.needRamp;
    }
}

