/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInfo;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GBitmap;
import com.lizardtech.djvu.GMap;
import com.lizardtech.djvu.GPixel;
import com.lizardtech.djvu.GPixelReference;
import com.lizardtech.djvu.GPixmap;
import com.lizardtech.djvu.GPixmapScaler;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.IWPixmap;
import com.lizardtech.djvu.JB2Blit;
import com.lizardtech.djvu.JB2Dict;
import com.lizardtech.djvu.JB2Image;
import com.lizardtech.djvu.JB2Shape;
import com.lizardtech.djvu.Palette;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DjVuPage
extends DjVuObject
implements Runnable {
    public static final int DJVUVERSION = 20;
    public static final int DJVUVERSION_TOO_OLD = 15;
    public static final int DJVUVERSION_TOO_NEW = 22;
    protected static Thread queueThread = null;
    protected static Vector[] queueVector = new Vector[]{null, null};
    protected static int queueCount = 0;
    public static int MAX_PRIORITY = 1;
    public static int MIN_PRIORITY = 0;
    private static int idCount = 1;
    public final Object annoLock = new String("anno");
    public final Object bgIWPixmapLock = new String("bgIWPixmap");
    public final Object doneLock = new String("done");
    public final Object fgIWPixmapLock = new String("fgIWPixmap");
    public final Object fgJb2DictLock = new String("fgJb2Dict");
    public final Object fgJb2Lock = new String("fgJb2");
    public final Object fgPaletteLock = new String("fgPalette");
    public final Object infoLock = new String("info");
    public final Object progressiveLock = new String("progressive");
    public final Object textLock = new String("text");
    public String mimetype = null;
    protected CachedInputStream sjbzChunk = null;
    protected Number progressiveCount = new Integer(0);
    long startTime = System.currentTimeMillis();
    private CachedInputStream pool = null;
    private String status = null;
    private Hashtable codecTable = new Hashtable();
    private Object fgPixmapReference = null;
    private final PropertyChangeSupport change;
    private Throwable caughtException = null;
    protected URL url = null;
    private boolean asyncValue = false;
    private boolean decodeCalled = false;
    private boolean lockWait = true;
    private final long id;
    private int priority = MAX_PRIORITY;
    static /* synthetic */ Class class$com$lizardtech$djvu$DjVuPage;

    public DjVuPage() {
        this.change = new PropertyChangeSupport(this);
        this.id = idCount++;
    }

    public final synchronized void setAsync(boolean bl) {
        this.asyncValue = bl;
    }

    public final boolean isAsync() {
        return this.asyncValue;
    }

    public final synchronized void setPriority(int n) {
        this.priority = Math.max(MIN_PRIORITY, Math.min(n, MAX_PRIORITY));
    }

    public final int getPriority() {
        return this.priority;
    }

    public GPixmap getBgPixmap(GRect gRect, int n, double d, GPixmap gPixmap) {
        int n2;
        GPixmap gPixmap2 = null;
        DjVuInfo djVuInfo = this.getInfo();
        int n3 = djVuInfo == null ? 0 : djVuInfo.width;
        int n4 = n2 = djVuInfo == null ? 0 : djVuInfo.height;
        if (n3 <= 0 || n2 <= 0 || djVuInfo == null) {
            return null;
        }
        double d2 = 1.0;
        if (d > 0.0 && djVuInfo != null) {
            d2 = d / djVuInfo.gamma;
        }
        if (d2 < 0.1) {
            d2 = 0.1;
        } else if (d2 > 10.0) {
            d2 = 10.0;
        }
        IWPixmap iWPixmap = this.getBgIWPixmap();
        if (iWPixmap != null) {
            int n5 = iWPixmap.getWidth();
            int n6 = iWPixmap.getHeight();
            if (n5 == 0 || n6 == 0 || n3 == 0 || n2 == 0) {
                return null;
            }
            int n7 = DjVuPage.compute_red(n3, n2, n5, n6);
            if (n7 < 1 || n7 > 12) {
                return null;
            }
            if (n == n7) {
                gPixmap2 = iWPixmap.getPixmap(1, gRect, gPixmap);
            } else if (n == 2 * n7) {
                gPixmap2 = iWPixmap.getPixmap(2, gRect, gPixmap);
            } else if (n == 4 * n7) {
                gPixmap2 = iWPixmap.getPixmap(4, gRect, gPixmap);
            } else if (n == 8 * n7) {
                gPixmap2 = iWPixmap.getPixmap(8, gRect, gPixmap);
            } else if (n7 * 4 == n * 3) {
                GRect gRect2 = new GRect();
                gRect2.xmin = (int)Math.floor((double)gRect.xmin * 4.0 / 3.0);
                gRect2.ymin = (int)Math.floor((double)gRect.ymin * 4.0 / 3.0);
                gRect2.xmax = (int)Math.ceil((double)gRect.xmax * 4.0 / 3.0);
                gRect2.ymax = (int)Math.ceil((double)gRect.ymax * 4.0 / 3.0);
                GRect gRect3 = new GRect(0, 0, gRect.width(), gRect.height());
                if (gRect2.xmax > n5) {
                    gRect2.xmax = n5;
                }
                if (gRect2.ymax > n6) {
                    gRect2.ymax = n6;
                }
                GPixmap gPixmap3 = iWPixmap.getPixmap(1, gRect2, null);
                gPixmap2 = gPixmap != null ? gPixmap : GPixmap.createGPixmap(this);
                gPixmap2.downsample43(gPixmap3, gRect3);
            } else {
                int n8;
                for (n8 = 16; n8 > 1 && n < n8 * n7; n8 >>= 1) {
                }
                int n9 = (n5 + n8 - 1) / n8;
                int n10 = (n6 + n8 - 1) / n8;
                int n11 = (n3 + n - 1) / n;
                int n12 = (n2 + n - 1) / n;
                GPixmapScaler gPixmapScaler = this.createGPixmapScaler(n9, n10, n11, n12);
                gPixmapScaler.setHorzRatio(n7 * n8, n);
                gPixmapScaler.setVertRatio(n7 * n8, n);
                GRect gRect4 = gPixmapScaler.getRequiredRect(gRect);
                GPixmap gPixmap4 = iWPixmap.getPixmap(n8, gRect4, null);
                gPixmap2 = gPixmap != null ? gPixmap : GPixmap.createGPixmap(this);
                gPixmapScaler.scale(gRect4, gPixmap4, gRect, gPixmap2);
            }
            if (gPixmap2 != null && d2 != 1.0) {
                gPixmap2.applyGammaCorrection(d2);
                for (int i = 0; i < 9; ++i) {
                    gPixmap2.applyGammaCorrection(d2);
                }
            }
            if (DjVuOptions.COLLECT_GARBAGE) {
                System.gc();
            }
            return gPixmap2;
        }
        return null;
    }

    public final GBitmap getBitmap(GRect gRect, int n, int n2, GBitmap gBitmap) {
        return this.get_bitmap(gRect, n, n2, null);
    }

    public boolean isColor() {
        return this.is_legal_compound() || !this.is_legal_bilevel();
    }

    public final boolean isDecoding() {
        return this.lockWait && this.decodeCalled;
    }

    public Codec getAnno() {
        return this.getCodec(this.annoLock);
    }

    public IWPixmap getBgIWPixmap() {
        return (IWPixmap)this.getCodec(this.bgIWPixmapLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Codec getCodec(Object object) {
        Object object2 = object;
        synchronized (object2) {
            return (Codec)this.codecTable.get(object);
        }
    }

    public final GMap getMap(GRect gRect, int n, GMap gMap) {
        Number number = this.progressiveCount;
        GMap gMap2 = this.isColor() ? this.getPixmap(gRect, n, 0.0, gMap instanceof GPixmap ? (GPixmap)gMap : null) : (gMap = this.getBitmap(gRect, n, 1, gMap instanceof GBitmap ? (GBitmap)gMap : null));
        if (gMap != null) {
            gMap.properties.put(this.progressiveLock, number);
            gMap.properties.put("rect", gRect.clone());
            gMap.properties.put("subsample", new Integer(n));
        }
        return gMap;
    }

    public IWPixmap getFgIWPixmap() {
        return (IWPixmap)this.codecTable.get(this.fgIWPixmapLock);
    }

    public JB2Image getFgJb2() {
        return (JB2Image)this.codecTable.get(this.fgJb2Lock);
    }

    public JB2Dict getFgJb2Dict() {
        return (JB2Dict)this.codecTable.get(this.fgJb2DictLock);
    }

    public Palette getFgPalette() {
        return (Palette)this.codecTable.get(this.fgPaletteLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GPixmap getFgPixmap() {
        IWPixmap iWPixmap;
        GPixmap gPixmap = (GPixmap)DjVuObject.getFromReference(this.fgPixmapReference);
        if (gPixmap == null && (iWPixmap = this.getFgIWPixmap()) != null) {
            Object object = this.fgIWPixmapLock;
            synchronized (object) {
                gPixmap = (GPixmap)DjVuObject.getFromReference(this.fgPixmapReference);
                if (gPixmap == null) {
                    gPixmap = iWPixmap.getPixmap();
                    this.fgPixmapReference = DjVuObject.createSoftReference(gPixmap, gPixmap);
                }
            }
        }
        return gPixmap;
    }

    public DjVuInfo getInfo() {
        return (DjVuInfo)this.codecTable.get(this.infoLock);
    }

    public DjVuInfo getInfoWait() {
        return (DjVuInfo)this.waitForCodec(this.infoLock, 0L);
    }

    public int getProgressiveCount() {
        return this.progressiveCount.intValue();
    }

    public Codec getText() {
        return (Codec)this.codecTable.get(this.textLock);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.change.addPropertyChangeListener(propertyChangeListener);
    }

    public static int compute_red(int n, int n2, int n3, int n4) {
        for (int i = 1; i < 16; ++i) {
            if ((n + i - 1) / i != n3 || (n2 + i - 1) / i != n4) continue;
            return i;
        }
        return 16;
    }

    public static DjVuPage createDjVuPage(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (DjVuPage)DjVuObject.create(djVuOptions, djVuOptions.getDjVuPageClass(), class$com$lizardtech$djvu$DjVuPage == null ? (class$com$lizardtech$djvu$DjVuPage = DjVuPage.class$("com.lizardtech.djvu.DjVuPage")) : class$com$lizardtech$djvu$DjVuPage);
    }

    public GPixmapScaler createGPixmapScaler(int n, int n2, int n3, int n4) {
        return new GPixmapScaler(n, n2, n3, n4);
    }

    public void decode(URL uRL) throws IOException {
        this.url = uRL;
        this.decode(CachedInputStream.createCachedInputStream(this).init(uRL, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(CachedInputStream cachedInputStream) throws IOException {
        Vector[] vectorArray = this.progressiveLock;
        synchronized (this.progressiveLock) {
            if (this.getProgressiveCount() != 0) {
                throw new IllegalStateException((class$com$lizardtech$djvu$DjVuPage == null ? (class$com$lizardtech$djvu$DjVuPage = DjVuPage.class$("com.lizardtech.djvu.DjVuPage")) : class$com$lizardtech$djvu$DjVuPage).getName() + " decode already called.");
            }
            this.progressiveCount = new Integer(1);
            this.decodeCalled = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.pool = cachedInputStream;
            if (this.isAsync()) {
                vectorArray = queueVector;
                synchronized (queueVector) {
                    queueVector[this.getPriority()].addElement(DjVuObject.createWeakReference(this, this));
                    ++queueCount;
                    if (queueThread == null) {
                        queueThread = new Thread(DjVuPage.createDjVuPage(this));
                        queueThread.start();
                    } else {
                        queueVector.notifyAll();
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            } else {
                this.decode();
                if (this.caughtException instanceof IOException) {
                    throw (IOException)this.caughtException;
                }
                if (this.caughtException instanceof RuntimeException) {
                    throw (RuntimeException)this.caughtException;
                }
            }
            return;
        }
    }

    public boolean hasCodec(Object object) {
        return this.codecTable.get(object) instanceof Codec;
    }

    public boolean is_legal_photo() {
        DjVuInfo djVuInfo = this.getInfo();
        if (djVuInfo == null) {
            return false;
        }
        int n = djVuInfo.width;
        int n2 = djVuInfo.height;
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        return this.hasCodec(this.bgIWPixmapLock) && !this.hasCodec(this.fgJb2Lock) && !this.hasCodec(this.fgIWPixmapLock);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.change.removePropertyChangeListener(propertyChangeListener);
    }

    public final GMap updateMap(GMap gMap, GRect gRect, int n) {
        Object v;
        if (gMap != null && (v = gMap.properties.get("subsample")) instanceof Number && ((Number)v).intValue() == n && this.progressiveCount.equals(gMap.properties.get(this.progressiveLock)) && gRect.equals(gMap.properties.get("rect"))) {
            return gMap;
        }
        return this.getMap(gRect, n, null);
    }

    public GPixmap getPixmap(GRect gRect, int n, double d, GPixmap gPixmap) {
        if (gRect.isEmpty()) {
            return gPixmap == null ? GPixmap.createGPixmap(this) : gPixmap.init(0, 0, null);
        }
        GPixmap gPixmap2 = this.getBgPixmap(gRect, n, d, gPixmap);
        if (this.hasCodec(this.fgJb2Lock)) {
            if (gPixmap2 == null) {
                gPixmap2 = gPixmap == null ? GPixmap.createGPixmap(this) : gPixmap;
                gPixmap2.init(gRect.height(), gRect.width(), GPixel.WHITE);
            }
            if (this.stencil(gPixmap2, gRect, n, d)) {
                gPixmap = gPixmap2;
            }
        } else {
            gPixmap = gPixmap2;
        }
        return gPixmap;
    }

    public GBitmap get_bitmap(GRect gRect, int n, int n2, Vector vector) {
        if (gRect.isEmpty()) {
            return GBitmap.createGBitmap(this);
        }
        DjVuInfo djVuInfo = this.getInfo();
        if (djVuInfo != null) {
            int n3 = djVuInfo.width;
            int n4 = djVuInfo.height;
            JB2Image jB2Image = this.getFgJb2();
            if (n3 != 0 && n4 != 0 && jB2Image != null && jB2Image.width == n3 && jB2Image.height == n4) {
                return jB2Image.get_bitmap(gRect, n, n2, 0, vector);
            }
        }
        return null;
    }

    public boolean is_legal_bilevel() {
        DjVuInfo djVuInfo = this.getInfo();
        if (djVuInfo == null) {
            return false;
        }
        int n = djVuInfo.width;
        int n2 = djVuInfo.height;
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        JB2Image jB2Image = this.getFgJb2();
        if (jB2Image == null || jB2Image.width != n || jB2Image.height != n2) {
            return false;
        }
        return !this.hasCodec(this.bgIWPixmapLock) && !this.hasCodec(this.fgIWPixmapLock) && !this.hasCodec(this.fgPaletteLock);
    }

    public boolean is_legal_compound() {
        DjVuInfo djVuInfo = this.getInfo();
        if (djVuInfo == null) {
            return false;
        }
        int n = djVuInfo.width;
        int n2 = djVuInfo.height;
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        JB2Image jB2Image = this.getFgJb2();
        if (jB2Image == null || jB2Image.width != n || jB2Image.height != n2) {
            return false;
        }
        IWPixmap iWPixmap = (IWPixmap)this.codecTable.get(this.bgIWPixmapLock);
        int n3 = 0;
        if (iWPixmap != null) {
            n3 = DjVuPage.compute_red(n, n2, iWPixmap.getWidth(), iWPixmap.getHeight());
        }
        if (n3 < 1 || n3 > 12) {
            return false;
        }
        int n4 = 0;
        if (this.hasCodec(this.fgIWPixmapLock)) {
            GPixmap gPixmap = this.getFgPixmap();
            n4 = DjVuPage.compute_red(n, n2, gPixmap.columns(), gPixmap.rows());
        }
        return n4 >= 1 && n4 <= 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Thread thread = Thread.currentThread();
        int n = MIN_PRIORITY;
        while (queueThread == thread) {
            DjVuPage djVuPage = null;
            Vector[] vectorArray = queueVector;
            // MONITORENTER : queueVector
            if (queueCount == 0) {
                try {
                    queueVector.wait(5000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (queueCount == 0) {
                    queueThread = null;
                    // MONITOREXIT : vectorArray
                    return;
                }
            }
            n = queueVector.length;
            while (n > 0) {
                Vector vector;
                if ((vector = queueVector[--n]).size() <= 0) continue;
                Object e = vector.lastElement();
                djVuPage = (DjVuPage)DjVuObject.getFromReference(e);
                vector.removeElementAt(vector.size() - 1);
                --queueCount;
                if (djVuPage == null) continue;
                if (n >= MAX_PRIORITY) break;
                Vector vector2 = queueVector[n + 1];
                vector2.addElement(e);
                ++queueCount;
                djVuPage = null;
                try {
                    queueVector.wait(200L);
                }
                catch (Throwable throwable) {}
                break;
            }
            // MONITOREXIT : vectorArray
            if (djVuPage == null) continue;
            try {
                super.decode();
            }
            catch (Throwable throwable) {
                DjVuObject.printStackTrace(throwable);
            }
        }
    }

    public void setStatus(String string) {
        String string2 = this.status;
        this.status = string;
        this.change.firePropertyChange("status", string2, string);
    }

    public String getStatus() {
        return this.status;
    }

    public boolean stencil(GPixmap gPixmap, GRect gRect, int n, double d) {
        DjVuInfo djVuInfo = this.getInfo();
        if (djVuInfo == null) {
            return false;
        }
        int n2 = djVuInfo.width;
        int n3 = djVuInfo.height;
        if (n2 <= 0 || n3 <= 0) {
            return false;
        }
        double d2 = 1.0;
        if (d > 0.0) {
            d2 = d / djVuInfo.gamma;
        }
        if (d2 < 0.1) {
            d2 = 0.1;
        } else if (d2 > 10.0) {
            d2 = 10.0;
        }
        JB2Image jB2Image = this.getFgJb2();
        if (jB2Image != null) {
            GBitmap gBitmap;
            Palette palette = this.getFgPalette();
            if (palette != null) {
                Vector vector = new Vector();
                GBitmap gBitmap2 = this.get_bitmap(gRect, n, 1, vector);
                if (jB2Image.get_blit_count() != palette.colordata.length) {
                    gPixmap.attenuate(gBitmap2, 0, 0);
                    return false;
                }
                GPixmap gPixmap2 = GPixmap.createGPixmap(this).init(1, palette.size(), null);
                GPixelReference gPixelReference = gPixmap2.createGPixelReference(0);
                int n4 = 0;
                while (n4 < gPixmap2.columns()) {
                    palette.index_to_color(n4++, gPixelReference);
                    gPixelReference.incOffset();
                }
                gPixmap2.applyGammaCorrection(d2);
                Vector vector2 = new Vector();
                while (vector.size() > 0) {
                    Cloneable cloneable;
                    int n5;
                    short s = 0;
                    int n6 = palette.colordata[((Number)vector.elementAt(0)).intValue()];
                    GRect gRect2 = new GRect();
                    vector2.setSize(0);
                    int n7 = 0;
                    while (n7 < vector.size()) {
                        n5 = ((Number)vector.elementAt(n7)).intValue();
                        JB2Blit jB2Blit = jB2Image.get_blit(n5);
                        if (jB2Blit.left < s) break;
                        s = jB2Blit.left;
                        if (palette.colordata[n5] == n6) {
                            JB2Shape jB2Shape = jB2Image.get_shape(jB2Blit.shapeno);
                            cloneable = new GRect(jB2Blit.left, jB2Blit.bottom, jB2Shape.getGBitmap().columns(), jB2Shape.getGBitmap().rows());
                            gRect2.recthull(gRect2, (GRect)cloneable);
                            vector2.addElement(vector.elementAt(n7));
                            vector.removeElementAt(n7);
                            continue;
                        }
                        ++n7;
                    }
                    gRect2.xmin /= n;
                    gRect2.ymin /= n;
                    gRect2.xmax = (gRect2.xmax + n - 1) / n;
                    gRect2.ymax = (gRect2.ymax + n - 1) / n;
                    gRect2.intersect(gRect2, gRect);
                    if (gRect2.isEmpty()) continue;
                    gBitmap2 = GBitmap.createGBitmap(this);
                    gBitmap2.init(gRect2.height(), gRect2.width(), 0);
                    gBitmap2.setGrays(1 + n * n);
                    n7 = gRect2.xmin * n;
                    n5 = gRect2.ymin * n;
                    for (int i = 0; i < vector2.size(); ++i) {
                        int n8 = ((Number)vector2.elementAt(i)).intValue();
                        cloneable = jB2Image.get_blit(n8);
                        JB2Shape jB2Shape = jB2Image.get_shape(((JB2Blit)cloneable).shapeno);
                        gBitmap2.blit(jB2Shape.getGBitmap(), ((JB2Blit)cloneable).left - n7, ((JB2Blit)cloneable).bottom - n5, n);
                    }
                    gPixelReference.setOffset(n6);
                    gPixmap.blit(gBitmap2, gRect2.xmin - gRect.xmin, gRect2.ymin - gRect.ymin, gPixelReference);
                }
                return true;
            }
            IWPixmap iWPixmap = this.getFgIWPixmap();
            if (iWPixmap != null && (gBitmap = this.getBitmap(gRect, n, 1, null)) != null && gPixmap != null) {
                int n9;
                GPixmap gPixmap3 = this.getFgPixmap();
                int n10 = gPixmap3.columns();
                int n11 = DjVuPage.compute_red(n2, n3, n10, n9 = gPixmap3.rows());
                if (n11 < 1 || n11 > 16) {
                    return false;
                }
                gPixmap.stencil(gBitmap, gPixmap3, n11, n, gRect, d2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Codec waitForCodec(Object object, long l) {
        Codec codec;
        boolean bl;
        do {
            Object object2 = object;
            synchronized (object2) {
                bl = this.isDecoding();
                codec = (Codec)this.codecTable.get(object);
                if (bl && codec == null && (bl = this.isDecoding())) {
                    try {
                        object.wait(l <= 0L ? 5000L : l);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    codec = (Codec)this.codecTable.get(object);
                }
            }
        } while (bl && codec == null && l <= 0L && object != this.progressiveLock);
        return codec;
    }

    protected void clean(String string) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        long l2 = System.currentTimeMillis() - this.startTime;
        String string2 = "000" + l2;
        DjVuObject.verbose(this.id + ". chkid=" + string + ",memory=" + l + " time=" + l2 / 1000L + "." + string2.substring(string2.length() - 3));
        if (DjVuOptions.COLLECT_GARBAGE) {
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeChunk(CachedInputStream cachedInputStream, boolean bl) throws IOException {
        block41: {
            String string = cachedInputStream.getName();
            try {
                if (string.equals("Djbz")) {
                    this.addCodecChunk(this.fgJb2DictLock, JB2Dict.createJB2Dict(this), cachedInputStream);
                    if (this.sjbzChunk != null) {
                        this.parseSjbz((CachedInputStream)this.sjbzChunk.clone());
                    }
                    break block41;
                }
                if (string.equals("ANTa") || string.equals("ANTz")) {
                    Object object = this.annoLock;
                    synchronized (object) {
                        Codec codec = this.getCodec(this.annoLock);
                        if (codec == null) {
                            codec = this.getDjVuOptions().createDjVuAnno();
                        }
                        this.addCodecChunk(this.annoLock, codec, cachedInputStream);
                        break block41;
                    }
                }
                if (bl) break block41;
                if (string.equals("INFO")) {
                    throw new IllegalStateException("DjVu Decoder: Corrupted file (Duplicate INFO chunk)");
                }
                if (string.equals("INCL")) {
                    this.decodeInclude(this.createCachedInputStream(cachedInputStream.readFullyUTF()));
                    break block41;
                }
                if (string.equals("FGbz")) {
                    if (this.hasCodec(this.fgIWPixmapLock)) {
                        throw new IllegalStateException("Duplicate foreground");
                    }
                    this.addCodecChunk(this.fgPaletteLock, Palette.createPalette(this), cachedInputStream);
                    break block41;
                }
                if (string.equals("TXTa")) break block41;
                if (string.equals("TXTz")) {
                    break block41;
                }
                if (string.equals("Sjbz")) {
                    if (this.sjbzChunk != null) {
                        throw new IllegalStateException("Duplicate Sjbz chunk");
                    }
                    try {
                        cachedInputStream.mark(Integer.MAX_VALUE);
                        this.parseSjbz(cachedInputStream);
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (this.hasCodec(this.fgJb2DictLock)) {
                            throw illegalStateException;
                        }
                        cachedInputStream.reset();
                        this.sjbzChunk = cachedInputStream;
                    }
                    break block41;
                }
                if (string.equals("BG44")) {
                    Object object = this.bgIWPixmapLock;
                    synchronized (object) {
                        Codec codec = this.getCodec(this.bgIWPixmapLock);
                        if (codec == null) {
                            codec = IWPixmap.createIWPixmap(this);
                        }
                        this.addCodecChunk(this.bgIWPixmapLock, codec, cachedInputStream);
                        break block41;
                    }
                }
                if (string.equals("FG44")) {
                    if (this.hasCodec(this.fgPaletteLock)) {
                        throw new IllegalStateException("DjVu Decoder: Corrupted data (Duplicate foreground layer)");
                    }
                    this.addCodecChunk(this.fgIWPixmapLock, IWPixmap.createIWPixmap(this), cachedInputStream);
                } else if (string.equals("BG2k")) {
                    if (this.hasCodec(this.bgIWPixmapLock)) {
                        throw new IllegalStateException("DjVu Decoder: Corrupted data (Duplicate background layer)");
                    }
                } else if (string.equals("FG2k")) {
                    if (this.hasCodec(this.fgIWPixmapLock) || this.hasCodec(this.fgPaletteLock)) {
                        throw new IllegalStateException("DjVu Decoder: Corrupted data (Duplicate foreground layer)");
                    }
                } else if (string.equals("Smmr")) {
                    if (this.hasCodec(this.fgJb2Lock)) {
                        throw new IllegalStateException("DjVu Decoder: Corrupted data (Duplicate background layer)");
                    }
                } else if (string.equals("BGjp")) {
                    if (this.hasCodec(this.bgIWPixmapLock)) {
                        throw new IllegalStateException("DjVu Decoder: Corrupted data (Duplicate background layer)");
                    }
                } else if (string.equals("FGjp") && this.hasCodec(this.fgIWPixmapLock)) {
                    throw new IllegalStateException("DjVu Decoder: Corrupted data (Duplicate foreground layer)");
                }
            }
            finally {
                this.clean(string);
            }
        }
    }

    protected void decodeChunks(Enumeration enumeration, boolean bl) throws IOException {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return;
        }
        if (!this.hasCodec(this.infoLock)) {
            CachedInputStream cachedInputStream = (CachedInputStream)enumeration.nextElement();
            if (!"INFO".equals(cachedInputStream.getName())) {
                throw new IOException("DjVuDecoder:: Corrupted file (Does not start with INFO chunk)");
            }
            this.addCodecChunk(this.infoLock, DjVuInfo.createDjVuInfo(this), cachedInputStream);
            this.clean(cachedInputStream.getName());
        }
        while (enumeration.hasMoreElements()) {
            this.decodeChunk((CachedInputStream)enumeration.nextElement(), bl);
        }
    }

    protected void decodeInclude(CachedInputStream cachedInputStream) throws IOException {
        Enumeration enumeration = cachedInputStream.getIFFChunks();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            throw new IOException("EOF");
        }
        CachedInputStream cachedInputStream2 = (CachedInputStream)enumeration.nextElement();
        Enumeration enumeration2 = cachedInputStream2.getIFFChunks();
        if (enumeration2 == null || !"FORM:DJVI".equals(cachedInputStream2.getName())) {
            throw new IllegalStateException("DejaVu decoder: a DJVI include was expected");
        }
        this.decodeChunks(enumeration2, true);
    }

    protected void parseSjbz(InputStream inputStream) throws IOException {
        this.sjbzChunk = null;
        JB2Image jB2Image = JB2Image.createJB2Image(this);
        DjVuInfo djVuInfo = this.getInfo();
        if (djVuInfo != null && djVuInfo.version < 19) {
            jB2Image.reproduce_old_bug = true;
        }
        jB2Image.decode(inputStream, this.getFgJb2Dict());
        if (this.setCodec(this.fgJb2Lock, jB2Image) != null) {
            throw new IllegalStateException("DjVu Decoder: Corrupted data (Duplicate FGxx chunk)");
        }
    }

    CachedInputStream createCachedInputStream(String string) throws IOException {
        return CachedInputStream.createCachedInputStream(this).init(new URL(this.url, string), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Codec setCodec(Object object, Codec codec) {
        Codec codec2;
        String string = (String)object;
        Object object2 = object;
        synchronized (object2) {
            codec2 = (Codec)(codec == null ? this.codecTable.remove(object) : this.codecTable.put(object, codec));
            object.notifyAll();
            if (codec2 != codec) {
                this.change.firePropertyChange(string, codec2, codec);
            } else if (object.equals(this.annoLock)) {
                this.change.firePropertyChange((String)this.annoLock, null, codec);
            }
        }
        if (codec != null && codec.isImageData()) {
            object2 = this.progressiveLock;
            synchronized (object2) {
                Number number = this.progressiveCount;
                this.progressiveCount = new Integer(number.intValue() + 1);
                this.progressiveLock.notifyAll();
                this.change.firePropertyChange((String)this.progressiveLock, number, this.progressiveCount);
            }
        }
        return codec2;
    }

    private void addCodecChunk(Object object, Codec codec, CachedInputStream cachedInputStream) throws IOException {
        if (codec != null) {
            codec.decode(cachedInputStream);
            Codec codec2 = this.setCodec(object, codec);
            if (codec2 != null && codec2 != codec) {
                throw new IllegalStateException("Duplicate " + object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode() {
        Object object;
        Object[] objectArray;
        block27: {
            try {
                this.startTime = System.currentTimeMillis();
                objectArray = this.url;
                if (objectArray != null) {
                    this.setStatus("decoding " + objectArray);
                }
                CachedInputStream cachedInputStream = this.pool;
                this.pool = null;
                object = cachedInputStream.getIFFChunks();
                try {
                    Object object2;
                    IWPixmap iWPixmap;
                    if (object == null || !object.hasMoreElements()) {
                        throw new IOException("EOF");
                    }
                    CachedInputStream cachedInputStream2 = (CachedInputStream)object.nextElement();
                    if ("FORM:DJVU".equals(cachedInputStream2.getName())) {
                        this.mimetype = "image/djvu";
                        this.decodeChunks(cachedInputStream2.getIFFChunks(), false);
                        if (this.sjbzChunk != null) {
                            this.parseSjbz((CachedInputStream)this.sjbzChunk.clone());
                            this.clean("Sjbz");
                        }
                        if ((iWPixmap = this.getBgIWPixmap()) != null) {
                            iWPixmap.close_codec();
                        }
                        if ((object2 = this.getInfo()) == null) {
                            throw new IllegalStateException("DjVu Decoder: Corrupted data (Missing INFO chunk)");
                        }
                        break block27;
                    }
                    if ("FORM:PM44".equals(cachedInputStream2.getName()) || "FORM:BM44".equals(cachedInputStream2.getName())) {
                        this.mimetype = "image/iw44";
                        iWPixmap = null;
                        object2 = cachedInputStream2.getIFFChunks();
                        while (object2 != null && object2.hasMoreElements()) {
                            Object object3;
                            CachedInputStream cachedInputStream3 = (CachedInputStream)object2.nextElement();
                            if ("PM44".equals(cachedInputStream3.getName()) || "BM44".equals(cachedInputStream3.getName())) {
                                if (iWPixmap != null) {
                                    iWPixmap = IWPixmap.createIWPixmap(this);
                                    iWPixmap.decode(cachedInputStream3);
                                    object3 = DjVuInfo.createDjVuInfo(this);
                                    ((DjVuInfo)object3).width = iWPixmap.getWidth();
                                    ((DjVuInfo)object3).height = iWPixmap.getHeight();
                                    ((DjVuInfo)object3).dpi = 100;
                                    this.setCodec(this.infoLock, (Codec)object3);
                                    this.setCodec(this.bgIWPixmapLock, iWPixmap);
                                    continue;
                                }
                                iWPixmap.decode(cachedInputStream3);
                                continue;
                            }
                            if (!"ANTa".equals(cachedInputStream3.getName()) && !"ANTz".equals(cachedInputStream3.getName())) continue;
                            object3 = this.annoLock;
                            synchronized (object3) {
                                Codec codec = this.getCodec(this.annoLock);
                                if (codec == null) {
                                    codec = this.getDjVuOptions().createDjVuAnno();
                                }
                                this.addCodecChunk(this.annoLock, codec, cachedInputStream3);
                            }
                        }
                        if (!this.hasCodec(this.infoLock)) {
                            throw new IllegalStateException("DjVu Decoder: Corrupted data (Missing IW44 data chunks)");
                        }
                        break block27;
                    }
                    throw new IllegalStateException("DejaVu decoder: a DJVU or IW44 image was expected");
                }
                finally {
                    if (objectArray != null) {
                        this.setStatus("decoded " + objectArray);
                    }
                }
            }
            catch (Throwable throwable) {
                this.caughtException = throwable;
                DjVuObject.printStackTrace(throwable);
            }
        }
        this.lockWait = false;
        try {
            objectArray = new Object[]{this.infoLock, this.fgIWPixmapLock, this.annoLock, this.textLock, this.bgIWPixmapLock, this.fgJb2Lock, this.fgPaletteLock, this.fgJb2DictLock, this.progressiveLock, this.doneLock};
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                synchronized (object) {
                    objectArray[i].notifyAll();
                    continue;
                }
            }
            this.change.firePropertyChange(this.doneLock.toString(), null, this);
        }
        catch (Throwable throwable) {
            DjVuObject.printStackTrace(throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        queueVector = new Vector[1 + MAX_PRIORITY - MIN_PRIORITY];
        int n = 0;
        while (n < queueVector.length) {
            DjVuPage.queueVector[n++] = new Vector();
        }
    }
}

