/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import java.io.IOException;
import java.io.InputStream;

public class DjVuInfo
extends DjVuObject
implements Cloneable,
Codec {
    public double gamma = 2.2;
    public int dpi = 300;
    public int flags = 0;
    public int height = 0;
    public int version = 20;
    public int width = 0;
    static /* synthetic */ Class class$com$lizardtech$djvu$DjVuInfo;

    public boolean isImageData() {
        return false;
    }

    public static DjVuInfo createDjVuInfo(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (DjVuInfo)DjVuObject.create(djVuOptions, djVuOptions.getDjVuInfoClass(), class$com$lizardtech$djvu$DjVuInfo == null ? (class$com$lizardtech$djvu$DjVuInfo = DjVuInfo.class$("com.lizardtech.djvu.DjVuInfo")) : class$com$lizardtech$djvu$DjVuInfo);
    }

    public Object clone() {
        DjVuInfo djVuInfo = null;
        try {
            djVuInfo = (DjVuInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return djVuInfo;
    }

    public void decode(CachedInputStream cachedInputStream) throws IOException {
        byte[] byArray;
        CachedInputStream cachedInputStream2 = (CachedInputStream)cachedInputStream.clone();
        int n = ((InputStream)cachedInputStream2).read(byArray = new byte[10]);
        if (n < 5) {
            throw new IOException("DjVuInfo: Corrupted file (truncated INFO chunk)");
        }
        this.width = (0xFF & byArray[0]) << 8 | 0xFF & byArray[1];
        this.height = (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
        this.version = 0xFF & byArray[4];
        if (n >= 6 && byArray[5] != -1) {
            this.version = (0xFF & byArray[5]) << 8 | this.version;
        }
        if (n >= 8 && byArray[7] != -1) {
            this.dpi = (0xFF & byArray[7]) << 8 | 0xFF & byArray[6];
            if (this.dpi < 25 || this.dpi > 6000) {
                this.dpi = 300;
            }
        }
        if (n >= 9 && (byArray[8] >= 3 || byArray[8] <= 50)) {
            this.gamma = 0.1 * (double)byArray[8];
        }
        if (n >= 10) {
            this.flags = byArray[9];
        }
        if (this.width < 0 || this.height < 0) {
            throw new IOException("DjVu Decoder: Corrupted file (image size is zero)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

