/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.BSInputStream;
import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class DjVmDir
extends DjVuObject
implements Cloneable,
Codec {
    public static final int version = 1;
    private URL initURL = null;
    private final Hashtable id2file = new Hashtable();
    private final Hashtable name2file = new Hashtable();
    private final Hashtable title2file = new Hashtable();
    private final Vector files_list = new Vector();
    private final Vector page2file = new Vector();
    static /* synthetic */ Class class$com$lizardtech$djvu$DjVmDir;

    public static DjVmDir createDjVmDir(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (DjVmDir)DjVuObject.create(djVuOptions, djVuOptions.getDjVmDirClass(), class$com$lizardtech$djvu$DjVmDir == null ? (class$com$lizardtech$djvu$DjVmDir = DjVmDir.class$("com.lizardtech.djvu.DjVmDir")) : class$com$lizardtech$djvu$DjVmDir);
    }

    public boolean isImageData() {
        return false;
    }

    public void setInitURL(URL uRL) {
        this.initURL = uRL;
    }

    public URL getInitURL() {
        return this.initURL;
    }

    public int getPageno(String string) {
        int n = -1;
        if (string != null && string.length() > 0 && string.charAt(0) == '#') {
            String string2 = string.substring(1);
            try {
                File file = this.id_to_file(string2);
                if (file == null && (file = this.name_to_file(string2)) == null) {
                    file = this.title_to_file(string2);
                }
                n = file != null ? file.get_page_num() : Integer.parseInt(string2) - 1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return n;
    }

    public Object clone() {
        DjVmDir djVmDir = null;
        djVmDir = DjVmDir.createDjVmDir(this);
        djVmDir.setInitURL(this.getInitURL());
        Enumeration enumeration = this.get_files_list().elements();
        while (enumeration.hasMoreElements()) {
            try {
                djVmDir.insert_file((File)((File)enumeration.nextElement()).clone());
            }
            catch (IOException iOException) {}
        }
        return djVmDir;
    }

    public File createFile() {
        return new File();
    }

    public File createFile(String string, String string2, String string3, int n) {
        return new File(string, string2, string3, n);
    }

    public synchronized void decode(CachedInputStream cachedInputStream) throws IOException {
        boolean bl;
        CachedInputStream cachedInputStream2 = (CachedInputStream)cachedInputStream.clone();
        this.files_list.setSize(0);
        this.page2file.setSize(0);
        this.name2file.clear();
        this.id2file.clear();
        this.title2file.clear();
        int n = ((InputStream)cachedInputStream2).read();
        boolean bl2 = bl = (n & 0x80) != 0;
        if ((n &= 0x7F) > 1) {
            throw new IOException("DjVmDir.version_error 1 " + n);
        }
        int n2 = ((InputStream)cachedInputStream2).read();
        if ((n2 = n2 << 8 | ((InputStream)cachedInputStream2).read()) > 0) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            for (int i = 0; i < n2; ++i) {
                File file = this.createFile();
                this.files_list.addElement(file);
                if (bl) {
                    int n8 = ((InputStream)cachedInputStream2).read();
                    n8 = n8 << 8 | ((InputStream)cachedInputStream2).read();
                    n8 = n8 << 8 | ((InputStream)cachedInputStream2).read();
                    file.offset = n8 << 8 | ((InputStream)cachedInputStream2).read();
                    if (n == 0) {
                        n8 = ((InputStream)cachedInputStream2).read();
                        n8 = n8 << 8 | ((InputStream)cachedInputStream2).read();
                        file.size = n8 << 8 | ((InputStream)cachedInputStream2).read();
                    }
                    if (file.offset != 0) continue;
                    throw new IOException("DjVmDir.no_indirect");
                }
                file.size = 0;
                file.offset = 0;
            }
            BSInputStream bSInputStream = BSInputStream.createBSInputStream(this).init(cachedInputStream2);
            if (n > 0) {
                for (int i = 0; i < this.files_list.size(); ++i) {
                    File file = (File)this.files_list.elementAt(i);
                    n7 = ((InputStream)bSInputStream).read();
                    n7 = n7 << 8 | ((InputStream)bSInputStream).read();
                    file.size = n7 = n7 << 8 | ((InputStream)bSInputStream).read();
                }
            }
            for (n6 = 0; n6 < this.files_list.size(); ++n6) {
                File file = (File)this.files_list.elementAt(n6);
                file.flags = (byte)((InputStream)bSInputStream).read();
            }
            if (n == 0) {
                for (n6 = 0; n6 < this.files_list.size(); ++n6) {
                    File file = (File)this.files_list.elementAt(n6);
                    n7 = file.flags;
                    int n9 = n5 = (n7 & 1) != 0 ? 1 : 0;
                    if ((n7 & 2) != 0) {
                        n5 = (byte)(n5 | 0xFFFFFF80);
                    }
                    if ((n7 & 4) != 0) {
                        n5 = (byte)(n5 | 0x40);
                    }
                    file.flags = (byte)n5;
                }
            }
            if (this.files_list.size() > 0) {
                int n10;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n7 = bSInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n7);
                }
                byArray = byteArrayOutputStream.toByteArray();
                Vector<String> vector = new Vector<String>();
                n5 = 0;
                for (n10 = 0; n10 < byArray.length; ++n10) {
                    if (byArray[n10] != 0) continue;
                    String string = new String(byArray, n5, n10 - n5);
                    vector.addElement(string);
                    n5 = n10 + 1;
                }
                if (n5 < n10) {
                    vector.addElement(new String(byArray, n5, n10 - n5));
                }
                int n11 = 0;
                for (int i = 0; i < this.files_list.size(); ++i) {
                    File file = (File)this.files_list.elementAt(i);
                    file.id = (String)vector.elementAt(n11++);
                    if ((file.flags & 0xFFFFFF80) != 0) {
                        file.name = (String)vector.elementAt(n11++);
                    } else {
                        file.name = file.id;
                    }
                    if ((file.flags & 0x40) != 0) {
                        file.name = (String)vector.elementAt(n11++);
                        continue;
                    }
                    file.title = file.id;
                }
            }
            int n12 = 0;
            for (n4 = 0; n4 < this.files_list.size(); ++n4) {
                File file = (File)this.files_list.elementAt(n4);
                if (!file.is_shared_anno()) continue;
                ++n12;
            }
            if (n12 > 1) {
                throw new IOException("DjVmDir.corrupt");
            }
            n4 = 0;
            for (n3 = 0; n3 < this.files_list.size(); ++n3) {
                File file = (File)this.files_list.elementAt(n3);
                if (!file.is_page()) continue;
                ++n4;
            }
            this.page2file.setSize(0);
            for (n3 = 0; n3 < this.files_list.size(); ++n3) {
                File file = (File)this.files_list.elementAt(n3);
                if (!file.is_page()) continue;
                file.page_num = this.page2file.size();
                this.page2file.addElement(file);
            }
            for (n3 = 0; n3 < this.files_list.size(); ++n3) {
                File file = (File)this.files_list.elementAt(n3);
                if (this.name2file.contains(file.name)) {
                    throw new IOException("DjVmDir.dupl_name " + file.name);
                }
                this.name2file.put(file.name, file);
            }
            for (n3 = 0; n3 < this.files_list.size(); ++n3) {
                File file = (File)this.files_list.elementAt(n3);
                if (this.id2file.contains(file.id)) {
                    throw new IOException("DjVmDir.dupl_id " + file.id);
                }
                this.id2file.put(file.id, file);
            }
            for (n3 = 0; n3 < this.files_list.size(); ++n3) {
                File file = (File)this.files_list.elementAt(n3);
                if (file.title == null || file.title.length() <= 0) continue;
                if (this.title2file.contains(file.title)) {
                    throw new IOException("DjVmDir.dupl_title " + file.title);
                }
                this.title2file.put(file.title, file);
            }
        }
    }

    public synchronized void delete_file(String string) {
        for (int i = 0; i < this.files_list.size(); ++i) {
            File file = (File)this.files_list.elementAt(i);
            if (!string.equals(file.id)) continue;
            this.name2file.remove(file.name);
            this.id2file.remove(file.id);
            this.title2file.remove(file.title);
            if (file.is_page()) {
                for (int j = 0; j < this.page2file.size(); ++j) {
                    if (!file.equals(this.page2file.elementAt(j))) continue;
                    this.page2file.removeElementAt(j);
                    while (j < this.page2file.size()) {
                        File file2 = (File)this.page2file.elementAt(j);
                        file2.page_num = j;
                        ++j;
                    }
                    break;
                }
            }
            this.files_list.removeElementAt(i);
            break;
        }
    }

    public synchronized int get_file_pos(File file) {
        for (int i = 0; i < this.files_list.size(); ++i) {
            if (!file.equals(this.files_list.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public synchronized Vector get_files_list() {
        return this.files_list;
    }

    public synchronized int get_files_num() {
        return this.files_list.size();
    }

    public synchronized int get_page_pos(int n) {
        File file = this.page_to_file(n);
        return file != null ? this.get_file_pos(file) : -1;
    }

    public synchronized int get_pages_num() {
        return this.page2file.size();
    }

    public synchronized File get_shared_anno_file() {
        File file = null;
        for (int i = 0; i < this.files_list.size(); ++i) {
            File file2 = (File)this.files_list.elementAt(i);
            if (!file2.is_shared_anno()) continue;
            file = file2;
            break;
        }
        return file;
    }

    public synchronized File id_to_file(String string) {
        return (File)this.id2file.get(string);
    }

    public int insert_file(File file) throws IOException {
        return this.insert_file(file, -1);
    }

    public synchronized int insert_file(File file, int n) throws IOException {
        int n2;
        if (n < 0) {
            n = this.files_list.size();
        }
        if (this.id2file.contains(file.id)) {
            throw new IOException("DjVmDir.dupl_id2 " + file.id);
        }
        if (this.name2file.contains(file.name)) {
            throw new IOException("DjVmDir.dupl_name2 " + file.name);
        }
        this.name2file.put(file.name, file);
        this.id2file.put(file.id, file);
        if (file.title.length() > 0) {
            if (this.title2file.contains(file.title)) {
                throw new IOException("DjVmDir.dupl_title2 " + file.title);
            }
            this.title2file.put(file.title, file);
        }
        if (file.is_shared_anno()) {
            for (n2 = 0; n2 < this.files_list.size(); ++n2) {
                File file2 = (File)this.files_list.elementAt(n2);
                if (!file.is_shared_anno()) continue;
                throw new IOException("DjVmDir.multi_save2");
            }
        }
        this.files_list.insertElementAt(file, n);
        if (file.is_page()) {
            File file3;
            int n3;
            n2 = 0;
            for (n3 = 0; n3 < this.files_list.size() && !(file3 = (File)this.files_list.elementAt(n3)).equals(file); ++n3) {
                if (!file3.is_page()) continue;
                ++n2;
            }
            this.page2file.insertElementAt(file, n2);
            for (n3 = n2; n3 < this.page2file.size(); ++n3) {
                file3 = (File)this.page2file.elementAt(n3);
                file3.page_num = n3;
            }
        }
        return n;
    }

    public boolean is_bundled() {
        return !this.is_indirect();
    }

    public synchronized boolean is_indirect() {
        return this.files_list.size() > 0 && this.files_list.elementAt(0) != null && ((File)this.files_list.elementAt((int)0)).offset == 0;
    }

    public synchronized File name_to_file(String string) {
        return (File)this.name2file.get(string);
    }

    public synchronized File page_to_file(int n) {
        return n < this.page2file.size() ? this.page2file.elementAt(n) : null;
    }

    public synchronized void set_file_name(String string, String string2) throws IOException {
        for (int i = 0; i < this.files_list.size(); ++i) {
            File file = (File)this.files_list.elementAt(i);
            if (string.equals(file.id) || !string2.equals(file.name)) continue;
            throw new IOException("DjVmDir.name_in_use " + string2);
        }
        File file = (File)this.id2file.get(string);
        if (file == null) {
            throw new IOException("DjVmDir.no_info " + string);
        }
        this.name2file.remove(file.name);
        file.name = string2;
        this.name2file.put(string2, file);
    }

    public synchronized void set_file_title(String string, String string2) throws IOException {
        for (int i = 0; i < this.files_list.size(); ++i) {
            File file = (File)this.files_list.elementAt(i);
            if (string.equals(file.id) || !string2.equals(file.title)) continue;
            throw new IOException("DjVmDir.title_in_use " + string2);
        }
        File file = (File)this.id2file.get(string);
        if (file == null) {
            throw new IOException("DjVmDir.no_info " + string);
        }
        this.title2file.remove(file.title);
        file.title = string2;
        this.title2file.put(string2, file);
    }

    public synchronized File title_to_file(String string) {
        return (File)this.title2file.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class File
    implements Cloneable {
        public static final byte INCLUDE = 0;
        public static final byte PAGE = 1;
        public static final byte THUMBNAILS = 2;
        public static final byte SHARED_ANNO = 3;
        private static final byte IS_PAGE_0 = 1;
        private static final byte HAS_NAME_0 = 2;
        private static final byte HAS_TITLE_0 = 4;
        private static final byte HAS_NAME = -128;
        private static final byte HAS_TITLE = 64;
        private static final byte TYPE_MASK = 63;
        public int offset = 0;
        public int size = 0;
        private String id = null;
        private String name = null;
        private String title = null;
        private byte flags = 0;
        private int page_num = -1;

        public File() {
        }

        public File(String string, String string2, String string3, int n) {
            this.set_load_name(string);
            this.set_save_name(string2);
            this.set_title(string3);
            this.flags = (byte)(n & 0x3F);
        }

        public Object clone() {
            File file = null;
            try {
                file = (File)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return file;
        }

        public final String get_load_name() {
            return this.id;
        }

        public final String get_save_name() {
            return this.name != null && this.name.length() > 0 ? this.name : this.id;
        }

        public final String get_title() {
            return this.title != null && this.title.length() > 0 ? this.title : this.id;
        }

        public final int get_page_num() {
            return this.page_num;
        }

        public String get_str_type() throws IOException {
            String string;
            switch (this.flags & 0x3F) {
                case 0: {
                    string = "INCLUDE";
                    break;
                }
                case 1: {
                    string = "PAGE";
                    break;
                }
                case 2: {
                    string = "THUMBNAILS";
                    break;
                }
                case 3: {
                    string = "SHARED_ANNO";
                    break;
                }
                default: {
                    throw new IOException("DjVmDir.get_str_type");
                }
            }
            return string;
        }

        public boolean is_include() {
            return (this.flags & 0x3F) == 0;
        }

        public boolean is_page() {
            return (this.flags & 0x3F) == 1;
        }

        public boolean is_shared_anno() {
            return (this.flags & 0x3F) == 3;
        }

        public boolean is_thumbnails() {
            return (this.flags & 0x3F) == 2;
        }

        public void set_load_name(String string) {
            int n = string.lastIndexOf(47);
            this.id = n != -1 ? string.substring(n) : string;
        }

        public void set_title(String string) {
            this.title = string;
        }

        protected void set_save_name(String string) {
            int n = string.lastIndexOf(47);
            this.name = n != -1 ? string.substring(n) : string;
        }
    }
}

