/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;

public class DataPool
extends DjVuObject {
    public static final int BLOCKSIZE = 8192;
    public static Hashtable cache = new Hashtable();
    private final Vector buffer = new Vector();
    private int endOffset = Integer.MAX_VALUE;
    private URL url = null;
    private InputStream input = null;
    private boolean rangeAccepted = true;
    private int cacheAccessIndex = 0;
    private Object[] cacheAccessArray = new Object[256];
    private int cacheCreatedIndex = 0;
    private Object[] cacheCreatedArray = new Object[256];
    private int currentSize = 0;
    static /* synthetic */ Class class$com$lizardtech$djvu$DataPool;

    public static DataPool createDataPool(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (DataPool)DjVuObject.create(djVuOptions, djVuOptions.getDataPoolClass(), class$com$lizardtech$djvu$DataPool == null ? (class$com$lizardtech$djvu$DataPool = DataPool.class$("com.lizardtech.djvu.DataPool")) : class$com$lizardtech$djvu$DataPool);
    }

    public DataPool init(URL uRL) {
        this.url = uRL;
        DataPool dataPool = this;
        if (uRL != null && (dataPool = (DataPool)DjVuObject.getFromReference(cache.get(uRL))) == null) {
            dataPool = this;
            cache.put(uRL, DjVuObject.createSoftReference(this, this));
        }
        return dataPool;
    }

    public DataPool init(InputStream inputStream) {
        this.input = inputStream;
        this.rangeAccepted = false;
        return this;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public byte[] getBlock(int n, boolean bl) {
        Object object;
        int n2 = n * 8192;
        if (n < 0 || n2 >= this.endOffset) {
            return null;
        }
        if (n < this.buffer.size() && (object = this.buffer.elementAt(n)) != null) {
            if (object.getClass().isArray()) {
                return (byte[])object;
            }
            if ((object = DjVuObject.getFromReference(object)) != null) {
                if (bl && this.cacheAccessArray[this.cacheAccessIndex % this.cacheAccessArray.length] != object) {
                    this.cacheAccessArray[this.cacheAccessIndex++ % this.cacheAccessArray.length] = object;
                }
                return (byte[])object;
            }
        }
        return bl ? this.readBlock(n) : null;
    }

    private synchronized byte[] readBlock(int n) {
        byte[] byArray = this.getBlock(n, false);
        if (byArray == null) {
            int n2 = 0;
            int n3 = n * 8192;
            int n4 = (n + 1) * 8192;
            InputStream inputStream = this.input;
            while (inputStream != null && this.buffer.size() < n) {
                if (this.getBlock(this.buffer.size(), true) == null) {
                    return null;
                }
                inputStream = this.input;
            }
            block15: while (n3 < this.endOffset && n3 < n4) {
                int n5;
                if (inputStream == null) {
                    if (this.rangeAccepted && this.url != null) {
                        try {
                            URLConnection uRLConnection = this.url.openConnection();
                            if (uRLConnection instanceof HttpURLConnection) {
                                uRLConnection.setRequestProperty("Range", "bytes=" + n3 + "-" + (n4 - 1));
                                uRLConnection.connect();
                                n5 = ((HttpURLConnection)uRLConnection).getResponseCode();
                                if (n5 == 206) {
                                    inputStream = uRLConnection.getInputStream();
                                } else if (n5 / 100 == 2 && n3 == 0) {
                                    this.input = inputStream = uRLConnection.getInputStream();
                                    this.rangeAccepted = false;
                                } else {
                                    if (n4 < this.currentSize) {
                                        uRLConnection = null;
                                        System.gc();
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        continue;
                                    }
                                    DjVuOptions.out.println("Server response " + n5 + " requested " + n3 + "," + n4);
                                }
                            } else if (n3 == 0 && uRLConnection != null) {
                                this.input = inputStream = uRLConnection.getInputStream();
                                this.rangeAccepted = false;
                            }
                        }
                        catch (IOException iOException) {
                            DjVuObject.printStackTrace(iOException);
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                inputStream = null;
                            }
                            System.gc();
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (this.rangeAccepted && ++n2 < 10) continue;
                        }
                    }
                    if (inputStream == null) {
                        n4 = n3;
                        this.setEndOffset(n4);
                        break;
                    }
                }
                if (byArray == null) {
                    byArray = new byte[8192];
                }
                int n6 = n4 - n3;
                while (n6 > 0) {
                    block40: {
                        n5 = n3 % 8192;
                        int n7 = 0;
                        try {
                            n7 = inputStream.read(byArray, n5, n6);
                        }
                        catch (Throwable throwable) {
                            DjVuObject.printStackTrace(throwable);
                            if (this.rangeAccepted && ++n2 < 10) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                                inputStream = null;
                                break block40;
                            }
                            n7 = 0;
                        }
                        n2 = 0;
                        if (n7 <= 0) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            inputStream = null;
                            this.input = null;
                            n4 = n3;
                            this.setEndOffset(n4);
                            if (n5 > 0) {
                                byte[] byArray2 = new byte[n5];
                                System.arraycopy(byArray, 0, byArray2, 0, n5);
                                byArray = byArray2;
                                continue block15;
                            }
                            byArray = null;
                            continue block15;
                        }
                        n3 += n7;
                    }
                    n6 = n3 - n4;
                }
            }
            if (byArray != null) {
                if (this.buffer.size() <= n) {
                    this.buffer.setSize(n + 1);
                }
                if (this.rangeAccepted && n > 0) {
                    this.buffer.setElementAt(DjVuObject.createSoftReference(byArray, byArray), n);
                    this.cacheCreatedArray[this.cacheCreatedIndex++ % this.cacheCreatedArray.length] = byArray;
                } else {
                    this.buffer.setElementAt(byArray, n);
                }
                if (n4 > this.currentSize) {
                    this.currentSize = n4;
                }
            }
        }
        return byArray;
    }

    protected synchronized void setEndOffset(int n) {
        if (n < this.endOffset) {
            this.endOffset = n;
            int n2 = (n + 8192 - 1) / 8192;
            if (n2 > this.buffer.size()) {
                this.buffer.setSize(n2);
            }
        }
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

