from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__   = 'GPL v3'
__copyright__ = '2013, Jellby <jellby@yahoo.com>'
__docformat__ = 'restructuredtext en'

from calibre.gui2.actions import InterfaceAction
from calibre_plugins.prince_pdf.main import PrincePDFDialog

class InterfacePlugin(InterfaceAction):

    name = 'Prince PDF'
    action_spec = ('Prince PDF', None, 'Run the Prince PDF Plugin', (None))

    def genesis(self):
        icon = get_icons('images/icon.png')
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_dialog)

    def show_dialog(self):
        base_plugin_object = self.interface_action_base_plugin
        do_user_config = base_plugin_object.do_user_config
        d = PrincePDFDialog(self.gui, self.qaction.icon(), do_user_config)
        d.show()

    def apply_settings(self):
        from calibre_plugins.prince_pdf.config import prefs
        prefs
