from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__   = 'GPL v3'
__copyright__ = '2013, Jellby <jellby@yahoo.com>'
__docformat__ = 'restructuredtext en'

from PyQt4.Qt import QDialog, QDialogButtonBox, QTextEdit, QVBoxLayout

# This dialog shows the log from the Prince run
class LogDialog(QDialog):

    # GUI definitio
    def __init__(self, log, icon):
        QDialog.__init__(self)

        self.setWindowTitle('Prince log')
        self.setWindowIcon(icon)

        self.l = QVBoxLayout()
        self.setLayout(self.l)

        self.box = QTextEdit()
        self.box.setText(log)
        self.box.setMinimumWidth(500)
        self.box.setLineWrapMode(QTextEdit.NoWrap)
        self.box.setReadOnly(True)
        self.box.setToolTip("<qt>Console output from the last Prince run</qt>")
        self.l.addWidget(self.box)
         
        self.buttons = QDialogButtonBox(QDialogButtonBox.Ok)
        self.l.addWidget(self.buttons)
        self.buttons.accepted.connect(self.accept)

        self.resize(self.sizeHint())
