from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__   = 'GPL v3'
__copyright__ = '2013, Jellby <jellby@yahoo.com>'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class PrincePDFPlugin(InterfaceActionBase):
    name                    = 'Prince PDF'
    description             = 'Converts to PDF using the Prince software (third-party)'
    supported_platforms     = ['linux']
    author                  = 'Jellby'
    version                 = (1, 0, 0)
    minimum_calibre_version = (0, 7, 53)
    actual_plugin           = 'calibre_plugins.prince_pdf.ui:InterfacePlugin'

    def is_customizable(self):
        return True

    def config_widget(self):
        from calibre_plugins.prince_pdf.config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):
        config_widget.save_settings()
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
