#!/bin/ash

SH_IVTOOL=/mnt/ext1/system/bin/sh_ivtool.app

changegamma() { 

	STATUS="`cat /mnt/ext1/system/config/global.cfg | grep Gamma`"

	PRG=`$SH_IVTOOL -o Adobe,DjVu,"Adobe and DjVu","Read Gamma","Read Gamma and Contrast","Backup global.cfg",About,QUIT`

	if [ $? -eq 0 -a "$PRG" == "Adobe" ]; then
	CHANGE="`echo "$STATUS" | grep "$PRG" | sed "s/GammaLevel//"`"
	NEW=`$SH_IVTOOL -t "$CHANGE, new Γ (x.x, q=quit):"`
		if [ $? -eq 0 -a "$NEW" == "q" ]; then
		readgamma
		else
		sed -i "s/GammaLevelAdobe=.*/GammaLevelAdobe="$NEW"/" /mnt/ext1/system/config/global.cfg
		newgamma
		fi
	fi

	if [ $? -eq 0 -a "$PRG" == "DjVu" ]; then
	CHANGE="`echo "$STATUS" | grep "$PRG" | sed "s/GammaLevel//"`"
	NEW=`$SH_IVTOOL -t "$CHANGE, new Γ (x.x, q=quit):"`
		if [ $? -eq 0 -a "$NEW" == "q" ]; then
		readgamma
		else
		sed -i "s/GammaLevelDjVu=.*/GammaLevelDjVu="$NEW"/" /mnt/ext1/system/config/global.cfg	
		newgamma
		fi
	fi

	if [ $? -eq 0 -a "$PRG" == "Adobe and DjVu" ]; then
	CHANGEA="`echo "$STATUS" | grep GammaLevelAdobe | sed "s/GammaLevelAdobe//"`"
	CHANGED="`echo "$STATUS" | grep GammaLevelDjVu | sed "s/GammaLevelDjVu//"`"
	NEW=`$SH_IVTOOL -t "A$CHANGEA, D$CHANGED, new Γ (x.x y.y, q=quit):"`
		if [ $? -eq 0 -a "$NEW" == "q" ]; then
		readgamma
		else
		NEWA=`echo ${NEW:0:3}`
		NEWD=`echo ${NEW:4:3}`
		sed -i "s/GammaLevelAdobe=.*/GammaLevelAdobe="$NEWA"/" /mnt/ext1/system/config/global.cfg	
		sed -i "s/GammaLevelDjVu=.*/GammaLevelDjVu="$NEWD"/" /mnt/ext1/system/config/global.cfg
		newgamma
		fi
	fi

	if [ $? -eq 0 -a "$PRG" == "Read Gamma" ]; then
	readgamma
	fi

	if [ $? -eq 0 -a "$PRG" == "Read Gamma and Contrast" ]; then
	readall
	fi

	if [ $? -eq 0 -a "$PRG" == "Backup global.cfg" ]; then
	backup
	fi

	if [ $? -eq 0 -a "$PRG" == "QUIT" ]; then
	exit
	fi

    if [ $? -eq 0 -a "$PRG" == "About" ]; then
	about
	fi
}

newgamma() { 
	$SH_IVTOOL -s "New Gamma settings:
	`cat /mnt/ext1/system/config/global.cfg | grep Gamma | sed "s/GammaLevel//"`"
	changegamma
	}

readgamma() { 
	$SH_IVTOOL -s "Current Gamma settings:
	
	`cat /mnt/ext1/system/config/global.cfg | grep Gamma | sed "s/GammaLevel//"`"
	changegamma
	}

readall() { 
	$SH_IVTOOL -s "Current Gamma and Contrast settings for Adobe and DjVu:
	
	`cat /mnt/ext1/system/config/global.cfg | grep Adobe`
	
	`cat /mnt/ext1/system/config/global.cfg | grep DjVu`"
	changegamma
	}

backup() {
	cp /mnt/ext1/system/config/global.cfg /mnt/ext1/system/config/global.cfg.old
	$SH_IVTOOL -s "global.cfg.old written to
	/mnt/ext1/system/config/"
	changegamma
	}

about() { 
	$SH_IVTOOL -s "Change Gamma (Γ) settings for 
	Adobe and/or DjVu reader
	
	Input the new value in the format 'x.x' (integer with one decimal)
	for instance 2.5
	is accepted any value but 'q'
	
	'q' quit without changes
	
	by Paolo"
	changegamma
	}

changegamma

exit

