#!/bin/sh
##################################################################################
#
# Twobob redefined starter for a rgbpaint application.
#
##################################################################################

#setup helpful variables...
		APP=rgbpaint

		EXTENSION=/mnt/us/extensions

export	LD_LIBRARY_PATH=${EXTENSION}/pente/usr/lib:/usr/lib:/lib	

#( same command for PW + Touch so ditch the detection )
#		PLATFORM="$(cat /sys/devices/platform/mxc_epdc_fb/graphics/fb0/modes)"

		SSSTATE=`lipc-get-prop com.lab126.powerd preventScreenSaver` 

cd /mnt/us/extensions/$APP

# be certin we only have one instance

killall -9 $APP &> /dev/null
usleep 500

# prevent SS from bothering us mid app.
lipc-set-prop com.lab126.powerd preventScreenSaver 1


# Prepare the file image that will go into /mnt/us/images/ folder
newfile="Rgbpaint_"$(date +%d-%m-%y_%k-%M-%S)".png"
blank="/mnt/us/extensions/rgbpaint/usr/bin/misc/blank.png"

# If is Kindle Touch, we change the name of the blank file we want to copy
PLATFORM="$(cat /sys/devices/platform/mxc_epdc_fb/graphics/fb0/modes)"
if [ "$PLATFORM" = "${PLATFORM/758/}" ]; then blank="/mnt/us/extensions/rgbpaint/usr/bin/misc/blank_touch.png";fi

# If images folder doesn't exist, create it
if [ ! -f "/mnt/us/images/" ];then mkdir /mnt/us/images/ ;fi

# Copy the file
cp "$blank" /mnt/us/images/"$newfile"
modification_time=$(stat -c %Y /mnt/us/images/"$newfile")

# Run it ( same command for PW + Touch so ditch the detection )
GTK_IM_MODULE=kindle \
GDK_PIXBUF_MODULE_FILE=/mnt/us/extensions/$APP/usr/bin/pixbuf/gdk-pixbuf.loaders \
${EXTENSION}/$APP/usr/bin/$APP -d /mnt/us/images /mnt/us/images/"$newfile"

# If the user didn't save the file, delete it from /mnt/us/image folder
if [ "$modification_time" == $(stat -c %Y /mnt/us/images/"$newfile") ];then sleep 3;rm /mnt/us/images/"$newfile";fi

lipc-set-prop com.lab126.powerd preventScreenSaver "$SSSTATE" 


