package de.telekom.epub.utils.reflection;

import android.app.Activity;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil
{
  private static final String LOG_TAG = ReflectionUtil.class.getSimpleName();
  
  public static boolean activity_isResumed(Activity paramActivity)
  {
    try
    {
      boolean bool = Boolean.parseBoolean(paramActivity.getClass().getMethod("isResumed", new Class[0]).invoke(paramActivity, new Object[0]).toString());
      return bool;
    }
    catch (SecurityException localSecurityException)
    {
      Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      return false;
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      return false;
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      return false;
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      return false;
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
    }
    return false;
  }
  
  public static File environment_getExternalExtSDStorageDirectory()
  {
    try
    {
      Object localObject = Class.forName("android.os.Environment").getMethod("getExternalExtSDStorageDirectory", new Class[0]).invoke(null, new Object[0]);
      Log.d(LOG_TAG, ((File)localObject).getAbsolutePath());
      if ((localObject instanceof File))
      {
        File localFile = (File)localObject;
        return localFile;
      }
      return null;
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      Log.e(LOG_TAG, localClassNotFoundException.getMessage(), localClassNotFoundException);
      return null;
    }
    catch (SecurityException localSecurityException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      }
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      }
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      }
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      }
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
      }
    }
  }
  
  public static String environment_getExternalExtSDStorageState()
  {
    try
    {
      Object localObject = Class.forName("android.os.Environment").getMethod("getExternalExtSDStorageState", new Class[0]).invoke(null, new Object[0]);
      if ((localObject instanceof String))
      {
        String str = (String)localObject;
        return str;
      }
      return null;
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      Log.e(LOG_TAG, localClassNotFoundException.getMessage(), localClassNotFoundException);
      return null;
    }
    catch (SecurityException localSecurityException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      }
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      }
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      }
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      }
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
      }
    }
  }
  
  public static void epdWrapper_enableAutoWaveformMode(boolean paramBoolean)
  {
    try
    {
      Class localClass = Class.forName("com.koobe.android.lib.epd.EPDWrapper");
      Class[] arrayOfClass = new Class[1];
      arrayOfClass[0] = Boolean.TYPE;
      Method localMethod = localClass.getMethod("enableAutoWaveformMode", arrayOfClass);
      Object[] arrayOfObject = new Object[1];
      arrayOfObject[0] = Boolean.valueOf(paramBoolean);
      localMethod.invoke(null, arrayOfObject);
      return;
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      Log.e(LOG_TAG, localClassNotFoundException.getMessage(), localClassNotFoundException);
      return;
    }
    catch (SecurityException localSecurityException)
    {
      Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      return;
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      return;
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      return;
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      return;
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
    }
  }

  public static String systemProperties_get(String paramString1, String paramString2)
  {
    try
    {
      Object localObject = Class.forName("android.os.SystemProperties").getMethod("get", new Class[] { String.class, String.class }).invoke(null, new Object[] { paramString1, paramString2 });
      if ((localObject instanceof String))
      {
        String str = (String)localObject;
        return str;
      }
      return null;
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      Log.e(LOG_TAG, localClassNotFoundException.getMessage(), localClassNotFoundException);
      return null;
    }
    catch (SecurityException localSecurityException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      }
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      }
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      }
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      }
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
      }
    }
  }
  
  public static String usbManage_getConstant(String paramString)
  {
    try
    {
      String str = (String)Class.forName("android.hardware.usb.UsbManager").getDeclaredField(paramString).get(null);
      return str;
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      Log.e(LOG_TAG, localClassNotFoundException.getMessage(), localClassNotFoundException);
      return null;
    }
    catch (SecurityException localSecurityException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      }
    }
    catch (NoSuchFieldException localNoSuchFieldException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localNoSuchFieldException.getMessage(), localNoSuchFieldException);
      }
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      }
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      }
    }
  }
  
  public static void view_invalidate(View paramView, int paramInt)
  {
    try
    {
      Class localClass = paramView.getClass();
      Class[] arrayOfClass = new Class[1];
      arrayOfClass[0] = Integer.TYPE;
      Method localMethod = localClass.getMethod("invalidate", arrayOfClass);
      Object[] arrayOfObject = new Object[1];
      arrayOfObject[0] = Integer.valueOf(paramInt);
      localMethod.invoke(paramView, arrayOfObject);
      return;
    }
    catch (SecurityException localSecurityException)
    {
      Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      return;
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      return;
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      return;
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      return;
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
    }
  }
  
  public static void view_postInvalidate(View paramView, int paramInt)
  {
    try
    {
      Class localClass = paramView.getClass();
      Class[] arrayOfClass = new Class[1];
      arrayOfClass[0] = Integer.TYPE;
      Method localMethod = localClass.getMethod("postInvalidate", arrayOfClass);
      Object[] arrayOfObject = new Object[1];
      arrayOfObject[0] = Integer.valueOf(paramInt);
      localMethod.invoke(paramView, arrayOfObject);
      return;
    }
    catch (SecurityException localSecurityException)
    {
      Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      return;
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      return;
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      return;
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      return;
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
    }
  }
  
  public static void view_postInvalidateDelayed(View paramView, long paramLong, int paramInt)
  {
    try
    {
      Class localClass = paramView.getClass();
      Class[] arrayOfClass = new Class[2];
      arrayOfClass[0] = Long.TYPE;
      arrayOfClass[1] = Integer.TYPE;
      Method localMethod = localClass.getMethod("postInvalidateDelayed", arrayOfClass);
      Object[] arrayOfObject = new Object[2];
      arrayOfObject[0] = Long.valueOf(paramLong);
      arrayOfObject[1] = Integer.valueOf(paramInt);
      localMethod.invoke(paramView, arrayOfObject);
      return;
    }
    catch (SecurityException localSecurityException)
    {
      Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      return;
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      return;
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      return;
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      return;
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
    }
  }
  
  public static void view_postInvalidateDelayed(View paramView, Rect paramRect, long paramLong, int paramInt)
  {
    try
    {
      Class localClass = paramView.getClass();
      Class[] arrayOfClass = new Class[6];
      arrayOfClass[0] = Long.TYPE;
      arrayOfClass[1] = Integer.TYPE;
      arrayOfClass[2] = Integer.TYPE;
      arrayOfClass[3] = Integer.TYPE;
      arrayOfClass[4] = Integer.TYPE;
      arrayOfClass[5] = Integer.TYPE;
      Method localMethod = localClass.getMethod("postInvalidateDelayed", arrayOfClass);
      Object[] arrayOfObject = new Object[6];
      arrayOfObject[0] = Long.valueOf(paramLong);
      arrayOfObject[1] = Integer.valueOf(paramRect.left);
      arrayOfObject[2] = Integer.valueOf(paramRect.top);
      arrayOfObject[3] = Integer.valueOf(paramRect.right);
      arrayOfObject[4] = Integer.valueOf(paramRect.bottom);
      arrayOfObject[5] = Integer.valueOf(paramInt);
      localMethod.invoke(paramView, arrayOfObject);
      return;
    }
    catch (SecurityException localSecurityException)
    {
      Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      return;
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      return;
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      return;
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      return;
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
    }
  }
  
  public static long vmRuntime_setMinimumHeapSize(long paramLong)
  {
    try
    {
      Class localClass = Class.forName("dalvik.system.VMRuntime");
      Object localObject = localClass.getMethod("getRuntime", new Class[0]).invoke(null, new Object[0]);
      Class[] arrayOfClass = new Class[1];
      arrayOfClass[0] = Long.TYPE;
      Method localMethod = localClass.getMethod("setMinimumHeapSize", arrayOfClass);
      Object[] arrayOfObject = new Object[1];
      arrayOfObject[0] = Long.valueOf(paramLong);
      long l = Long.parseLong(localMethod.invoke(localObject, arrayOfObject).toString());
      return l;
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      Log.e(LOG_TAG, localClassNotFoundException.getMessage(), localClassNotFoundException);
      return -1L;
    }
    catch (SecurityException localSecurityException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localSecurityException.getMessage(), localSecurityException);
      }
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localNoSuchMethodException.getMessage(), localNoSuchMethodException);
      }
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalArgumentException.getMessage(), localIllegalArgumentException);
      }
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localIllegalAccessException.getMessage(), localIllegalAccessException);
      }
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      for (;;)
      {
        Log.e(LOG_TAG, localInvocationTargetException.getMessage(), localInvocationTargetException);
      }
    }
  }
}
