package de.telekom.epub.utils;

import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import de.telekom.epub.utils.reflection.ReflectionUtil;

public class ScreenHelper
{
  public static final int A2 = 4;
  public static final long DEFAULT_REFRESH_DELAY_TIME = 50L;
  public static final int DU = 1;
  public static final int FB_COLOR_CODE_WHITE = 255;
  public static final int GC16_FULL = 34;
  public static final int GC16_PARTIAL = 2;
  public static final int GLD_F = 39;
  public static final int GLD_P = 7;
  public static final int GLR_FULL = 38;
  public static final int GLR_PARTIAL = 6;
  private static final String LOG_TAG = ScreenHelper.class.getSimpleName();
  public static final int NATIVE_UPDATE_MODE_FULL = 1;
  public static final int NATIVE_UPDATE_MODE_PARTIAL = 0;
  public static final int NATIVE_WAVEFORM_MODE_A2 = 4;
  public static final int NATIVE_WAVEFORM_MODE_DU = 1;
  public static final int NATIVE_WAVEFORM_MODE_GC16 = 2;
  public static final int NATIVE_WAVEFORM_MODE_GC4 = 3;
  public static final int NATIVE_WAVEFORM_MODE_INIT = 0;
  private static final int UPDATE_MODE_AUTO = 52;
  private static final int UPDATE_MODE_GC16 = 34;
  private static final int UPDATE_MODE_REAGL = 39;
  
  static
  {
    try
    {
        System.loadLibrary("epd");
    }
    catch (Throwable localThrowable)
    {
      Log.e(LOG_TAG, "unable to load screen helper library", localThrowable);
    }
  }
  
  private static native int FullRefresh();
  
  private static native int PartialRefresh(int paramInt1, int paramInt2, int paramInt3, int paramInt4);
  
  private static native int RegionalRefresh(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6);
  
  private static native int SetFBColor(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6);
  
  private static native int SetFBColorArray(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int[] paramArrayOfInt, int paramInt5);
  
  public static boolean fullRefresh()
  {
      try {
          int i = FullRefresh();
          if (i == 1) {
              return true;
          }
      } catch (Throwable t) {
          int j = 0;
          j = j + 1;
      }

      return false;
  }
  
  public static boolean partialRefresh(Rect paramRect)
  {
    return patrialRefresh(paramRect.left, paramRect.top, paramRect.right, paramRect.bottom);
  }
  
  public static boolean partialRefresh(View paramView)
  {
    Rect localRect = new Rect();
    paramView.getGlobalVisibleRect(localRect);
    return patrialRefresh(localRect.left, localRect.top, localRect.right, localRect.bottom);
  }
  
  public static boolean patrialRefresh(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
  {
    if ((paramInt3 - paramInt1 > 1) && (paramInt4 - paramInt2 > 1)) {
      if (RegionalRefresh(paramInt1, paramInt2, paramInt3, paramInt4, 2, 1) == 1) {
          return true;
      }
    }
    return false;
  }
  
  public static void refresh(View paramView, Rect paramRect, boolean delay, int mode)
  {
    if (delay)
    {
      ReflectionUtil.view_postInvalidateDelayed(paramView, paramRect, 50L, mode);
      return;
    }
    ReflectionUtil.view_postInvalidateDelayed(paramView, paramRect, 0L, mode);
  }
  
  public static void refresh(View paramView, boolean delay, int mode)
  {
    if (delay)
    {
      ReflectionUtil.view_postInvalidateDelayed(paramView, 50L, mode);
      return;
    }
    ReflectionUtil.view_invalidate(paramView, mode);
  }
  
  public static void refreshFull(View paramView, long delay)
  {
    if (delay > 0L)
    {
      ReflectionUtil.view_postInvalidateDelayed(paramView, delay, 34);
      return;
    }
    ReflectionUtil.view_invalidate(paramView, 34);
  }
  
  /*public static void refreshFull(View paramView, boolean paramBoolean)
  {
    if (paramBoolean) {}
    for (long l = 50L;; l = 0L)
    {
      refreshFull(paramView, l);
      return;
    }
  } */
}
