#! /bin/sh

. ../../config

PHYSKDIR=../../../physkeyb/src
PKGNAME="${HACKNAME}"
PKGVER="${VERSION}"

#cp -f $PHYSKDIR/physkeyb.jar $PHYSKDIR/*.kbd ./

KINDLE_MODELS="k3g k3w k3gb"
for model in ${KINDLE_MODELS} ; do
	# Prepare our files for this specific kindle model...
	ARCH=${PKGNAME}_${PKGVER}_${model}

	# Build install update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_install install.sh bcel-5.2.jar K3Translator.jar loc-bind loc-init msp_prefs translation.jar ui_loc.tar.gz physkeyb.jar kindle.kbd russian.kbd russian_fonetic.kbd

	# Build uninstall update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_uninstall uninstall.sh
done

# Pack the updates
rm -f ../${PKGNAME}_${PKGVER}.zip
zip ../${PKGNAME}_${PKGVER}.zip *.bin
rm -f *.bin
