#!/bin/sh
##
#
#  Detailed battery status
#
#  $Id: battery-status.sh 10070 2013-11-14 17:13:18Z NiLuJe $
#
##

# We need to get the proper constants for our model...
kusid="$(cat /proc/usid 2>&1)"
kmodel="$(echo "${kusid}" | sed -n -r 's/^(B0[0-9A-F]{2})([0-9A-Z]{12})$/\1/p')"
case "${kmodel}" in
	"B024" | "B01B" | "B01D" | "B01F" | "B01C" | "B020" | "B0D4" | "B05A" | "B0D5" )
		# PaperWhite...
		SCREEN_X_RES=768	# NOTE: Yes, 768, not 758...
		SCREEN_Y_RES=1024
		EIPS_X_RES=16
		EIPS_Y_RES=24		# Manually mesured, should be accurate.
	;;
	* )
		# Handle legacy devices...
		if [ -f "/etc/rc.d/functions" ] && grep "EIPS" "/etc/rc.d/functions" > /dev/null 2>&1 ; then
			. /etc/rc.d/functions
		else
			# Touch
			SCREEN_X_RES=600	# _v_width @ upstart/functions
			SCREEN_Y_RES=800	# _v_height @ upstart/functions
			EIPS_X_RES=12		# from f_puts @ upstart/functions
			EIPS_Y_RES=20		# from f_puts @ upstart/functions
		fi
	;;
esac
# And now we can do the maths ;)
EIPS_MAXCHARS="$((${SCREEN_X_RES} / ${EIPS_X_RES}))"
EIPS_MAXLINES="$((${SCREEN_Y_RES} / ${EIPS_Y_RES}))"

# Adapted from libkh[5]
eips_print_bottom_centered()
{
	# We need at least two args
	if [ $# -lt 2 ] ; then
		echo "not enough arguments passed to eips_print_bottom ($# while we need at least 2)"
		return
	fi

	kh_eips_string="${1}"
	kh_eips_y_shift_up="${2}"

	# Get the real string length now
	kh_eips_strlen="${#kh_eips_string}"

	# Add the right amount of left & right padding, since we're centered, and eips doesn't trigger a full refresh,
	# so we'll have to padd our string with blank spaces to make sure two consecutive messages don't run into each other
	kh_padlen="$(((${EIPS_MAXCHARS} - ${kh_eips_strlen}) / 2))"

	# Left padding...
	while [ ${#kh_eips_string} -lt $((${kh_eips_strlen} + ${kh_padlen})) ] ; do
		kh_eips_string=" ${kh_eips_string}"
	done

	# Right padding (crop to the edge of the screen)
	while [ ${#kh_eips_string} -lt ${EIPS_MAXCHARS} ] ; do
		kh_eips_string="${kh_eips_string} "
	done

	# Sleep a tiny bit to workaround the logic in the 'new' (K4+) eInk controllers that tries to bundle updates,
	# otherwise it may drop part of our messages because of other screen updates from KUAL...
	usleep 150000	# 150ms

	# And finally, show our formatted message centered on the bottom of the screen (NOTE: Redirect to /dev/null to kill unavailable character & pixel not in range warning messages)
	eips 0 $((${EIPS_MAXLINES} - 2 - ${kh_eips_y_shift_up})) "${kh_eips_string}" >/dev/null
}

# Print detailed infos on the screen
print_detailed_status()
{
	# Do eeeet!
	eips_print_bottom_centered "Battery charge @ $(gasgauge-info -c | tr '%' '/')100" 4	# Yep, eips can't print the '%' character...
	eips_print_bottom_centered "Drain/Load: $(gasgauge-info -l)" 3
	eips_print_bottom_centered "Capacity: $(gasgauge-info -m) - $(gasgauge-info -v)" 2
	# Extra convoluted call to convert F° to C°, since we don't have bc, and the awk implementation doesn't support the %.*f formatting for printf...
	eips_print_bottom_centered "Temperature: $(gasgauge-info -k) ($(printf "%.*f" "2" "$(echo "$(gasgauge-info -k | awk '{print $1}')" | awk '{print (($1 - 32) * (5/9))}')") Celsius)" 1
}

# Tweak the battery icon to print the current charge level inside it
tweak_battery_icon()
{
	# NOTE: Utter awesomeness from eureka!
	# See http://www.mobileread.com/forums/showpost.php?p=2660787&postcount=8

	# Build the javascript snippet (mash it in a single line, with properly escaped doubles quotes)
	SCRIPT="$(cat << EOS | tr -d '\n' | sed -e 's,",\\",g'
(function () {
  var _batteryMeterId = BatteryState.batteryFillDiv,
      _batteryMeterEl = _batteryMeterId && document.getElementById(_batteryMeterId),
      _currentBatteryLevel = nativeBridge.getIntLipcProperty("com.lab126.powerd", "battLevel"),
      _originalResolveLabel = BatteryState.resolveLabel;

  if (!_batteryMeterEl || !_originalResolveLabel) {
    return;
  }

  /* Text should be black to be visible. */
  _batteryMeterEl.style.color = "black";
  /* Add a small white outline to make it visible no matter what (< 50%) */
  _batteryMeterEl.style.webkitTextStroke = "0.75px white";
  /* Hack style to set vertical alignment of text. */
  _batteryMeterEl.style.lineHeight = "3.9pt";
  /* Add style for smaller font size. */
  _batteryMeterEl.style.fontSize = "5pt";
  /* Make it bold so that the outline doesn't eat into too much of the fill color */
  _batteryMeterEl.style.fontWeight = "bold";

  if (_currentBatteryLevel) {
    _batteryMeterEl.textContent = _currentBatteryLevel;
  }

  BatteryState.resolveLabel = function () {
    var batteryMeterId = BatteryState.batteryFillDiv,
        batteryMeterEl = batteryMeterId && document.getElementById(batteryMeterId);

    _originalResolveLabel();

    if (batteryMeterEl) {
      batteryMeterEl.textContent = BatteryState.percent;
    }
  };
})();
EOS
)"
	# Build the pillow json data
	MESSAGE='{
		"pillowId": "default_status_bar",
		"function": "'${SCRIPT}'"
	}'

	# And apply it :)
	lipc-set-prop -s com.lab126.pillow interrogatePillow "$MESSAGE"

	# Some feedback....
	eips_print_bottom_centered "Battery icon has been tweaked :)" 1
}

# Main
case "${1}" in
	"print_detailed_status" )
		${1}
	;;
	"tweak_battery_icon" )
		${1}
	;;
	* )
		eips_print_bottom_centered "invalid action" 1
	;;
esac

return 0
