#!/bin/sh

/mnt/us/extensions/kindlenotes/bin/sh/show_alert.sh "Exporting note..." 0 &

# If no parameter is given, exit the program
if [ -z "$1" ];then
echo "Missing path!"
return 1
fi

# Enter the working directory
cd /mnt/us/extensions/kindlenotes/bin/html/

# Take the path as first argument
EXPORT_PATH="$1"

# Get note number from active kindlenote.html file
noteNumber=$(ls kindlenotes*.html | sed -e s/[^0-9]//g)

# Restore escape characters 
sed 's/'`echo -e "\001"`'/\n/g' "note$noteNumber.txt" > exportednote1.txt
sed "s/"`echo -e '\002'`"/'/g" exportednote1.txt > exportednote2.txt
sed 's/'`echo -e "\003"`'/"/g' exportednote2.txt > exportednote3.txt
sed 's/'`echo -e "\004"`'/$/g' exportednote3.txt > exportednote4.txt

# Prepare output filename
newfile="$EXPORT_PATH""KindleNote_"$(date +%d-%m-%y_%k-%M-%S)".txt"
mv exportednote4.txt "$newfile" 

if [ $? == 0 ]; then
/mnt/us/extensions/kindlenotes/bin/sh/show_alert.sh "Note $noteNumber exported succesfully!" 5 &
else
/mnt/us/extensions/kindlenotes/bin/sh/show_alert.sh "Something did go wrong!" 2 &
fi

# Clean up temporary files
rm -rf exportednote*




# If the second parameter is "leafpad"
if [ "$2" == "leafpad" ]; then
/mnt/us/extensions/leafpad/bin/leafpad "$newfile"
fi


