#!/bin/sh
cd /mnt/us/extensions/kindlenotes/bin/html/

# removes old dialog page files
rm -rf kindlenotes*.html

# renames passed paramater
notenumber="$1"

# if no paramater is passed, behave as if would be passed 1
if [ -z "$1" ];then
notenumber='1'
fi

if [ ! -f "note$notenumber.txt" ];then
echo "New note $notenumber" >> "note$notenumber.txt"
fi


# Parses the first two files to concantenate, removing final carriage retuns
cp header1.html header1TEMP.html
echo "return $notenumber;" >> header1TEMP.html
awk '{q=p;p=$0}NR>1{print q}END{ORS = ""; print p}' header2.html > header2TEMP.html
awk '{q=p;p=$0}NR>1{print q}END{ORS = ""; print p}' note$notenumber.txt > noteTEMP.txt



# Concatenates the file, building the html dialog
cat header1TEMP.html header2TEMP.html noteTEMP.txt footer.html > "kindlenotes$notenumber.html"

# Removes temporary files
rm noteTEMP.txt header1TEMP.html header2TEMP.html


# Opens KindleText dialog
FIRST='{"name": "../../../../mnt/us/extensions/kindlenotes/bin/html/kindlenotes'
SECOND='"}'
lipc-set-prop com.lab126.pillow customDialog "$FIRST""$notenumber""$SECOND"S
