#!/bin/ash

SH_IVTOOL=/mnt/ext1/system/bin/sh_ivtool.app

STATUS="`cat /mnt/ext1/system/config/global.cfg | grep Gamma`"


ANSWER=`$SH_IVTOOL -q "$STATUS

Change gamma settings for 
Adobe or DjVu reader?"`

if [ $? -eq 0 -a "$ANSWER" == "y" ]; then

changegamma() {

	BACKUP=`$SH_IVTOOL -q "Make a backup of global.cfg in the same place?"`
	
	if [ $? -eq 0 -a "$BACKUP" == "y" ]; then
	
	cp /mnt/ext1/system/config/global.cfg /mnt/ext1/system/config/global.cfg.old
	
	fi

		PRG=`$SH_IVTOOL -o Adobe DjVu`

		CHANGE="`echo "$STATUS" | grep "$PRG"`"

		NEW=`$SH_IVTOOL -t "$CHANGE (new x.x)"`

		if [ $? -eq 0 -a "$PRG" == "Adobe" ]; then
	
		sed -i "s/GammaLevelAdobe=.*/GammaLevelAdobe="$NEW"/" /mnt/ext1/system/config/global.cfg

		fi

		if [ $? -eq 0 -a "$PRG" == "DjVu" ]; then

		sed -i "s/GammaLevelDjVu=.*/GammaLevelDjVu="$NEW"/" /mnt/ext1/system/config/global.cfg	
	
		fi

		$SH_IVTOOL -s "New gamma settings:
`cat /mnt/ext1/system/config/global.cfg | grep Gamma`"

}

changegamma

REPEAT=`$SH_IVTOOL -q "$STATUS

Change gamma settings again
for Adobe or DjVu reader?"`

if [ $? -eq 0 -a "$REPEAT" == "y" ]; then

changegamma

fi

fi
	
exit
