#!/bin/bash

# Pay attention if you modify the output path! It will be deleted

outputdir=/mnt/us/documents/Instapaper

# The following code from NiLuJe take care of eips screen printing
kusid="$(cat /proc/usid 2>&1)"
kmodel="$(echo "${kusid}" | sed -n -r 's/^(B0[0-9A-F]{2})([0-9A-Z]{12})$/\1/p')"
case "${kmodel}" in
	"B024" | "B01B" | "B01D" | "B01F" | "B01C" | "B020" )
		# PaperWhite...
		SCREEN_X_RES=758
		SCREEN_Y_RES=1024
		EIPS_Y_RES=24    # Manually mesured, should be accurate.
		EIPS_MAXCHARS=25
	;;
	* )
		# Handle legacy devices...
		if [ -f "/etc/rc.d/functions" ] && grep "EIPS" "/etc/rc.d/functions" > /dev/null 2>&1 ; then
			. /etc/rc.d/functions
		else
			# Touch
			SCREEN_X_RES=600	# _v_width @ upstart/functions
			SCREEN_Y_RES=800	# _v_height @ upstart/functions
			EIPS_Y_RES=20		# from f_puts @ upstart/functions
		fi

		# Applies to everyone, we don't care about the DX, since everything has to fit on the smaller screens anyway.
		EIPS_MAXCHARS=48
	;;
esac

# Adapted from libkh[5]
eips_print_bottom()
{
	# We need at least two args
	if [ $# -lt 2 ] ; then
		echo "not enough arguments passed to eips_print_bottom ($# while we need at least 2)"
		return
	fi

	kh_eips_string="${1}"
	kh_eips_y_shift_up="${2}"

	# Since eips doesn't trigger a full refresh, we'll have to padd our string with blank spaces to make sure two consecutive messages don't run into each other.
	while [ ${#kh_eips_string} -lt ${EIPS_MAXCHARS} ] ; do
		kh_eips_string="${kh_eips_string} "
	done

	# Sleep a tiny bit to workaround the logic in the 'new' (K4+) eInk controllers that tries to bundle updates,
	# otherwise it may drop part of our messages because of other screen updates from KUAL...
	usleep 150000	# 150ms

	# And finally, show our formatted 48 (or 46 on the PW) characters message on the bottom of the screen (NOTE: Redirect to /dev/null to kill unavailable character & pixel not in range warning messages)
	eips 10 $((${SCREEN_Y_RES} / ${EIPS_Y_RES} - 2 - ${kh_eips_y_shift_up})) "${kh_eips_string}" >/dev/null
}

eips_print_bottom "" 4
eips_print_bottom "" 3
eips_print_bottom "" 2
eips_print_bottom "" 1

rm -rf $outputdir

if [ "$?" -eq 0 ]; then eips_print_bottom "Download folder cleaned." 4
else eips_print_bottom "Nothing to delete." 4
fi

return 0
