#!/bin/bash

# Insert here your instapaper login details
username="your@email"
password="yourpassword"
#folder="/1234567" # Uncomment this line if you want to download articles from a folder other than "Read Later". Each folder is identified from a "some digit" number as in the example
workdir=/mnt/us/extensions/instafetcher/bin
outputdir=/mnt/us/documents/Instapaper
cookies=cookies.txt
format=mobi # Can also be epub.

# The following code from NiLuJe take care of eips screen printing
kusid="$(cat /proc/usid 2>&1)"
kmodel="$(echo "${kusid}" | sed -n -r 's/^(B0[0-9A-F]{2})([0-9A-Z]{12})$/\1/p')"
case "${kmodel}" in
	"B024" | "B01B" | "B01D" | "B01F" | "B01C" | "B020" )
		# PaperWhite...
		SCREEN_X_RES=758
		SCREEN_Y_RES=1024
		EIPS_Y_RES=24    # Manually mesured, should be accurate.
		EIPS_MAXCHARS=25
	;;
	* )
		# Handle legacy devices...
		if [ -f "/etc/rc.d/functions" ] && grep "EIPS" "/etc/rc.d/functions" > /dev/null 2>&1 ; then
			. /etc/rc.d/functions
		else
			# Touch
			SCREEN_X_RES=600	# _v_width @ upstart/functions
			SCREEN_Y_RES=800	# _v_height @ upstart/functions
			EIPS_Y_RES=20		# from f_puts @ upstart/functions
		fi

		# Applies to everyone, we don't care about the DX, since everything has to fit on the smaller screens anyway.
		EIPS_MAXCHARS=48
	;;
esac

# Adapted from libkh[5]
eips_print_bottom()
{
	# We need at least two args
	if [ $# -lt 2 ] ; then
		echo "not enough arguments passed to eips_print_bottom ($# while we need at least 2)"
		return
	fi

	kh_eips_string="${1}"
	kh_eips_y_shift_up="${2}"

	# Since eips doesn't trigger a full refresh, we'll have to padd our string with blank spaces to make sure two consecutive messages don't run into each other.
	while [ ${#kh_eips_string} -lt ${EIPS_MAXCHARS} ] ; do
		kh_eips_string="${kh_eips_string} "
	done

	# Sleep a tiny bit to workaround the logic in the 'new' (K4+) eInk controllers that tries to bundle updates,
	# otherwise it may drop part of our messages because of other screen updates from KUAL...
	usleep 150000	# 150ms

	# And finally, show our formatted 48 (or 46 on the PW) characters message on the bottom of the screen (NOTE: Redirect to /dev/null to kill unavailable character & pixel not in range warning messages)
	eips 10 $((${SCREEN_Y_RES} / ${EIPS_Y_RES} - 2 - ${kh_eips_y_shift_up})) "${kh_eips_string}" >/dev/null
}

# HERE INSTAFETCHER CODE DOES ACTUALLY BEGIN

# Clean the screen from previous runs
eips_print_bottom "" 4
eips_print_bottom "" 3
eips_print_bottom "" 2
eips_print_bottom "" 1

# Do some check to find whether wifi is ON or NOT...
toggled=0


check=$(lipc-get-prop com.lab126.cmd wirelessEnable)
# ... end automatically enable it if is OFF
if [ $check != 1 ]; then
eips_print_bottom "Wifi is OFF. Enabling..." 4
lipc-set-prop com.lab126.cmd wirelessEnable 1
toggled=1
sleep 15 # wait some time to let the kindle connect to the Wifi Network
fi


if [ ! -d "$outputdir" ]; then
    mkdir "$outputdir"
fi

cd $workdir

./curl -c $cookies -d "username=$username&password=${password}" http://www.instapaper.com/user/login > /dev/null 2>&1
if [ "$?" != 0 ]; then eips_print_bottom "Connection error." 3
	rm $cookies
	if [ $toggled -eq 1 ]; then
	lipc-set-prop com.lab126.cmd wirelessEnable 0
	eips_print_bottom "Wifi is now OFF again." 1
	fi
	return -1
fi
./curl -c $cookies http://www.instapaper.com/u > /dev/null 2>&1
if [ "$?" != 0 ]; then eips_print_bottom "Connection error." 3
	rm $cookies
	if [ $toggled -eq 1 ]; then
	lipc-set-prop com.lab126.cmd wirelessEnable 0
	eips_print_bottom "Wifi is now OFF again." 1
	fi
	return -2
fi
eips_print_bottom "Download in progress..." 3
./curl -b $cookies -o $outputdir/Instapaper-`date "+%Y%m%d%H%M"`.$format http://www.instapaper.com/$format$folder
if [ "$?" != 0 ]; then eips_print_bottom "Connection error." 3
	rm $cookies
	if [ $toggled -eq 1 ]; then
	lipc-set-prop com.lab126.cmd wirelessEnable 0
	eips_print_bottom "Wifi is now OFF again." 1
	fi
	return -3
fi
rm $cookies

eips_print_bottom "Download completed." 2

# If Wifi has been enable by instafetcher, it will be turned OFF again now
if [ $toggled -eq 1 ]; then
lipc-set-prop com.lab126.cmd wirelessEnable 0
eips_print_bottom "Wifi is now OFF again." 1
fi


return 0
