#!/bin/sh
sh /mnt/onboard/.kobo/kbmenu/onstart/setexitpng.sh
( usleep 400000; /etc/init.d/on-animator.sh ) &

(
	/usr/local/Kobo/pickel disable.rtc.alarm

	if [ ! -e /etc/wpa_supplicant/wpa_supplicant.conf ]; then
		cp /etc/wpa_supplicant/wpa_supplicant.conf.template /etc/wpa_supplicant/wpa_supplicant.conf
	fi

	echo 1 > /sys/devices/platform/mxc_dvfs_core.0/enable

	/sbin/hwclock -s -u
) &

INTERFACE=wlan0
WIFI_MODULE=ar6000
if [ $PLATFORM == ntx508 ]; then
	INTERFACE=eth0
	WIFI_MODULE=dhd
fi

export INTERFACE
export WIFI_MODULE

export QWS_MOUSE_PROTO="tslib_nocal:/dev/input/event1"
export QWS_KEYBOARD=imx508kbd:/dev/input/event0
# export QWS_DISPLAY=Transformed:imx508:Rot$mrotation
if [ "$mrotation" == "0" ] || [ "$mrotation" == "90" ] || [ "$mrotation" == "180" ] || [ "$mrotation" == "270" ]; then
   export QWS_DISPLAY=Transformed:imx508:Rot$mrotation
else
   export QWS_DISPLAY=Transformed:imx508:Rot90
fi


export NICKEL_HOME=/mnt/onboard/.kobo
export LD_LIBRARY_PATH=/usr/local/Kobo
export WIFI_MODULE_PATH=/drivers/$PLATFORM/wifi/$WIFI_MODULE.ko
export LANG=en_US.UTF-8
export UBOOT_MMC=/etc/u-boot/$PLATFORM/u-boot.mmc
export UBOOT_RECOVERY=/etc/u-boot/$PLATFORM/u-boot.recovery

/bin/dbus-uuidgen > /var/lib/dbus/machine-id
/bin/dbus-daemon --system &
export DBUS_SESSION_BUS_ADDRESS=`/bin/dbus-daemon --session --print-address --fork`

/usr/local/Kobo/hindenburg &
# [ $PLATFORM != freescale ] && rm -rf /dev/mmcblk1* && udevadm trigger &
/usr/local/Kobo/nickel -qws -skipFontLoad
