// Written by Silver18
// more info at: http://www.mobileread.com/forums/showpost.php?p=2121570&postcount=1


var windowing = new function() {
    var allCss = [];
    
    function snapshotCss(){
        jQuery.each(document.styleSheets, function(i, stylesheet) {
            var cssText = '';      
            jQuery.each(stylesheet.cssRules, function(j, rule) {
                cssText += rule.cssText;
            });
            allCss.push(cssText);
        });
    }

    this.copyAllCssToWindow = function(wnd) {        
        jQuery.each(allCss, function(i, cssText) {
            var newSheet = wnd.document.createElement('style');
            jQuery(newSheet).append(cssText);
            jQuery(wnd.document.head).append(newSheet);
        });

        // Different windows will have different ideas of the body size
        jQuery(wnd.document.body).css('width', 'auto');
        jQuery(wnd.document.body).css('height', 'auto');
    };    
    
    var currentDialog;    
    
    this.displayNodeInDialog = function(node){
	
	 snapshotCss();
	
        var dialogTemplate = $("<div class='overlay' />").html(node);

        jQuery(document.body).append(dialogTemplate);        
        var width = dialogTemplate.outerWidth(true);
        var height = dialogTemplate.outerHeight(true);
        dialogTemplate.detach();

        function fillDialog(dialog){  
            windowing.copyAllCssToWindow(dialog);
            /*jQuery(dialog.document.head).append('<link rel="stylesheet" type="text/css" href="/mnt/us/extensions/offlinepages/bin/resource/CSS/body.css">');
            jQuery(dialog.document.head).append('<link rel="stylesheet" type="text/css" href="/mnt/us/extensions/offlinepages/bin/resource/CSS/button.css">');
            jQuery(dialog.document.head).append('<link rel="stylesheet" type="text/css" href="/mnt/us/extensions/offlinepages/bin/resource/CSS/overlay.css">');*/
            jQuery(dialog.document.body).append(dialogTemplate);
            dialog.windowing = this;
        }

        this.displayDialog('about:blank', width, height, fillDialog);

    }

    this.displayDialog = function(htmlLocation, width, height, dialogCallback) {

         var dialog = kindle.chrome.createDialog(htmlLocation, width, height, true);
         if (!dialog) {
            myLogger.log( {
                event : 'dctpAdViwer:displayDialog',
                msg : 'Unable to create dialog window',
                level : 'error'
            });
            return;
        }

        this.closeDialog();
        currentDialog = dialog;
        jQuery(dialog).ready(dialogCallback(dialog));
    };
    
    this.displayDialogFromFactory = function(dialogKey, dialogParams){        
        var contentNode = dialogFactory.generateDialogContents(dialogKey, dialogParams);
        if (contentNode != null){
            windowing.displayNodeInDialog(contentNode);
        }
    };
    
    this.closeDialog = function() {
        if (currentDialog) {
            currentDialog.close();
            currentDialog = null;
        }
    };
  
};


