// Written by Silver18
// more info at: http://www.mobileread.com/forums/showpost.php?p=2121570&postcount=1


function KomicRefreshMenu() {    

	function setRefreshMenuItem(menuRoot, menuItemID, menuText, menuCallback) {
		var node = menuRoot.find("#" + menuItemID);
		if (!node) {
			return;
		}
		node.text(menuText);
		node.click(menuCallback);
	};

	function closeRefreshMenu() {
		setTimeout("windowing.closeDialog()",200);
	};    
		
	function createRefreshMenuNode() {

		var templateArgs = [ {
			titleText: KomicResources.strings.refreshmenu.title,            
		} ];

		var node = $( "#menuRefreshTemplate" ).tmpl(templateArgs);

		setRefreshMenuItem(node, "5pages", KomicResources.strings.refreshmenu.fivepages, function() {
			node.find("#5pages").addClass('xor'); 
			timer = setTimeout(function() { localStorage.setItem("refreshrate", "5") }, 300);
		});

		setRefreshMenuItem(node, "10pages", KomicResources.strings.refreshmenu.tenpages, function() {
			node.find("#10pages").addClass('xor');
			timer = setTimeout(function() { localStorage.setItem("refreshrate", "10") }, 300); 	
		});

		setRefreshMenuItem(node, "20pages", KomicResources.strings.refreshmenu.twentypages, function() {
			node.find("#20pages").addClass('xor'); 
			timer = setTimeout(function() { localStorage.setItem("refreshrate", "20") }, 300);

		});
		
		setRefreshMenuItem(node, "never", KomicResources.strings.refreshmenu.never, function() {
			node.find("#never").addClass('xor'); 
			timer = setTimeout(function() { localStorage.setItem("refreshrate", "never") }, 300);

		});

		setRefreshMenuItem(node, "custom", KomicResources.strings.refreshmenu.custom, function() {
			node.find("#custom").addClass('xor'); 
			timer = setTimeout(function() {
				var current = localStorage.getItem("refreshrate");
				if (current == "never") {
					current = KomicResources.strings.refreshmenu.never;
				}
				current = KomicResources.strings.refreshmenu.currentrate + current;

				if (orientation == "portrait") {

					$.alerts.verticalOffset = -120;

				} else if (orientation == "landscape") {
	
					$.alerts.verticalOffset = -950;

				}

				jPrompt(false, KomicResources.strings.refreshmenu.custommessage, current, KomicResources.strings.refreshmenu.refreshtitle, function(whichrate) {
					if (whichrate == "" || (isNaN(whichrate)) == true) {
						$.alerts.verticalOffset = -75;
						jAlert(KomicResources.strings.refreshmenu.chooserate, '');		
					} else if (whichrate == null) {	
						$.alerts.verticalOffset = -75;								
					} else if (whichrate != null && whichrate != "") {
						$.alerts.verticalOffset = -75;				
						localStorage.setItem("refreshrate", whichrate);				
					}
				});

			 }, 300);

		});

		node.find('.action').click(closeRefreshMenu);
		node.find("#refreshoptions").height(300);

		node.find('.close').click(function() {                                                 
			$(this).removeClass('close').addClass('closeXOR');                               
			closeRefreshMenu();                                                                   
		});  
		return node;
	};

	function getOrientation () {

		orientation = localStorage.getItem("orientation");

	}

	this.showRefreshMenu = function() {
		getOrientation ();
		windowing.displayNodeInDialog(createRefreshMenuNode());
	};
};
