// Written by Silver18
// more info at: http://www.mobileread.com/forums/showpost.php?p=2121570&postcount=1


function KomicColorMenu() {    

	function setColorMenuItem(menuRoot, menuItemID, menuText, menuCallback) {
		var node = menuRoot.find("#" + menuItemID);
		if (!node) {
			return;
		}
		node.text(menuText);
		node.click(menuCallback);
	};

	function closeColorMenu() {
		setTimeout("windowing.closeDialog()",200);
	};    
		
	function createColorMenuNode() {

		var templateArgs = [ {
			titleText: KomicResources.strings.colormenu.title,            
		} ];

		var node = $( "#menuColorTemplate" ).tmpl(templateArgs);

		setColorMenuItem(node, "white", KomicResources.strings.colormenu.white, function() {
			node.find("#white").addClass('xor'); 
			timer = setTimeout(function() { localStorage.setItem("backgroundcolor", "white") }, 300);
		});

		setColorMenuItem(node, "gray", KomicResources.strings.colormenu.gray, function() {
			node.find("#gray").addClass('xor');
			timer = setTimeout(function() { localStorage.setItem("backgroundcolor", "gray") }, 300); 	
		});

		setColorMenuItem(node, "black", KomicResources.strings.colormenu.black, function() {
			node.find("#black").addClass('xor'); 
			timer = setTimeout(function() { localStorage.setItem("backgroundcolor", "black") }, 300);

		});

		setColorMenuItem(node, "custom", KomicResources.strings.colormenu.custom, function() {
			node.find("#custom").addClass('xor'); 
			timer = setTimeout(function() {
				var current = localStorage.getItem("backgroundcolor");
				if (current == "white") {
					current = KomicResources.strings.colormenu.white;
				} else if (current == "gray") {
					current = KomicResources.strings.colormenu.gray;
				} else if (current == "black") {
					current = KomicResources.strings.colormenu.black;
				}
				current = KomicResources.strings.colormenu.currentcolor + current;

				if (orientation == "portrait") {

					$.alerts.verticalOffset = -120;

				} else if (orientation == "landscape") {
	
					$.alerts.verticalOffset = -950;

				}

				jPrompt(false, KomicResources.strings.colormenu.custommessage, current, KomicResources.strings.colormenu.colortitle, function(whichcolor) {
					if (whichcolor == "") {
						$.alerts.verticalOffset = -75;
						jAlert(KomicResources.strings.colormenu.choosecolor, '');		
					} else if (whichcolor == null) {	
						$.alerts.verticalOffset = -75;								
					} else if (whichcolor != null && whichcolor != "") {
						$.alerts.verticalOffset = -75;				
						localStorage.setItem("backgroundcolor", whichcolor);				
					}
				});

			 }, 300);

		});

		node.find('.action').click(closeColorMenu);
		node.find("#coloroptions").height(240);

		node.find('.close').click(function() {                                                 
			$(this).removeClass('close').addClass('closeXOR');                               
			closeColorMenu();                                                                   
		});  
		return node;
	};

	function getOrientation () {

		orientation = localStorage.getItem("orientation");

	}

	this.showColorMenu = function() {
		getOrientation ();
		windowing.displayNodeInDialog(createColorMenuNode());
	};
};
