#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

import sys, os, re
from uuid import uuid4

XML = """<?xml version="1.0" encoding="UTF-8"?>
<display_options>
    <platform name="*">
        <option name="specified-fonts">true</option>
    </platform>
</display_options>"""
   
def main(argv=sys.argv):
    if len(argv) != 2:
        print "Usage:"
        print "  aplle_xml.py infile"
        return 1
    else:  
        infile = argv[1]
        filepath = os.path.dirname(infile)
        found = False
        tmppath = filepath
        while found == False:
            print os.path.split(tmppath)[1]
            if os.path.split(tmppath)[1] == 'OEBPS':
                found = True
            else:
                tmppath = os.path.split(tmppath)[0]
    
    print os.path.join(os.path.split(tmppath)[0], 'META-INF')
    apple_xml_path = os.path.join(os.path.split(tmppath)[0], 'META-INF', 'com.apple.ibooks.display-options.xml')
    print apple_xml_path
    with open(apple_xml_path, 'wb') as f:
        f.write(XML.encode('utf-8'))
    os.utime(infile, None)

if __name__ == "__main__":
    sys.exit(main())
