/*
 * ScribbleMergeForm.java
 *
 * Created on 22 januari 2007, 23:09
 */

package iliadpdfscribblemerger;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author  Bert
 */
public class ScribbleMergeForm extends javax.swing.JFrame implements DropTargetListener {
    DropTarget dtSource, dtDest;
    String strColorMapPresets = "ColorMapPresets.xml";
    
    /** Creates new form ScribbleMergeForm */
    public ScribbleMergeForm(String strColorMapPresets) {
        this.strColorMapPresets = strColorMapPresets;
        initComponents();
        lblBusy.setVisible(false);
        
        // Load ColorMap presets
        if ( ColorMap.loadFromXml(strColorMapPresets, cmbPreset) != null ) {
            // Load colors
            cmbPresetActionPerformed(null);
        } else {
            // Clear selection
            lblDeletePresetMouseClicked(null);
        }
        
        
        // This class will handle drop events
        dtSource = new DropTarget(txtSource, this);
        dtDest = new DropTarget(txtDestination, this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        btgMergeType = new javax.swing.ButtonGroup();
        pnlSource = new javax.swing.JPanel();
        lblSource = new javax.swing.JLabel();
        txtSource = new javax.swing.JTextField();
        btnSource = new javax.swing.JButton();
        pnlMergeType = new javax.swing.JPanel();
        rbtMTReplaceAll = new javax.swing.JRadioButton();
        chkScribblesOnly = new javax.swing.JCheckBox();
        chkKeepManifest = new javax.swing.JCheckBox();
        rbtMTCreateNew = new javax.swing.JRadioButton();
        rbtMTExisting = new javax.swing.JRadioButton();
        pnlColorMapping = new javax.swing.JPanel();
        pnlFF = new javax.swing.JPanel();
        lblFF = new javax.swing.JLabel();
        pntMapFF = new javax.swing.JButton();
        pnlFF_new = new javax.swing.JPanel();
        lblFF_new = new javax.swing.JLabel();
        pblAA = new javax.swing.JPanel();
        lblAA = new javax.swing.JLabel();
        pntMapAA = new javax.swing.JButton();
        lblAA_new = new javax.swing.JLabel();
        pnlAA_new = new javax.swing.JPanel();
        pnl55 = new javax.swing.JPanel();
        lbl55 = new javax.swing.JLabel();
        pntMap55 = new javax.swing.JButton();
        lbl55_new = new javax.swing.JLabel();
        pnl55_new = new javax.swing.JPanel();
        pnl00 = new javax.swing.JPanel();
        lbl00 = new javax.swing.JLabel();
        pntMap00 = new javax.swing.JButton();
        pnl00_new = new javax.swing.JPanel();
        lbl00_new = new javax.swing.JLabel();
        lblBusy = new javax.swing.JLabel();
        cmbPreset = new javax.swing.JComboBox();
        cmbPreset.setModel( new DefaultComboBoxModel() {
            public void insertElementAt(Object element, int index) {
                int size = getSize();

                //  Determine where to insert element to keep list in sorted order
                for (index = 0; index < size; index++) {
                    Comparable c = (Comparable)getElementAt( index );
                    if (c.compareTo(element) > 0)
                    break;
                }

                super.insertElementAt(element, index);
            }
        });
        lblDeletePreset = new javax.swing.JLabel();
        lblAddPreset = new javax.swing.JLabel();
        lblSavePreset = new javax.swing.JLabel();
        pnlDestination = new javax.swing.JPanel();
        lblDestination = new javax.swing.JLabel();
        txtDestination = new javax.swing.JTextField();
        btnDestination = new javax.swing.JButton();
        chbOpenAfterMerge = new javax.swing.JCheckBox();
        btnExit = new javax.swing.JButton();
        btnMerge = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("iLiadPdfScribbleMerger");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        pnlSource.setBorder(javax.swing.BorderFactory.createTitledBorder("Source"));
        lblSource.setText("iRex pdf-directory:");

        txtSource.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtSourceActionPerformed(evt);
            }
        });

        btnSource.setText("Browse...");
        btnSource.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSourceActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout pnlSourceLayout = new org.jdesktop.layout.GroupLayout(pnlSource);
        pnlSource.setLayout(pnlSourceLayout);
        pnlSourceLayout.setHorizontalGroup(
            pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlSourceLayout.createSequentialGroup()
                .addContainerGap()
                .add(lblSource)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(txtSource, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 290, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(btnSource)
                .addContainerGap())
        );
        pnlSourceLayout.setVerticalGroup(
            pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(lblSource)
                .add(btnSource)
                .add(txtSource, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        pnlMergeType.setBorder(javax.swing.BorderFactory.createTitledBorder("Merge type"));
        btgMergeType.add(rbtMTReplaceAll);
        rbtMTReplaceAll.setText("Replace all (replace existing pdf-directory by merged pdf)");
        rbtMTReplaceAll.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        rbtMTReplaceAll.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rbtMTReplaceAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbtMTReplaceAllActionPerformed(evt);
            }
        });

        chkScribblesOnly.setText("Scribbled pages only (page number will be added)");
        chkScribblesOnly.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkScribblesOnly.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkScribblesOnly.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkScribblesOnlyActionPerformed(evt);
            }
        });

        chkKeepManifest.setText("Keep manifest");
        chkKeepManifest.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkKeepManifest.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkKeepManifest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkKeepManifestActionPerformed(evt);
            }
        });

        btgMergeType.add(rbtMTCreateNew);
        rbtMTCreateNew.setSelected(true);
        rbtMTCreateNew.setText("Create new (and keep original files intact)");
        rbtMTCreateNew.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        rbtMTCreateNew.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rbtMTCreateNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbtMTCreateNewActionPerformed(evt);
            }
        });

        btgMergeType.add(rbtMTExisting);
        rbtMTExisting.setText("Merge in existing file, keep manifest");
        rbtMTExisting.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        rbtMTExisting.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rbtMTExisting.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbtMTExistingActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout pnlMergeTypeLayout = new org.jdesktop.layout.GroupLayout(pnlMergeType);
        pnlMergeType.setLayout(pnlMergeTypeLayout);
        pnlMergeTypeLayout.setHorizontalGroup(
            pnlMergeTypeLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlMergeTypeLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlMergeTypeLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(rbtMTCreateNew)
                    .add(rbtMTExisting)
                    .add(rbtMTReplaceAll)
                    .add(pnlMergeTypeLayout.createSequentialGroup()
                        .add(17, 17, 17)
                        .add(pnlMergeTypeLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(chkKeepManifest)
                            .add(chkScribblesOnly))))
                .addContainerGap(187, Short.MAX_VALUE))
        );
        pnlMergeTypeLayout.setVerticalGroup(
            pnlMergeTypeLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlMergeTypeLayout.createSequentialGroup()
                .add(rbtMTCreateNew)
                .add(3, 3, 3)
                .add(chkScribblesOnly)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(chkKeepManifest)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(rbtMTExisting)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(rbtMTReplaceAll)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlColorMapping.setBorder(javax.swing.BorderFactory.createTitledBorder("Color mapping"));
        pnlFF.setBackground(new java.awt.Color(255, 255, 255));
        pnlFF.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pnlFFLayout = new org.jdesktop.layout.GroupLayout(pnlFF);
        pnlFF.setLayout(pnlFFLayout);
        pnlFFLayout.setHorizontalGroup(
            pnlFFLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pnlFFLayout.setVerticalGroup(
            pnlFFLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        lblFF.setText("#FFFFFF");

        pntMapFF.setText("->");
        pntMapFF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pntMapFFActionPerformed(evt);
            }
        });

        pnlFF_new.setBackground(new java.awt.Color(255, 255, 255));
        pnlFF_new.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pnlFF_newLayout = new org.jdesktop.layout.GroupLayout(pnlFF_new);
        pnlFF_new.setLayout(pnlFF_newLayout);
        pnlFF_newLayout.setHorizontalGroup(
            pnlFF_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pnlFF_newLayout.setVerticalGroup(
            pnlFF_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        lblFF_new.setText("#FFFFFF");

        pblAA.setBackground(new java.awt.Color(170, 170, 170));
        pblAA.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pblAALayout = new org.jdesktop.layout.GroupLayout(pblAA);
        pblAA.setLayout(pblAALayout);
        pblAALayout.setHorizontalGroup(
            pblAALayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pblAALayout.setVerticalGroup(
            pblAALayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        lblAA.setText("#AAAAAA");

        pntMapAA.setText("->");
        pntMapAA.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pntMapAAActionPerformed(evt);
            }
        });

        lblAA_new.setText("#AAAAAA");

        pnlAA_new.setBackground(new java.awt.Color(170, 170, 170));
        pnlAA_new.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pnlAA_newLayout = new org.jdesktop.layout.GroupLayout(pnlAA_new);
        pnlAA_new.setLayout(pnlAA_newLayout);
        pnlAA_newLayout.setHorizontalGroup(
            pnlAA_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pnlAA_newLayout.setVerticalGroup(
            pnlAA_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        pnl55.setBackground(new java.awt.Color(85, 85, 85));
        pnl55.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pnl55Layout = new org.jdesktop.layout.GroupLayout(pnl55);
        pnl55.setLayout(pnl55Layout);
        pnl55Layout.setHorizontalGroup(
            pnl55Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pnl55Layout.setVerticalGroup(
            pnl55Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        lbl55.setText("#555555");

        pntMap55.setText("->");
        pntMap55.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pntMap55ActionPerformed(evt);
            }
        });

        lbl55_new.setText("#555555");

        pnl55_new.setBackground(new java.awt.Color(85, 85, 85));
        pnl55_new.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pnl55_newLayout = new org.jdesktop.layout.GroupLayout(pnl55_new);
        pnl55_new.setLayout(pnl55_newLayout);
        pnl55_newLayout.setHorizontalGroup(
            pnl55_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pnl55_newLayout.setVerticalGroup(
            pnl55_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        pnl00.setBackground(new java.awt.Color(0, 0, 0));
        pnl00.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pnl00Layout = new org.jdesktop.layout.GroupLayout(pnl00);
        pnl00.setLayout(pnl00Layout);
        pnl00Layout.setHorizontalGroup(
            pnl00Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pnl00Layout.setVerticalGroup(
            pnl00Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        lbl00.setText("#000000");

        pntMap00.setText("->");
        pntMap00.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pntMap00ActionPerformed(evt);
            }
        });

        pnl00_new.setBackground(new java.awt.Color(0, 0, 0));
        pnl00_new.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        org.jdesktop.layout.GroupLayout pnl00_newLayout = new org.jdesktop.layout.GroupLayout(pnl00_new);
        pnl00_new.setLayout(pnl00_newLayout);
        pnl00_newLayout.setHorizontalGroup(
            pnl00_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 20, Short.MAX_VALUE)
        );
        pnl00_newLayout.setVerticalGroup(
            pnl00_newLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 23, Short.MAX_VALUE)
        );

        lbl00_new.setText("#000000");

        lblBusy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadpdfscribblemerger/res/disk.png")));
        lblBusy.setToolTipText("busy");

        cmbPreset.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbPresetActionPerformed(evt);
            }
        });

        lblDeletePreset.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadpdfscribblemerger/res/delete.png")));
        lblDeletePreset.setToolTipText("delete");
        lblDeletePreset.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblDeletePresetMouseClicked(evt);
            }
        });

        lblAddPreset.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadpdfscribblemerger/res/add.png")));
        lblAddPreset.setToolTipText("add new");
        lblAddPreset.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblAddPresetMouseClicked(evt);
            }
        });

        lblSavePreset.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadpdfscribblemerger/res/accept.png")));
        lblSavePreset.setToolTipText("save");
        lblSavePreset.setEnabled(false);
        lblSavePreset.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblSavePresetMouseClicked(evt);
            }
        });

        org.jdesktop.layout.GroupLayout pnlColorMappingLayout = new org.jdesktop.layout.GroupLayout(pnlColorMapping);
        pnlColorMapping.setLayout(pnlColorMappingLayout);
        pnlColorMappingLayout.setHorizontalGroup(
            pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlColorMappingLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(pnlColorMappingLayout.createSequentialGroup()
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pblAA, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lblAA))
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pnlFF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lblFF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 65, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pnl55, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lbl55))
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pnl00, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lbl00, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 44, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(23, 23, 23)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(pntMapFF)
                            .add(pntMapAA)
                            .add(pntMap55)
                            .add(pntMap00))
                        .add(48, 48, 48)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pnl00_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lbl00_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 44, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pnlFF_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lblFF_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 93, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pnl55_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lbl55_new))
                            .add(pnlColorMappingLayout.createSequentialGroup()
                                .add(pnlAA_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lblAA_new)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 15, Short.MAX_VALUE))
                    .add(lblBusy))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(cmbPreset, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 135, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(pnlColorMappingLayout.createSequentialGroup()
                        .add(lblSavePreset)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(lblAddPreset)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(lblDeletePreset))))
        );

        pnlColorMappingLayout.linkSize(new java.awt.Component[] {lbl00_new, lbl55_new, lblAA_new, lblFF_new}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        pnlColorMappingLayout.linkSize(new java.awt.Component[] {lbl00, lbl55, lblAA}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        pnlColorMappingLayout.setVerticalGroup(
            pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlColorMappingLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pnlColorMappingLayout.createSequentialGroup()
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(pnlFF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                                .add(pntMapFF)
                                .add(lblFF)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(pblAA, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(lblAA)
                            .add(pntMapAA))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(pnl55, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                                .add(lbl55)
                                .add(pntMap55)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, pnl00, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                                .add(lbl00)
                                .add(pntMap00))))
                    .add(pnlColorMappingLayout.createSequentialGroup()
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(pnlFF_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(lblFF_new))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(pnlAA_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(lblAA_new))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(lbl55_new)
                            .add(pnl55_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, pnl00_new, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, lbl00_new))))
                .addContainerGap(32, Short.MAX_VALUE))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, pnlColorMappingLayout.createSequentialGroup()
                .addContainerGap(117, Short.MAX_VALUE)
                .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblDeletePreset)
                    .add(lblAddPreset)
                    .add(lblSavePreset))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlColorMappingLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cmbPreset, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblBusy)))
        );

        pnlColorMappingLayout.linkSize(new java.awt.Component[] {lblFF, lblFF_new, pnlFF, pnlFF_new, pntMapFF}, org.jdesktop.layout.GroupLayout.VERTICAL);

        pnlColorMappingLayout.linkSize(new java.awt.Component[] {lbl55, lbl55_new, pnl55, pnl55_new, pntMap55}, org.jdesktop.layout.GroupLayout.VERTICAL);

        pnlColorMappingLayout.linkSize(new java.awt.Component[] {lblAA, lblAA_new, pblAA, pnlAA_new, pntMapAA}, org.jdesktop.layout.GroupLayout.VERTICAL);

        pnlColorMappingLayout.linkSize(new java.awt.Component[] {lbl00, lbl00_new, pnl00, pnl00_new, pntMap00}, org.jdesktop.layout.GroupLayout.VERTICAL);

        pnlDestination.setBorder(javax.swing.BorderFactory.createTitledBorder("Destination"));
        lblDestination.setText("Path:");

        txtDestination.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtDestinationActionPerformed(evt);
            }
        });

        btnDestination.setText("Browse...");
        btnDestination.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDestinationActionPerformed(evt);
            }
        });

        chbOpenAfterMerge.setText("Open file after merging");
        chbOpenAfterMerge.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chbOpenAfterMerge.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout pnlDestinationLayout = new org.jdesktop.layout.GroupLayout(pnlDestination);
        pnlDestination.setLayout(pnlDestinationLayout);
        pnlDestinationLayout.setHorizontalGroup(
            pnlDestinationLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlDestinationLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlDestinationLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pnlDestinationLayout.createSequentialGroup()
                        .add(lblDestination)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(txtDestination, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 355, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnDestination))
                    .add(chbOpenAfterMerge))
                .addContainerGap())
        );
        pnlDestinationLayout.setVerticalGroup(
            pnlDestinationLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlDestinationLayout.createSequentialGroup()
                .add(pnlDestinationLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblDestination)
                    .add(btnDestination)
                    .add(txtDestination, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(chbOpenAfterMerge)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        btnExit.setText("Exit");
        btnExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnExitActionPerformed(evt);
            }
        });

        btnMerge.setText("Merge");
        btnMerge.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnMergeActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, pnlColorMapping, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(pnlMergeType, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, pnlSource, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(374, 374, 374)
                        .add(btnMerge)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnExit))
                    .add(pnlDestination, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {btnExit, btnMerge}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(pnlSource, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlMergeType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlColorMapping, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlDestination, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 35, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(btnExit)
                    .add(btnMerge))
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        //save the default ColorMap
        String strCurrentItem = (String)cmbPreset.getSelectedItem();
        if (strCurrentItem != null && strCurrentItem != "")
            ColorMap.saveToXml(strColorMapPresets, strCurrentItem);
    }//GEN-LAST:event_formWindowClosing

    private void lblDeletePresetMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblDeletePresetMouseClicked
        if (!lblDeletePreset.isEnabled())
            return;
        
        showBusyIcon(500);
        String strSelectedItem = (String)cmbPreset.getSelectedItem();
        if (strSelectedItem != null && strSelectedItem != "") {
            ColorMap.setColorMap(strSelectedItem, null);
            ColorMap.saveToXml(strColorMapPresets, strSelectedItem);
            lblSavePreset.setEnabled(false);
            lblDeletePreset.setEnabled(false);
            cmbPreset.removeItem(strSelectedItem);
            cmbPreset.setSelectedIndex(-1);
        }
        
        //reset colors
        pnlFF_new.setBackground(new Color(255, 255, 255));
        lblFF_new.setText("#FFFFFF");
        pnlAA_new.setBackground(new Color(170, 170, 170));
        lblAA_new.setText("#AAAAAA");
        pnl55_new.setBackground(new Color(85, 85, 85));
        lbl55_new.setText("#555555");
        pnl00_new.setBackground(new Color(0, 0, 0));
        lbl00_new.setText("#000000");

        //disable icon
        lblDeletePreset.setEnabled(false);
    }//GEN-LAST:event_lblDeletePresetMouseClicked

    private void lblSavePresetMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblSavePresetMouseClicked
        if (!lblSavePreset.isEnabled())
            return;
        
        showBusyIcon(500);
        String strSelectedItem = (String)cmbPreset.getSelectedItem();
        if (strSelectedItem != null && strSelectedItem != "") {
            ColorMap.setColorMap(strSelectedItem, getNewColorMap());
            ColorMap.saveToXml(strColorMapPresets, strSelectedItem);
            lblSavePreset.setEnabled(false);
        }
        //showBusyIcon(0, false);
    }//GEN-LAST:event_lblSavePresetMouseClicked

    private void cmbPresetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbPresetActionPerformed
        String strSelectedItem = (String)cmbPreset.getSelectedItem();
        ColorMap cmNew = ColorMap.getColorMap(strSelectedItem);
        if (cmNew == null)
            return;
        
        lblSavePreset.setEnabled(false);
        lblDeletePreset.setEnabled(true);
        
        Color c = null;
        c = (Color)cmNew.get("#FFFFFF");
        if (c != null) {
            pnlFF_new.setBackground(c);
            lblFF_new.setText(ColorMap.ColorToString(c));
        }
        c = (Color)cmNew.get("#AAAAAA");
        if (c != null) {
            pnlAA_new.setBackground(c);
            lblAA_new.setText(ColorMap.ColorToString(c));
        }
        c = (Color)cmNew.get("#555555");
        if (c != null) {
            pnl55_new.setBackground(c);
            lbl55_new.setText(ColorMap.ColorToString(c));
        }
        c = (Color)cmNew.get("#000000");
        if (c != null) {
            pnl00_new.setBackground(c);
            lbl00_new.setText(ColorMap.ColorToString(c));
        }
    }//GEN-LAST:event_cmbPresetActionPerformed

    private void lblAddPresetMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblAddPresetMouseClicked
        showBusyIcon(500);
        String strNewName = JOptionPane.showInputDialog(this, "Enter the name for the new color map:", "New color map", JOptionPane.PLAIN_MESSAGE);
        if (strNewName != null && strNewName != "") {
            ColorMap.setColorMap(strNewName, getNewColorMap());
            ColorMap.saveToXml(strColorMapPresets, strNewName);
            lblSavePreset.setEnabled(false);
            cmbPreset.insertItemAt(strNewName, 0);
            cmbPreset.setSelectedItem(strNewName);
        }
    }//GEN-LAST:event_lblAddPresetMouseClicked

    private void txtDestinationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtDestinationActionPerformed
        setDestination(txtDestination.getText());
    }//GEN-LAST:event_txtDestinationActionPerformed

    private void txtSourceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtSourceActionPerformed
        setSource(txtSource.getText());
    }//GEN-LAST:event_txtSourceActionPerformed
    
    private void chkKeepManifestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkKeepManifestActionPerformed
        chkScribblesOnly.setEnabled(!chkKeepManifest.isSelected());
        chkKeepManifest.setEnabled(!chkScribblesOnly.isSelected());
    }//GEN-LAST:event_chkKeepManifestActionPerformed
    
    private void chkScribblesOnlyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkScribblesOnlyActionPerformed
        chkScribblesOnly.setEnabled(!chkKeepManifest.isSelected());
        chkKeepManifest.setEnabled(!chkScribblesOnly.isSelected());
    }//GEN-LAST:event_chkScribblesOnlyActionPerformed
        
    private void pntMap00ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pntMap00ActionPerformed
        Color c = JColorChooser.showDialog(this, "#000000 color mapping", pnl00_new.getBackground());
        if ( c != null ) {
            pnl00_new.setBackground(c);
            lbl00_new.setText(ColorMap.ColorToString(c));
            lblSavePreset.setEnabled(cmbPreset.getSelectedIndex()>=0);
        }
    }//GEN-LAST:event_pntMap00ActionPerformed
    
    private void pntMap55ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pntMap55ActionPerformed
        Color c = JColorChooser.showDialog(this, "#555555 color mapping", pnl55_new.getBackground());
        if ( c != null ) {
            pnl55_new.setBackground(c);
            lbl55_new.setText(ColorMap.ColorToString(c));
            lblSavePreset.setEnabled(cmbPreset.getSelectedIndex()>=0);
        }
    }//GEN-LAST:event_pntMap55ActionPerformed
    
    private void pntMapAAActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pntMapAAActionPerformed
        Color c = JColorChooser.showDialog(this, "#AAAAAA color mapping", pnlAA_new.getBackground());
        if ( c != null ) {
            pnlAA_new.setBackground(c);
            lblAA_new.setText(ColorMap.ColorToString(c));
            lblSavePreset.setEnabled(cmbPreset.getSelectedIndex()>=0);
        }
    }//GEN-LAST:event_pntMapAAActionPerformed
    
    private void pntMapFFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pntMapFFActionPerformed
        Color c = JColorChooser.showDialog(this, "#FFFFFF color mapping", pnlFF_new.getBackground());
        if ( c != null ) {
            pnlFF_new.setBackground(c);
            lblFF_new.setText(ColorMap.ColorToString(c));
            lblSavePreset.setEnabled(cmbPreset.getSelectedIndex()>=0);
        }
    }//GEN-LAST:event_pntMapFFActionPerformed
    
    private void btnExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnExitActionPerformed
        //post a WINDOW_CLOSING msg to simulate click on 'close' button (in the title bar)
        Toolkit t = Toolkit.getDefaultToolkit();
        EventQueue eq = t.getSystemEventQueue();
        eq.postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }//GEN-LAST:event_btnExitActionPerformed
    
    private void btnMergeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnMergeActionPerformed
        //input path
        String strInputPath = txtSource.getText();
        //output path
        String strOutputPath = txtDestination.getText();
        //merge type
        char cMergeType = 'n';
        if (rbtMTCreateNew.isSelected()) {
            if (chkKeepManifest.isSelected())
                cMergeType = 'm';
            else
                cMergeType = chkScribblesOnly.isSelected() ? 's' : 'n';
        } else if (rbtMTExisting.isSelected()) {
            cMergeType = 'e';
        } else if (rbtMTReplaceAll.isSelected()) {
            cMergeType = 'r';
        }
        
        //merge!
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        ScribbleMerger.Merge(strInputPath, strOutputPath, cMergeType, getNewColorMap());
        setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        
        //open file
        try {
            if (chbOpenAfterMerge.isSelected()) {
                if (OsVersion.IS_WINDOWS) {
                    Runtime.getRuntime().exec("cmd /c \"" + strOutputPath + "\"");
                } else if (OsVersion.IS_UNIX) {
                    Runtime.getRuntime().exec("df -Pk " + strOutputPath);
                } else if (OsVersion.IS_HPUX) {
                    Runtime.getRuntime().exec("bdf " + strOutputPath);
                } else if (OsVersion.IS_SUNOS) {
                    Runtime.getRuntime().exec("df -k" + strOutputPath);
                }
            }
        }
        catch (IOException ioe) {
            JOptionPane.showConfirmDialog(this, "Error while opening merged file.\nError: " + ioe.getMessage(), "Error", JOptionPane.DEFAULT_OPTION, JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_btnMergeActionPerformed
    
    protected void showBusyIcon(int nTime_ms) {
        lblBusy.setVisible(true);
        //start a timer to hide the icon again
        javax.swing.Timer timer = new javax.swing.Timer(nTime_ms, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                lblBusy.setVisible(false);
            }
        });
        timer.start();
    }
    
    protected ColorMap getNewColorMap() {
        ColorMap mapColors = new ColorMap();
        mapColors.put("#000000", pnl00_new.getBackground());
        mapColors.put("#555555", pnl55_new.getBackground());
        mapColors.put("#AAAAAA", pnlAA_new.getBackground());
        mapColors.put("#FFFFFF", pnlFF_new.getBackground());
        
        return mapColors;
    }
    
    private void btnDestinationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDestinationActionPerformed
        //get the currently entered path
        File fileOutput = new File(txtDestination.getText());
        //show the file chooser
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fc.setSelectedFile(fileOutput);
        FileFilter ff = new FileFilter() {
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".pdf");
            }
            
            public String getDescription() {
                return "pdf directories";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showSaveDialog(this);
        if (nReturnValue==fc.APPROVE_OPTION) {
            setDestination(fc.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_btnDestinationActionPerformed
    
    private void rbtMTReplaceAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbtMTReplaceAllActionPerformed
        chkScribblesOnly.setEnabled(false);
        chkKeepManifest.setEnabled(false);
        lblDestination.setEnabled(false);
        txtDestination.setEnabled(false);
        btnDestination.setEnabled(false);
        
        FixDestination();
    }//GEN-LAST:event_rbtMTReplaceAllActionPerformed
    
    private void rbtMTExistingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbtMTExistingActionPerformed
        chkScribblesOnly.setEnabled(false);
        chkKeepManifest.setEnabled(false);
        lblDestination.setEnabled(false);
        txtDestination.setEnabled(false);
        btnDestination.setEnabled(false);
        
        FixDestination();
    }//GEN-LAST:event_rbtMTExistingActionPerformed
    
    private void rbtMTCreateNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbtMTCreateNewActionPerformed
        chkScribblesOnly.setEnabled(!chkKeepManifest.isSelected());
        chkKeepManifest.setEnabled(!chkScribblesOnly.isSelected());
        lblDestination.setEnabled(true);
        txtDestination.setEnabled(true);
        btnDestination.setEnabled(true);
        
        FixDestination();
    }//GEN-LAST:event_rbtMTCreateNewActionPerformed
    
    private void FixDestination(){
        if (rbtMTCreateNew.isSelected()) {
            //clear destination if it's the source dir or the source pdf
            File fileInput = new File(txtSource.getText());
            if (fileInput != null && fileInput.isDirectory()) {
                String strSourceDir = fileInput.getAbsolutePath();
                String strSourcePDF = fileInput.getAbsolutePath() + File.separator + fileInput.getName();
                
                String strDestination = txtDestination.getText();
                if (strDestination.equals(strSourceDir) || strDestination.equals(strSourcePDF))
                    txtDestination.setText("");
            }
        } else if (rbtMTExisting.isSelected()) {
            //set destination to sourcedir\pdf-file
            File fileInput = new File(txtSource.getText());
            if (fileInput != null && fileInput.isDirectory()) {
                setDestination(fileInput.getAbsolutePath() + File.separator + fileInput.getName());
            }
        } else if (rbtMTReplaceAll.isSelected()) {
            //set destination to sourcedir (but now it's a file rather than a dir)
            File fileInput = new File(txtSource.getText());
            if (fileInput != null && fileInput.isDirectory()) {
                txtDestination.setText(fileInput.getAbsolutePath());
            }
        }
    }
    
    private void btnSourceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSourceActionPerformed
        //get the currently entered path
        File fileInput = new File(txtSource.getText());
        //show the file chooser
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fc.setSelectedFile(fileInput);
        FileFilter ff = new FileFilter() {
            public boolean accept(File f) {
                return f.isDirectory();
            }
            
            public String getDescription() {
                return "iRex pdf directories";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showOpenDialog(this);
        if (nReturnValue==fc.APPROVE_OPTION) {
            setSource(fc.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_btnSourceActionPerformed
    
    public void dragEnter(DropTargetDragEvent dtde) {
        //do nothing
    }

    public void dragOver(DropTargetDragEvent dtde) {
        //do nothing
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        //do nothing
    }

    public void dragExit(DropTargetEvent dte) {
        //do nothing
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            //Get the dropped object and try to figure out what it is
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                // Accept copy drops...
                dtde.acceptDrop(DnDConstants.ACTION_COPY);

                // And use the first file in the list
                File file = (File) ((List)tr.getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                if (file != null) {
                    if (dtde.getSource()==dtSource)
                        setSource( file.getAbsolutePath() );
                    else
                        setDestination( file.getAbsolutePath() );
                }

                // If we made it this far, everything worked.
                dtde.dropComplete(true);
                return;
            } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                // Accept copy drops...
                dtde.acceptDrop(DnDConstants.ACTION_COPY);

                // use the ull string
                String str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                if (str != null) {
                    if (dtde.getSource()==dtSource)
                        setSource( str );
                    else
                        setDestination( str );
                }

                // If we made it this far, everything worked.
                dtde.dropComplete(true);
                return;
            }
            
            // The user must not have dropped a file list or string
            dtde.rejectDrop();
        } catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }
    
    private boolean setSource(String strSource) {
        File fileSource = new File(strSource);

        //clear the text
        txtSource.setText("");

        //check if it's a valid directory
        if (!fileSource.exists() || !fileSource.isDirectory()) 
            return false;

        //check if there is a manifest.xml and scribble.irx in the directory
        if (new File(fileSource.getAbsoluteFile() + File.separator + "manifest.xml").exists() &&
            new File(fileSource.getAbsoluteFile() + File.separator + "scribble.irx").exists()) {
            txtSource.setText(fileSource.getAbsolutePath());
            //set the destination to the parent directory if there's no destination present yet
            if (txtDestination.getText()==null || txtDestination.getText().length()==0) {
                setDestination(fileSource.getParent() + File.separator);
            }
            
            FixDestination();
            
            return true;
        }
        
        return false;
    }
    
    private void setDestination(String strDest) {
        //get 'clean' filename
        File fileDest = new File(strDest);
        String strDestination = fileDest.getAbsolutePath();
        
        //make sure we have a file (not a dir)
        //note: we check the original string because the clean name will have the separator removed
        if (strDest.endsWith(File.separator)) {
            strDestination = strDestination + File.separator + "output.pdf";
        }
        
        //make sure there's a '.pdf' at the end
        if (!strDestination.toLowerCase().endsWith(".pdf"))
            strDestination = strDestination + ".pdf";
            
        txtDestination.setText( strDestination );
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup btgMergeType;
    private javax.swing.JButton btnDestination;
    private javax.swing.JButton btnExit;
    private javax.swing.JButton btnMerge;
    private javax.swing.JButton btnSource;
    private javax.swing.JCheckBox chbOpenAfterMerge;
    private javax.swing.JCheckBox chkKeepManifest;
    private javax.swing.JCheckBox chkScribblesOnly;
    private javax.swing.JComboBox cmbPreset;
    private javax.swing.JLabel lbl00;
    private javax.swing.JLabel lbl00_new;
    private javax.swing.JLabel lbl55;
    private javax.swing.JLabel lbl55_new;
    private javax.swing.JLabel lblAA;
    private javax.swing.JLabel lblAA_new;
    private javax.swing.JLabel lblAddPreset;
    private javax.swing.JLabel lblBusy;
    private javax.swing.JLabel lblDeletePreset;
    private javax.swing.JLabel lblDestination;
    private javax.swing.JLabel lblFF;
    private javax.swing.JLabel lblFF_new;
    private javax.swing.JLabel lblSavePreset;
    private javax.swing.JLabel lblSource;
    private javax.swing.JPanel pblAA;
    private javax.swing.JPanel pnl00;
    private javax.swing.JPanel pnl00_new;
    private javax.swing.JPanel pnl55;
    private javax.swing.JPanel pnl55_new;
    private javax.swing.JPanel pnlAA_new;
    private javax.swing.JPanel pnlColorMapping;
    private javax.swing.JPanel pnlDestination;
    private javax.swing.JPanel pnlFF;
    private javax.swing.JPanel pnlFF_new;
    private javax.swing.JPanel pnlMergeType;
    private javax.swing.JPanel pnlSource;
    private javax.swing.JButton pntMap00;
    private javax.swing.JButton pntMap55;
    private javax.swing.JButton pntMapAA;
    private javax.swing.JButton pntMapFF;
    private javax.swing.JRadioButton rbtMTCreateNew;
    private javax.swing.JRadioButton rbtMTExisting;
    private javax.swing.JRadioButton rbtMTReplaceAll;
    private javax.swing.JTextField txtDestination;
    private javax.swing.JTextField txtSource;
    // End of variables declaration//GEN-END:variables
    
}
