/*
 * Main.java
 *
 * Created on 13 januari 2007, 23:49
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package iliadpdfscribblemerger;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/**
 *
 * @author Bert
 */
public class Main {
    
    /** Creates a new instance of Main */
    public Main() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
//        //find path to config file
//        System.out.println(ScribbleMergeForm.class.getProtectionDomain().getCodeSource().getLocation().toString());
//        System.out.println(ScribbleMergeForm.class.getProtectionDomain().getCodeSource().getLocation().getPath());
//        File fileJar = new File(ScribbleMergeForm.class.getProtectionDomain().getCodeSource().getLocation().getPath());
//        String strColorMapsXmlPath = fileJar.getParentFile().getAbsolutePath() + File.separator + "ColorMapPresets.xml";
//        strColorMapsXmlPath = strColorMapsXmlPath.replace("%20", " "); //this is a URL - spaces are replaced by %20
        String strColorMapsXmlPath = "ColorMapPresets.xml";

        //no arguments: show GUI
        if (args.length == 0) {
            //set general look and feel
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } catch (ClassNotFoundException cnfe) {
            } catch (InstantiationException ie) {
            } catch (IllegalAccessException iae) {
            } catch (UnsupportedLookAndFeelException usfe) {
            }

            //create wizard form
            ScribbleMergeForm dlg = new ScribbleMergeForm(strColorMapsXmlPath);
            //center on screen
            dlg.setLocationRelativeTo(null);
            //set correct UI
            SwingUtilities.updateComponentTreeUI(dlg);
            //show it
            dlg.setVisible(true);
        }
        //arguments: no GUI
        else {
            //show help if needed
            ArrayList saArgs = new ArrayList(Arrays.asList(args));
            if (saArgs.contains("-?") || saArgs.contains("/?")) {
                System.out.println("This utility allows merging from iLiad iRex scribbles \nwith the oringinal pdf file");
                System.out.println();
                System.out.println("Possible arguments:");
                System.out.println("-i:<path>        ->  iRex-pdf input folder");
                System.out.println("-o:<path>        ->  pdf output (ignored in some cases)");
                System.out.println("-m:<merge-type>  ->  merge type (see below for details)");
                System.out.println("-cm:<name>       ->  use a saved color map (needs the ColorMapPresets.xml file in the current directory)");
                System.out.println("-c<index>:<color>->  color mapping (see below for details)");
                System.out.println("-?               ->  this help");
                System.out.println("notes: - if <path> contains spaces, it must be enclosed in double quotes");
                System.out.println("       - output path must be different from input path");
                System.out.println();
                System.out.println("possible merge types:");
                System.out.println("n  ->  new iRex pdf folder, manifest will be omitted (output path required)");
                System.out.println("m  ->  new iRex pdf folder, manifest will be kept (output path required)");
                System.out.println("s  ->  scribble only (output path required)");
                System.out.println("e  ->  existing pdf will be replaced");
                System.out.println("r  ->  replace all (iRex folder will be replaced by pdf file)");
                System.out.println();
                System.out.println("possible (scribble) colors to map:");
                System.out.println("c1  ->  #000000 = black");
                System.out.println("c2  ->  #555555 = dark grey");
                System.out.println("c3  ->  #AAAAAA = light grey");
                System.out.println("c4  ->  #FFFFFF = white");
                System.out.println("the <color> in the color mapping must be of the form #hhhhhh (h = hex number)");
                System.out.println("note: these colors override the color map defined by the -cm swich");
                return;
            }
            
            //process arguments
            String strInputPath = "";
            String strOutputPath = "";
            String strColor1 = null;
            String strColor2 = null;
            String strColor3 = null;
            String strColor4 = null;
            String strColorMapName = null;
            char cMergeType = 'n';
            for (int nArg=0; nArg<saArgs.size(); nArg++) {
                if (args[nArg].startsWith("-i:") || args[nArg].startsWith("/i:")) {
                    strInputPath = args[nArg].substring(3);
                } else if (args[nArg].startsWith("-o:") || args[nArg].startsWith("/o:")) {
                    strOutputPath = args[nArg].substring(3);
                } else if (args[nArg].startsWith("-cm:") || args[nArg].startsWith("/cm:")) {
                    strColorMapName = args[nArg].substring(4);
                } else if (args[nArg].startsWith("-c1:") || args[nArg].startsWith("/c1:")) {
                    strColor1 = args[nArg].substring(4);
                } else if (args[nArg].startsWith("-c2:") || args[nArg].startsWith("/c2:")) {
                    strColor2 = args[nArg].substring(4);
                } else if (args[nArg].startsWith("-c3:") || args[nArg].startsWith("/c3:")) {
                    strColor3 = args[nArg].substring(4);
                } else if (args[nArg].startsWith("-c4:") || args[nArg].startsWith("/c4:")) {
                    strColor4 = args[nArg].substring(4);
                } else if (args[nArg].startsWith("-m:") || args[nArg].startsWith("/m:")) {
                    if (args[nArg].length()>=4)
                        cMergeType = args[nArg].charAt(3);
                }
            }
            
            
            //create color map
            ColorMap mapColors = null;
            
            // try to load the color map
            String strDefaultColorMap = ColorMap.loadFromXml(strColorMapsXmlPath, null);
            if (strColorMapName == null || strColorMapName == "")
                mapColors = ColorMap.getColorMap(strDefaultColorMap);
            else
                mapColors = ColorMap.getColorMap(strColorMapName);
            
            // check if we have a color map
            if (mapColors == null) {
                if (strColorMapName != null) {
                    // show error & exit if the explicit color map doesn't exist
                    System.err.println("Invalid color map: " + strColorMapName);
                    return;
                } else {
                    // create color map
                    mapColors = new ColorMap();
                }
            }
            
            // add overriding colors
            try {
                if (strColor1 != null && strColor1 != "")
                    mapColors.put("#000000", Color.decode(strColor1));
                if (strColor2 != null && strColor2 != "")
                    mapColors.put("#555555", Color.decode(strColor2));
                if (strColor3 != null && strColor3 != "")
                    mapColors.put("#AAAAAA", Color.decode(strColor3));
                if (strColor4 != null && strColor4 != "")
                    mapColors.put("#FFFFFF", Color.decode(strColor4));
            } catch (NumberFormatException nfe) {
                System.err.println("Invalid color: " + nfe.getMessage());
                return;
            }
                
            //merge!
            ScribbleMerger.Merge(strInputPath, strOutputPath, cMergeType, mapColors);
        }
    }
    
}
