/*
 * Decompiled with CFR 0.152.
 */
package iliadpdfscribblemerger;

import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.util.HashMap;
import org.w3c.dom.Element;

public class ScribbleStroke {
    public static final float SCALE_FACTOR = 35.0f;
    public static final float PEN_SCALE_FACTOR = 0.02f;
    String strColor;
    int nLayer;
    int nPenSize;
    String strLineStyle;
    float fZoom;
    int[][] nStrokes;

    public ScribbleStroke(Element elStroke) {
        this.strColor = elStroke.getAttribute("color");
        this.nLayer = Integer.parseInt(elStroke.getAttribute("layer"));
        this.nPenSize = Integer.parseInt(elStroke.getAttribute("penSize"));
        this.strLineStyle = elStroke.getAttribute("linestyle");
        this.fZoom = Float.parseFloat(elStroke.getAttribute("zoom"));
        String strValue = elStroke.getChildNodes().item(0).getNodeValue();
        String[] strStrokeLines = strValue.split("\n");
        this.nStrokes = new int[strStrokeLines.length][3];
        for (int nStrokeLine = 0; nStrokeLine < strStrokeLines.length; ++nStrokeLine) {
            String[] strStrokeData = strStrokeLines[nStrokeLine].split(" ");
            if (strStrokeData.length != 3) continue;
            this.nStrokes[nStrokeLine][0] = Integer.parseInt(strStrokeData[0]);
            this.nStrokes[nStrokeLine][1] = Integer.parseInt(strStrokeData[1]);
            this.nStrokes[nStrokeLine][2] = Integer.parseInt(strStrokeData[2]);
        }
    }

    void DrawStroke(PdfContentByte cb, int nOrientation, float fTop, float fLeft, HashMap mapColors) {
        if (this.nStrokes.length < 2) {
            return;
        }
        Color colStroke = null;
        colStroke = mapColors == null || !mapColors.containsKey(this.strColor) ? Color.decode(this.strColor) : (Color)mapColors.get(this.strColor);
        cb.setColorStroke(colStroke);
        float fScaleFactor = this.fZoom / 100.0f;
        cb.setLineWidth((float)this.nPenSize / fScaleFactor);
        float x = fLeft + (float)this.nStrokes[0][0] / fScaleFactor;
        float y = fTop - (float)this.nStrokes[0][1] / fScaleFactor;
        cb.moveTo(x, y);
        for (int nStrokeLine = 1; nStrokeLine < this.nStrokes.length; ++nStrokeLine) {
            x = fLeft + (float)this.nStrokes[nStrokeLine][0] / fScaleFactor;
            y = fTop - (float)this.nStrokes[nStrokeLine][1] / fScaleFactor;
            cb.lineTo(x, y);
        }
        cb.stroke();
    }
}

