#!/bin/bash
hostlist="alpha.php"
checksumefilename="liste1.txt"
createhostlist=true
hostdir="liste"
pathtoop="/var/www/"
pathtorec="/home/"$(whoami)"/Desktop/recipes/"
timelogging=true
pathtotimelog=$pathtorec
timelogfile="log.txt"
# If you $pathtorec folder contains file-1.recipe ... file-n.recipe, enter "file-1 ... file-n" into LINE; NOTE: "..." etc. is not supported and only used for illustration
LINE="example1 example2"
IFACE='eth0'
outputformat=mobi
mkdir -p $pathtoop$hostdir
cd $pathtoop$hostdir
rm -f $pathtorec$timelogfile
if $timelogging ; then
	totalcompute=$(date +%s)
fi
for L in $LINE; do
	rm -f $pathtoop$hostdir"/"$L.$outputformat
	if $timelogging ; then
		START=$(date +%s)
	fi
	ebook-convert $pathtorec$L.recipe $pathtoop$hostdir"/"$L.$outputformat
	if $timelogging ; then
		END=$(date +%s)
		DIFF=$(( $END - $START ))
		echo "$DIFF seconds for $L.$outputformat" >> $pathtotimelog$timelogfile
	fi
	# echo "http://"$(ip -4 address show $IFACE | grep 'inet' | sed 's/.*inet \([0-9\.]\+\).*/\1/')"/"$hostdir"/"$L".mobi">> $pathtoop$hostdir"/"$hostlist
done
if $timelogging ; then
	END=$(date +%s)
	DIFF=$(( $END - $totalcompute ))
	echo "$DIFF seconds in total" >> $pathtotimelog$timelogfile
fi
if $createhostlist; then
printf '<?php\n$checksumefile="' >$pathtoop$hostdir"/"$hostlist
echo -n $checksumefilename >> $pathtoop$hostdir"/"$hostlist
printf '";\n$var = getcwd();\n$var = explode("/", $var);\n$var = end($var);\n$currentfile = basename($_SERVER["SCRIPT_FILENAME"]);\nif (isset($_FILES["upload"]["name"])) {\n\t$uploadfile = basename($_FILES["upload"]["name"]);\n\tif (move_uploaded_file($_FILES["upload"]["tmp_name"], $uploadfile)) {\n\t\techo "File is valid, and was successfully uploaded.\\n";\n\t}\n\telse {\n\t\techo "Upload failed";\n\t}\n}\nelse {\n\tif ($handle = opendir(".")) { \n\t\twhile (false !== ($file = readdir($handle))) { \n\t\t\tif ($file != "." && $file != ".." && $file != $currentfile && $file != ".htaaccess") {\n\t\t\t\t$file1 = "./".$checksumefile;\n\t\t\t\t$lines = file("".$file1);\n\t\t\t\tclearstatcache();\n\t\t\t\t$transmit = true;\n\t\t\t\tforeach($lines as $line_num => $line)\n\t\t\t\t\t{\n\t\t\t\t\t$line = trim ($line);\n\t\t\t\t\t$dateiname = trim(substr($line, 34));\n\t\t\t\t\tif ($file == $dateiname){\n\t\t\t\t\t\t$rest =  trim(substr($line, 0,33));\n\t\t\t\t\t\t$filename = trim("".$dateiname);\n\t\t\t\t\t\tif(file_exists($filename)){\n\t\t\t\t\t\t\tif (md5_file($filename) !== $rest){\n\t\t\t\t\t\t\t#\told and new hash are different\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {$transmit = false;}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n   \t\t\t\tif ($transmit && $file != $checksumefile){ echo "http://";echo $_SERVER["SERVER_ADDR"];echo "/".$var."/"; echo $file."\\n";}\n\t\t\t}\n\t\t}\n    \t\tclosedir();\n\t}\n\n}\n?>' >>$pathtoop$hostdir"/"$hostlist
fi
chmod 777 -R $pathtoop$hostdir
sleep 10
# read -p "Press enter to continue"
