/*
 * Decompiled with CFR 0.152.
 */
package com.mobileread.ixtab.patch.coverview;

import com.amazon.kindle.content.catalog.MutableItem;
import com.amazon.kindle.home.HomeBooklet;
import com.mobileread.ixtab.jbpatch.Environment;
import com.mobileread.ixtab.jbpatch.Patch;
import com.mobileread.ixtab.jbpatch.PatchMetadata;
import com.mobileread.ixtab.jbpatch.conf.ConfigurableSetting;
import com.mobileread.ixtab.jbpatch.conf.ConfigurableSettings;
import com.mobileread.ixtab.jbpatch.conf.ui.RadioButtonsSettingPanel;
import com.mobileread.ixtab.jbpatch.conf.ui.SettingChangeListener;
import com.mobileread.ixtab.jbpatch.conf.ui.SettingEntry;
import com.mobileread.ixtab.jbpatch.conf.ui.SettingPanel;
import java.security.AllPermission;
import java.security.Permission;
import java.util.Map;
import serp.bytecode.BCClass;
import serp.bytecode.Code;
import serp.bytecode.ConstantInstruction;

public class CoverViewPatch
extends Patch {
    private static final String CLASS_U = "com.amazon.kindle.home.view.browse.u";
    public static final String MD5_U_BEFORE = "7514fc95c491b7688ab7ead1c5786fdd";
    private static final String MD5_U_AFTER = "0600f28d4d862dd78bb22d84c31c6240";
    private static final String CLASS_J = "com.amazon.kindle.home.view.c.j";
    public static final String MD5_J_BEFORE = "d19abbac19cd0c6afd26320594b70e75";
    private static final String MD5_J_AFTER = "655d426e27352326c8fcda6d03889314";
    private static final String CLASS_HOMEBOOKLET = "com.amazon.kindle.home.HomeBooklet";
    public static final String MD5_HOMEBOOKLET_BEFORE = "83836d8792099cdf7c2dac9866ae845d";
    private static final String MD5_HOMEBOOKLET_AFTER = "5fbb7d25312338f5d931cd102dd8f366";
    private static final String CLASS_MOBI7EXTRACTOR = "com.amazon.kindle.extractor.mobi.Mobi7Extractor";
    public static final String MD5_MOBI7EXTRACTOR_BEFORE = "55caf19a2d1bd8accd0daa6a01813317";
    private static final String MD5_MOBI7EXTRACTOR_AFTER = "5d9fcabf3ec2becd4e82a2bca3671013";
    private static final String COVER_VIEW_MODE = "COVER_VIEW_MODE";
    private static final String LIST_VIEW_MODE = "LIST_VIEW_MODE";
    private static final String CONF_KEY = "mode";
    private static final String UI_NAME = "name";
    private static final String UI_DESC = "description";
    private static final String UI_HINT = "hint";
    private static final String UI_MODE_LIST = "list";
    private static final String UI_MODE_COVER = "cover";
    private static CoverViewPatch instance = null;
    private static String currentViewMode = null;

    public int getVersion() {
        return 20130413;
    }

    public boolean isAvailable() {
        int n = Environment.getJBPatchVersionDate();
        String string = Environment.getFirmware();
        return n >= 20130328 && "5.1.0".equals(string);
    }

    protected void initLocalization(String string, Map map) {
        if ("en".equals(string)) {
            map.put("jbpatch.name", "Enable Cover View Mode");
            map.put("jbpatch.description", "This patch allows to switch between the default list mode, and a cover view mode, while browsing the home screen and collections.");
            map.put(UI_NAME, "Default Display Mode");
            map.put(UI_DESC, "Display mode activated when the device starts up.");
            map.put(UI_HINT, "The cover view mode is only available for the Home screen and for displaying collections. It does not apply to other views such as the archive, or search results.");
            map.put(UI_MODE_LIST, "List items");
            map.put(UI_MODE_COVER, "Show covers");
        }
    }

    public PatchMetadata getMetadata() {
        return new PatchMetadata((Patch)this).withClass(new PatchMetadata.PatchableClass(CLASS_U).withChecksums(MD5_U_BEFORE, MD5_U_AFTER)).withClass(new PatchMetadata.PatchableClass(CLASS_J).withChecksums(MD5_J_BEFORE, MD5_J_AFTER)).withClass(new PatchMetadata.PatchableClass(CLASS_MOBI7EXTRACTOR).withChecksums(MD5_MOBI7EXTRACTOR_BEFORE, MD5_MOBI7EXTRACTOR_AFTER)).withClass(new PatchMetadata.PatchableClass(CLASS_HOMEBOOKLET).withChecksums(MD5_HOMEBOOKLET_BEFORE, MD5_HOMEBOOKLET_AFTER));
    }

    public Permission[] getRequiredPermissions() {
        return new Permission[]{new AllPermission()};
    }

    public CoverViewPatch() {
        instance = this;
    }

    public String perform(String string, BCClass bCClass) throws Throwable {
        if (string.equals(MD5_U_BEFORE)) {
            return this.patchMethodL(bCClass);
        }
        if (string.equals(MD5_J_BEFORE)) {
            return this.patchMethodL(bCClass);
        }
        if (string.equals(MD5_HOMEBOOKLET_BEFORE)) {
            return this.patchHomeBooklet(bCClass);
        }
        if (string.equals(MD5_MOBI7EXTRACTOR_BEFORE)) {
            return null;
        }
        return "Unsupported MD5: " + string;
    }

    private String patchMobi7Extractor(BCClass bCClass) throws Exception {
        Code code = bCClass.getDeclaredMethod("D", new String[]{"com.amazon.kindle.content.catalog.MutableItem", "java.lang.String"}).getCode(false);
        code.before(545);
        code.iload().setLocal(11);
        code.aload().setLocal(1);
        code.invokestatic().setMethod(CoverViewPatch.class.getMethod("isInvalidASIN", Boolean.TYPE, Object.class));
        code.istore().setLocal(11);
        return null;
    }

    public static boolean isInvalidASIN(boolean bl, Object object) {
        if (bl) {
            return true;
        }
        MutableItem mutableItem = (MutableItem)object;
        String string = mutableItem.getCDEKey();
        if (string == null || string.length() != 10) {
            return true;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') continue;
            return true;
        }
        return false;
    }

    private String patchMethodL(BCClass bCClass) {
        Code code = bCClass.getDeclaredMethod("L").getCode(false);
        code.beforeFirst();
        ((ConstantInstruction)code.next()).setValue(true);
        return null;
    }

    private String patchHomeBooklet(BCClass bCClass) throws Exception {
        Code code = bCClass.getDeclaredMethod("F").getCode(false);
        code.beforeFirst();
        code.next();
        code.remove();
        code.invokestatic().setMethod(CoverViewPatch.class.getDeclaredMethod("getViewMode", new Class[0]));
        code = bCClass.getDeclaredMethod("H", new Class[]{String.class}).getCode(false);
        code.beforeFirst();
        code.aload().setThis();
        code.aload().setLocal(1);
        code.invokestatic().setMethod(CoverViewPatch.class.getDeclaredMethod("setViewMode", Object.class, String.class));
        code.calculateMaxLocals();
        code.calculateMaxStack();
        code = bCClass.getDeclaredMethod("B", new Class[0]).getCode(false);
        code.beforeFirst();
        code.next();
        code.remove();
        code.invokestatic().setMethod(CoverViewPatch.class.getDeclaredMethod("getViewModeIndex", new Class[0]));
        code.calculateMaxLocals();
        code.calculateMaxStack();
        return null;
    }

    public static void setViewMode(Object object, String string) {
        currentViewMode = string;
        ((HomeBooklet)object).getActiveController().load();
    }

    public static String getViewMode() {
        if (currentViewMode == null) {
            currentViewMode = instance.getConfigured(CONF_KEY);
        }
        return currentViewMode;
    }

    public static int getViewModeIndex() {
        return CoverViewPatch.getViewMode().equals(COVER_VIEW_MODE) ? 1 : 0;
    }

    protected ConfigurableSettings initConfigurableSettings() {
        ConfigurableSettings configurableSettings = new ConfigurableSettings();
        configurableSettings.add((ConfigurableSetting)new CoverViewSetting());
        return configurableSettings;
    }

    private class CoverViewSetting
    extends ConfigurableSetting {
        private final SettingEntry[] entries;

        public CoverViewSetting() {
            super(CoverViewPatch.this.localize(CoverViewPatch.UI_NAME), CoverViewPatch.this.localize(CoverViewPatch.UI_DESC), CoverViewPatch.this.localize(CoverViewPatch.UI_HINT), CoverViewPatch.CONF_KEY, CoverViewPatch.LIST_VIEW_MODE);
            this.entries = new SettingEntry[2];
            this.entries[0] = new SettingEntry(CoverViewPatch.LIST_VIEW_MODE, CoverViewPatch.this.localize(CoverViewPatch.UI_MODE_LIST));
            this.entries[1] = new SettingEntry(CoverViewPatch.COVER_VIEW_MODE, CoverViewPatch.this.localize(CoverViewPatch.UI_MODE_COVER));
        }

        public SettingPanel getPanel(SettingChangeListener settingChangeListener) {
            return new RadioButtonsSettingPanel(settingChangeListener, this.entries);
        }

        public boolean isValid(String string) {
            return CoverViewPatch.LIST_VIEW_MODE.equals(string) || CoverViewPatch.COVER_VIEW_MODE.equals(string);
        }

        public String getLocalized(String string) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (!this.entries[i].key.equals(string)) continue;
                return this.entries[i].displayValue;
            }
            return string;
        }
    }
}

