// Copyright (C) 2010, 2011, 2012 GlavSoft LLC.
// All rights reserved.
//
//-------------------------------------------------------------------------
// This file is part of the TightVNC software.  Please visit our Web site:
//
//                       http://www.tightvnc.com/
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//-------------------------------------------------------------------------
//

package com.glavsoft.rfb.protocol.state;

import java.util.logging.Logger;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;

abstract public class ProtocolState {
	protected ProtocolContext context;
	protected Logger logger;
	protected Reader reader;
	protected Writer writer;

	public ProtocolState(ProtocolContext context) {
		this.context = context;
		this.logger = context.getLogger();
		this.reader = context.getReader();
		this.writer = context.getWriter();
	}

	/**
	 * Change state of finite machine.
	 *
	 * @param state state, the Finite Machine will switched to
	 */
	protected void changeStateTo(ProtocolState state) {
		context.changeStateTo(state);
	}

	/**
	 * Carry out next step of protocol flow.
	 *
	 * @return false when no next protocol steps availabe, true - when need to continue
	 */
	abstract public boolean next() throws UnsupportedProtocolVersionException, TransportException,
			UnsupportedSecurityTypeException, AuthenticationFailedException, FatalException;

}
