#ifndef MYWIDGET_H
#define MYWIDGET_H

#include <QtGui/QtGui>
#include <QObject>

#include "onyx/screen/screen_proxy.h"

#include "qextserialport.h"

class MyWidget : public QWidget {
  Q_OBJECT

  QPixmap *pixmap;
  QByteArray *pixmapByteArray;
  bool imageStartFlag;
  bool imageEndFlag;
  bool debugEnabled;
  QextSerialPort *port;
  QString *debugMessage;

  public:
    MyWidget(QWidget *parent = 0, Qt::WindowType windowType = Qt::FramelessWindowHint) : QWidget(parent, windowType) {
	pixmap = new QPixmap(1024,768);

	port = new QextSerialPort("/dev/ttyGS0");
	connect(port, SIGNAL(readyRead()), this, SLOT(imageDataReady()));
	port->open(QIODevice::ReadOnly | QIODevice::Unbuffered);

	pixmapByteArray = new QByteArray();
	
	imageStartFlag = false;
	imageEndFlag = false;

	debugMessage = new QString("");
	debugEnabled = false;
    }

    ~MyWidget() {};
    void refreshScreen();
    void drawImage();
    bool event(QEvent * event);
    void keyReleaseEvent(QKeyEvent *ke);

  public slots:
    void imageDataReady();

  private:
    void paintEvent(QPaintEvent *e);
};
#endif
