/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import com.glavsoft.viewer.swing.Utils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

public class PasswordDialog
extends JDialog {
    private String password = "";
    private static final int PADDING = 4;
    private final JLabel messageLabel;

    public PasswordDialog(Frame owner, final WindowListener onClose, boolean isApplet) {
        super((Window)owner, "Login", isApplet ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.TOOLKIT_MODAL);
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.addWindowListener(onClose);
        JPanel pane = new JPanel(new GridLayout(0, 1, 4, 4));
        this.add(pane);
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.messageLabel = new JLabel("Server requires password authentication");
        pane.add(this.messageLabel);
        JPanel passwordPanel = new JPanel();
        passwordPanel.add(new JLabel("Password:"));
        final JPasswordField passwordField = new JPasswordField("", 20);
        passwordPanel.add(passwordField);
        pane.add(passwordPanel);
        JPanel buttonPanel = new JPanel();
        JButton loginButton = new JButton("Login");
        buttonPanel.add(loginButton);
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDialog.this.password = new String(passwordField.getPassword());
                PasswordDialog.this.setVisible(false);
            }
        });
        JButton closeButton = new JButton("Close");
        buttonPanel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDialog.this.setVisible(false);
                onClose.windowClosing(null);
            }
        });
        pane.add(buttonPanel);
        this.getRootPane().setDefaultButton(loginButton);
        List<Image> icons = Utils.getIcons();
        if (icons.size() != 0) {
            this.setIconImages(icons);
        }
        Point locationPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.pack();
        Rectangle bounds = this.getBounds();
        locationPoint.setLocation(locationPoint.x - bounds.width / 2, locationPoint.y - bounds.height / 2);
        this.setLocation(locationPoint);
    }

    public void setServerHostName(String serverHostName) {
        this.messageLabel.setText("Server '" + serverHostName + "' requires password authentication");
        this.pack();
    }

    public String getPassword() {
        return this.password;
    }
}

