/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.swing.Utils;
import com.glavsoft.viewer.swing.gui.OptionsDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ConnectionDialog
extends JDialog {
    private static final int PADDING = 4;
    private String serverNameString;
    private int serverPort;

    public ConnectionDialog(JFrame owner, final WindowListener appWindowListener, String serverNameString, int serverPort, final ProtocolSettings settings, boolean isApplet) {
        super((Window)owner, "New TightVNC Connection", isApplet ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.TOOLKIT_MODAL);
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.serverNameString = serverNameString;
        this.serverPort = serverPort;
        JPanel pane = new JPanel(new GridBagLayout());
        this.add(pane);
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridBagLayout());
        GridBagConstraints cServerLabel = new GridBagConstraints();
        cServerLabel.gridx = 0;
        cServerLabel.gridy = 0;
        cServerLabel.weightx = 100.0;
        cServerLabel.weighty = 100.0;
        cServerLabel.gridwidth = 1;
        cServerLabel.gridheight = 1;
        cServerLabel.anchor = 22;
        cServerLabel.ipadx = 4;
        pane.add((Component)new JLabel("TightVNC Server:"), cServerLabel);
        final JTextField serverNameField = new JTextField(null == serverNameString ? "" : serverNameString, 20);
        GridBagConstraints cServerName = new GridBagConstraints();
        cServerName.gridx = 1;
        cServerName.gridy = 0;
        cServerName.weightx = 0.0;
        cServerName.weighty = 100.0;
        cServerName.gridwidth = 1;
        cServerName.gridheight = 1;
        cServerName.anchor = 21;
        pane.add((Component)serverNameField, cServerName);
        GridBagConstraints cPortLabel = new GridBagConstraints();
        cPortLabel.gridx = 0;
        cPortLabel.gridy = 1;
        cPortLabel.weightx = 100.0;
        cPortLabel.weighty = 100.0;
        cPortLabel.gridwidth = 1;
        cPortLabel.gridheight = 1;
        cPortLabel.anchor = 22;
        cPortLabel.ipadx = 4;
        cPortLabel.ipady = 10;
        pane.add((Component)new JLabel("Port:"), cPortLabel);
        GridBagConstraints cPort = new GridBagConstraints();
        cPort.gridx = 1;
        cPort.gridy = 1;
        cPort.weightx = 0.0;
        cPort.weighty = 100.0;
        cPort.gridwidth = 1;
        cPort.gridheight = 1;
        cPort.anchor = 21;
        final JTextField serverPortField = new JTextField(String.valueOf(0 == serverPort ? 5900 : serverPort), 10);
        pane.add((Component)serverPortField, cPort);
        JPanel buttonPanel = new JPanel();
        JButton connectButton = new JButton("Connect");
        buttonPanel.add(connectButton);
        connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.setServerNameString(serverNameField.getText());
                ConnectionDialog.this.setPort(serverPortField.getText());
                if (ConnectionDialog.this.validateFields()) {
                    ConnectionDialog.this.setVisible(false);
                } else {
                    serverNameField.requestFocusInWindow();
                }
            }
        });
        JButton optionsButton = new JButton("Options...");
        buttonPanel.add(optionsButton);
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog od = new OptionsDialog((Window)ConnectionDialog.this);
                od.initControlsFromSettings(settings, true);
                Dialog.ModalityType savedModalityType = ConnectionDialog.this.getModalityType();
                ConnectionDialog.this.setModal(false);
                try {
                    ConnectionDialog.this.setAlwaysOnTop(false);
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                ConnectionDialog.this.setEnabled(false);
                try {
                    od.setAlwaysOnTop(true);
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                od.setModal(true);
                od.setEnabled(true);
                od.setVisible(true);
                try {
                    ConnectionDialog.this.setAlwaysOnTop(true);
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                ConnectionDialog.this.setModalityType(savedModalityType);
                ConnectionDialog.this.setEnabled(true);
            }
        });
        JButton closeButton = new JButton("Close");
        buttonPanel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.setVisible(false);
                appWindowListener.windowClosing(null);
            }
        });
        GridBagConstraints cButtons = new GridBagConstraints();
        cButtons.gridx = 0;
        cButtons.gridy = 2;
        cButtons.weightx = 100.0;
        cButtons.weighty = 100.0;
        cButtons.gridwidth = 2;
        cButtons.gridheight = 1;
        pane.add((Component)buttonPanel, cButtons);
        this.getRootPane().setDefaultButton(connectButton);
        List<Image> icons = Utils.getIcons();
        if (icons.size() != 0) {
            this.setIconImages(icons);
        }
        this.addWindowListener(appWindowListener);
        Point locationPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.pack();
        this.setResizable(false);
        Rectangle bounds = this.getBounds();
        locationPoint.setLocation(locationPoint.x - bounds.width / 2, locationPoint.y - bounds.height / 2);
        this.setLocation(locationPoint);
    }

    protected boolean validateFields() {
        return !Strings.isTrimmedEmpty(this.serverNameString);
    }

    protected void setServerNameString(String text) {
        this.serverNameString = text;
    }

    public String getServerNameString() {
        return this.serverNameString;
    }

    public void setPort(String text) {
        try {
            this.serverPort = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            this.serverPort = 5900;
        }
    }

    public int getPort() {
        return this.serverPort;
    }
}

