/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.rfb.IPasswordRetriever;
import com.glavsoft.rfb.IRfbSessionListener;
import com.glavsoft.rfb.client.KeyEventMessage;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.ConnectionManager;
import com.glavsoft.viewer.ContainerManager;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.swing.ClipboardControllerImpl;
import com.glavsoft.viewer.swing.ModifierButtonEventListener;
import com.glavsoft.viewer.swing.ParametersHandler;
import com.glavsoft.viewer.swing.Surface;
import com.glavsoft.viewer.swing.UiSettings;
import com.glavsoft.viewer.swing.gui.OptionsDialog;
import com.glavsoft.viewer.swing.gui.PasswordDialog;
import gnu.io.NRSerialPort;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class Viewer
extends JApplet
implements Runnable,
IRfbSessionListener,
WindowListener,
IChangeSettingsListener {
    public static final int DEFAULT_PORT = 5900;
    public static Logger logger = Logger.getLogger("com.glavsoft");
    private boolean isZoomToFitSelected;
    private boolean forceReconnection;
    private String reconnectionReason;
    private ContainerManager containerManager;
    private static NRSerialPort serial;
    private static DataOutputStream outs;
    private static Viewer viewer;
    private final ParametersHandler.ConnectionParams connectionParams = new ParametersHandler.ConnectionParams();
    private String passwordFromParams;
    private Socket workingSocket;
    private Protocol workingProtocol;
    private JFrame containerFrame;
    boolean isSeparateFrame = true;
    boolean isApplet = true;
    boolean showControls = true;
    private Surface surface;
    private final ProtocolSettings settings = ProtocolSettings.getDefaultSettings();
    private final UiSettings uiSettings = new UiSettings();
    private boolean tryAgain;
    private boolean isAppletStopped = false;
    private volatile boolean isStoppingProcess;
    private List<JComponent> kbdButtons;

    public Protocol getWorkingProtocol() {
        return this.workingProtocol;
    }

    public boolean isZoomToFitSelected() {
        return this.isZoomToFitSelected;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    public void setZoomToFitSelected(boolean zoomToFitSelected) {
        this.isZoomToFitSelected = zoomToFitSelected;
    }

    private static void initializeSerial() {
        serial = new NRSerialPort(System.getProperty("boox_serial_port"), 115200);
        serial.connect();
        outs = new DataOutputStream(serial.getOutputStream());
    }

    public static synchronized void sendUpdateViaSerial() {
        if (viewer.getSurface() != null) {
            long start = System.currentTimeMillis();
            String pngBytes = viewer.getSurface().getOffscreenImageAsBase64();
            long end = System.currentTimeMillis();
            System.out.println("Time to encode image: " + (end - start) + " ms, size: " + pngBytes.length());
            try {
                outs.write(42);
                outs.write(pngBytes.getBytes());
                outs.write(35);
                outs.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions(parser);
        parser.parse(args);
        if (parser.isSet("help")) {
            Viewer.printUsage(parser.optionsUsage());
            System.exit(0);
        }
        Viewer.initializeSerial();
        viewer = new Viewer(parser);
        SwingUtilities.invokeLater(viewer);
    }

    public static void printUsage(String additional) {
        System.out.println("Usage: java -jar (progfilename) [hostname [port_number]] [Options]\n    or\n java -jar (progfilename) [Options]\n    or\n java -jar (progfilename) -help\n    to view this help\n\nWhere Options are:\n" + additional + "\nOptions format: -optionName=optionValue. Ex. -host=localhost -port=5900 -viewonly=yes\n" + "Both option name and option value are case insensitive.");
    }

    public Viewer() {
    }

    private Viewer(Parser parser) {
        this();
        ParametersHandler.completeSettingsFromCLI(parser, this.connectionParams, this.settings, this.uiSettings);
        this.showControls = ParametersHandler.showControls;
        this.passwordFromParams = parser.getValueFor("password");
        logger.info("TightVNC Viewer version " + Viewer.ver());
        this.isApplet = false;
    }

    @Override
    public void rfbSessionStopped(final String reason) {
        if (this.isStoppingProcess) {
            return;
        }
        this.cleanUpUISessionAndConnection();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Viewer.this.forceReconnection = true;
                Viewer.this.reconnectionReason = reason;
            }
        });
        SwingUtilities.invokeLater(this);
    }

    private synchronized void cleanUpUISessionAndConnection() {
        this.isStoppingProcess = true;
        if (this.workingSocket != null && this.workingSocket.isConnected()) {
            try {
                this.workingSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.containerFrame != null) {
            this.containerFrame.dispose();
            this.containerFrame = null;
        }
        this.isStoppingProcess = false;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e != null && e.getComponent() != null) {
            e.getWindow().setVisible(false);
        }
        this.closeApp();
    }

    private void closeApp() {
        if (this.workingProtocol != null) {
            this.workingProtocol.cleanUpSession();
        }
        this.cleanUpUISessionAndConnection();
        this.tryAgain = false;
        if (this.isApplet) {
            logger.severe("Applet is stopped.");
            this.isAppletStopped = true;
            this.repaint();
        } else {
            System.exit(0);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isAppletStopped) {
            super.paint(g);
        } else {
            this.getContentPane().removeAll();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawString("Disconnected", 10, 20);
        }
    }

    @Override
    public void destroy() {
        this.closeApp();
        super.destroy();
    }

    @Override
    public void init() {
        ParametersHandler.completeSettingsFromApplet(this, this.connectionParams, this.settings, this.uiSettings);
        this.showControls = ParametersHandler.showControls;
        this.isSeparateFrame = ParametersHandler.isSeparateFrame;
        this.passwordFromParams = this.getParameter("password");
        this.isApplet = true;
        this.repaint();
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void start() {
        this.setSurfaceToHandleKbdFocus();
        super.start();
    }

    @Override
    public void run() {
        ConnectionManager connectionManager = new ConnectionManager(this, this.isApplet);
        if (this.forceReconnection) {
            connectionManager.showReconnectDialog("Connection lost", this.reconnectionReason);
            this.forceReconnection = false;
        }
        this.tryAgain = true;
        while (this.tryAgain) {
            this.workingSocket = connectionManager.connectToHost(this.connectionParams, this.settings);
            if (null == this.workingSocket) {
                this.closeApp();
                break;
            }
            logger.info("Connected");
            try {
                this.workingSocket.setTcpNoDelay(true);
                Reader reader = new Reader(this.workingSocket.getInputStream());
                Writer writer = new Writer(this.workingSocket.getOutputStream());
                this.workingProtocol = new Protocol(reader, writer, new PasswordChooser(this.passwordFromParams, this.connectionParams, this.containerFrame, this), this.settings);
                this.workingProtocol.handshake();
                ClipboardControllerImpl clipboardController = new ClipboardControllerImpl(this.workingProtocol, this.settings.getRemoteCharsetName());
                clipboardController.setEnabled(this.settings.isAllowClipboardTransfer());
                this.settings.addListener(clipboardController);
                this.surface = new Surface(this.workingProtocol, this, this.uiSettings.getScaleFactor());
                this.settings.addListener(this);
                this.uiSettings.addListener(this.surface);
                this.containerFrame = this.createContainer();
                connectionManager.setContainerFrame(this.containerFrame);
                this.updateFrameTitle();
                this.workingProtocol.startNormalHandling(this, this.surface, clipboardController);
                this.tryAgain = false;
            }
            catch (UnsupportedProtocolVersionException e) {
                connectionManager.showReconnectDialog("Unsupported Protocol Version", e.getMessage());
                logger.severe(e.getMessage());
            }
            catch (UnsupportedSecurityTypeException e) {
                connectionManager.showReconnectDialog("Unsupported Security Type", e.getMessage());
                logger.severe(e.getMessage());
            }
            catch (AuthenticationFailedException e) {
                this.passwordFromParams = null;
                connectionManager.showReconnectDialog("Authentication Failed", e.getMessage());
                logger.severe(e.getMessage());
            }
            catch (TransportException e) {
                connectionManager.showReconnectDialog("Connection Error", "Connection Error: " + e.getMessage());
                logger.severe(e.getMessage());
            }
            catch (IOException e) {
                connectionManager.showReconnectDialog("Connection Error", "Connection Error: " + e.getMessage());
                logger.severe(e.getMessage());
            }
            catch (FatalException e) {
                connectionManager.showReconnectDialog("Connection Error", "Connection Error: " + e.getMessage());
                logger.severe(e.getMessage());
            }
        }
    }

    private JFrame createContainer() {
        this.containerManager = new ContainerManager(this);
        Container container = this.containerManager.createContainer(this.surface, this.isSeparateFrame, this.isApplet);
        if (this.showControls) {
            this.createButtonsPanel(this.workingProtocol, this.containerManager);
            this.containerManager.registerResizeListener(container);
            this.containerManager.updateZoomButtonsState();
        }
        this.setSurfaceToHandleKbdFocus();
        return this.isSeparateFrame ? (JFrame)container : null;
    }

    public void packContainer() {
        this.containerManager.pack();
    }

    protected void createButtonsPanel(final ProtocolContext context, ContainerManager containerManager) {
        ContainerManager.ButtonsBar buttonsBar = containerManager.createButtonsBar();
        buttonsBar.createButton("options", "Set Options", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.showOptionsDialog();
                Viewer.this.setSurfaceToHandleKbdFocus();
            }
        });
        buttonsBar.createButton("info", "Show connection info", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.showConnectionInfoMessage(context.getRemoteDesktopName());
                Viewer.this.setSurfaceToHandleKbdFocus();
            }
        });
        buttonsBar.createStrut();
        buttonsBar.createButton("refresh", "Refresh screen", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                context.sendRefreshMessage();
                Viewer.this.setSurfaceToHandleKbdFocus();
            }
        });
        containerManager.addZoomButtons();
        this.kbdButtons = new LinkedList<JComponent>();
        buttonsBar.createStrut();
        JButton ctrlAltDelButton = buttonsBar.createButton("ctrl-alt-del", "Send 'Ctrl-Alt-Del'", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.sendCtrlAltDel(context);
                Viewer.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(ctrlAltDelButton);
        JButton winButton = buttonsBar.createButton("win", "Send 'Win' key as 'Ctrl-Esc'", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.sendWinKey(context);
                Viewer.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(winButton);
        JToggleButton ctrlButton = buttonsBar.createToggleButton("ctrl", "Ctrl Lock", new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    context.sendMessage(new KeyEventMessage(65507, true));
                } else {
                    context.sendMessage(new KeyEventMessage(65507, false));
                }
                Viewer.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(ctrlButton);
        JToggleButton altButton = buttonsBar.createToggleButton("alt", "Alt Lock", new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    context.sendMessage(new KeyEventMessage(65513, true));
                } else {
                    context.sendMessage(new KeyEventMessage(65513, false));
                }
                Viewer.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(altButton);
        ModifierButtonEventListener modifierButtonListener = new ModifierButtonEventListener();
        modifierButtonListener.addButton(17, ctrlButton);
        modifierButtonListener.addButton(18, altButton);
        this.surface.addModifierListener(modifierButtonListener);
        buttonsBar.createStrut();
        buttonsBar.createButton("close", this.isApplet ? "Disconnect" : "Close", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.closeApp();
            }
        }).setAlignmentX(1.0f);
        containerManager.setButtonsBarVisible(true);
    }

    void updateFrameTitle() {
        if (this.containerFrame != null) {
            this.containerFrame.setTitle(this.workingProtocol.getRemoteDesktopName() + " [zoom: " + this.uiSettings.getScalePercentFormatted() + "%]");
        }
    }

    protected void setSurfaceToHandleKbdFocus() {
        if (this.surface != null && !this.surface.requestFocusInWindow()) {
            this.surface.requestFocus();
        }
    }

    @Override
    public void settingsChanged(SettingsChangedEvent e) {
        ProtocolSettings settings = (ProtocolSettings)e.getSource();
        this.setEnabledKbdButtons(!settings.isViewOnly());
    }

    private void setEnabledKbdButtons(boolean enabled) {
        if (this.kbdButtons != null) {
            for (JComponent b : this.kbdButtons) {
                b.setEnabled(enabled);
            }
        }
    }

    private void showOptionsDialog() {
        OptionsDialog optionsDialog = new OptionsDialog((Window)this.containerFrame);
        optionsDialog.initControlsFromSettings(this.settings, false);
        optionsDialog.setVisible(true);
    }

    private void showConnectionInfoMessage(String title) {
        StringBuilder message = new StringBuilder();
        message.append("Connected to: ").append(title).append("\n");
        message.append("Host: ").append(this.connectionParams.hostName).append(" Port: ").append(this.connectionParams.portNumber).append("\n\n");
        message.append("Desktop geometry: ").append(String.valueOf(this.surface.getWidth())).append(" \u00d7 ").append(String.valueOf(this.surface.getHeight())).append("\n");
        message.append("Color format: ").append(String.valueOf(Math.round(Math.pow(2.0, this.workingProtocol.getPixelFormat().depth)))).append(" colors (").append(String.valueOf(this.workingProtocol.getPixelFormat().depth)).append(" bits)\n");
        message.append("Current protocol version: ").append(this.settings.getProtocolVersion());
        if (this.settings.isTight()) {
            message.append("tight");
        }
        message.append("\n");
        JOptionPane infoPane = new JOptionPane(message.toString(), 1);
        JDialog infoDialog = infoPane.createDialog(this.containerFrame, "VNC connection info");
        infoDialog.setModalityType(Dialog.ModalityType.MODELESS);
        try {
            infoDialog.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        infoDialog.setVisible(true);
    }

    private void sendCtrlAltDel(ProtocolContext context) {
        context.sendMessage(new KeyEventMessage(65507, true));
        context.sendMessage(new KeyEventMessage(65513, true));
        context.sendMessage(new KeyEventMessage(65535, true));
        context.sendMessage(new KeyEventMessage(65535, false));
        context.sendMessage(new KeyEventMessage(65513, false));
        context.sendMessage(new KeyEventMessage(65507, false));
    }

    private void sendWinKey(ProtocolContext context) {
        context.sendMessage(new KeyEventMessage(65507, true));
        context.sendMessage(new KeyEventMessage(65307, true));
        context.sendMessage(new KeyEventMessage(65307, false));
        context.sendMessage(new KeyEventMessage(65507, false));
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private static String ver() {
        InputStream mfStream = Viewer.class.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        if (null == mfStream) {
            System.out.println("No Manifest file found.");
            return "-1";
        }
        try {
            Manifest mf = new Manifest();
            mf.read(mfStream);
            Attributes atts = mf.getMainAttributes();
            return atts.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (IOException e) {
            return "-2";
        }
    }

    private class PasswordChooser
    implements IPasswordRetriever {
        private final String passwordPredefined;
        private final ParametersHandler.ConnectionParams connectionParams;
        PasswordDialog passwordDialog;
        private final JFrame owner;
        private final WindowListener onClose;

        private PasswordChooser(String passwordPredefined, ParametersHandler.ConnectionParams connectionParams, JFrame owner, WindowListener onClose) {
            this.passwordPredefined = passwordPredefined;
            this.connectionParams = connectionParams;
            this.owner = owner;
            this.onClose = onClose;
        }

        @Override
        public String getPassword() {
            return Strings.isTrimmedEmpty(this.passwordPredefined) ? this.getPasswordFromGUI() : this.passwordPredefined;
        }

        private String getPasswordFromGUI() {
            if (null == this.passwordDialog) {
                this.passwordDialog = new PasswordDialog((Frame)this.owner, this.onClose, Viewer.this.isApplet);
            }
            this.passwordDialog.setServerHostName(this.connectionParams.hostName);
            this.passwordDialog.setVisible(true);
            return this.passwordDialog.getPassword();
        }
    }
}

