/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.viewer.Viewer;
import com.glavsoft.viewer.swing.ParametersHandler;
import com.glavsoft.viewer.swing.Utils;
import com.glavsoft.viewer.swing.gui.ConnectionDialog;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConnectionManager
implements Serializable {
    private final WindowListener appWindowListener;
    volatile boolean forceConnectionDialog;
    private JFrame containerFrame;
    private final boolean isApplet;

    public ConnectionManager(WindowListener appWindowListener, boolean isApplet) {
        this.appWindowListener = appWindowListener;
        this.isApplet = isApplet;
    }

    protected void showReconnectDialog(String title, String message) {
        JOptionPane reconnectPane = new JOptionPane(message + "\nTry another connection?", 3, 0);
        JDialog reconnectDialog = reconnectPane.createDialog(this.containerFrame, title);
        reconnectDialog.setModalityType(this.isApplet ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.TOOLKIT_MODAL);
        try {
            reconnectDialog.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        List<Image> icons = Utils.getIcons();
        if (icons.size() != 0) {
            reconnectDialog.setIconImages(icons);
        }
        reconnectDialog.setVisible(true);
        if (reconnectPane.getValue() == null || (Integer)reconnectPane.getValue() == 1) {
            this.appWindowListener.windowClosing(null);
        } else {
            this.forceConnectionDialog = !this.isApplet;
        }
    }

    Socket connectToHost(ParametersHandler.ConnectionParams connectionParams, ProtocolSettings settings) {
        Socket socket = null;
        Dialog connectionDialog = null;
        boolean wasError = false;
        do {
            if (this.forceConnectionDialog || wasError || connectionParams.isHostNameEmpty() || -1 == connectionParams.portNumber) {
                this.forceConnectionDialog = false;
                if (null == connectionDialog) {
                    connectionDialog = new ConnectionDialog(this.containerFrame, this.appWindowListener, connectionParams.hostName, connectionParams.portNumber, settings, this.isApplet);
                }
                connectionDialog.setVisible(true);
                connectionParams.hostName = ((ConnectionDialog)connectionDialog).getServerNameString();
                connectionParams.portNumber = ((ConnectionDialog)connectionDialog).getPort();
            }
            Viewer.logger.info("Connecting to host " + connectionParams.hostName + ":" + connectionParams.portNumber);
            try {
                socket = new Socket(connectionParams.hostName, connectionParams.portNumber);
                wasError = false;
            }
            catch (UnknownHostException e) {
                Viewer.logger.severe("Unknown host: " + connectionParams.hostName);
                this.showConnectionErrorDialog("Unknown host: '" + connectionParams.hostName + "'");
                wasError = true;
            }
            catch (IOException e) {
                Viewer.logger.severe("Couldn't connect to: " + connectionParams.hostName + ":" + connectionParams.portNumber + ": " + e.getMessage());
                this.showConnectionErrorDialog("Couldn't connect to: '" + connectionParams.hostName + "'\n" + e.getMessage());
                wasError = true;
            }
        } while (!this.isApplet && (connectionParams.isHostNameEmpty() || wasError));
        if (connectionDialog != null) {
            connectionDialog.dispose();
        }
        return socket;
    }

    public void showConnectionErrorDialog(String message) {
        JOptionPane errorPane = new JOptionPane(message, 0);
        JDialog errorDialog = errorPane.createDialog(this.containerFrame, "Connection error");
        errorDialog.setModalityType(this.isApplet ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.TOOLKIT_MODAL);
        try {
            errorDialog.setAlwaysOnTop(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        errorDialog.setVisible(true);
    }

    public void setContainerFrame(JFrame containerFrame) {
        this.containerFrame = containerFrame;
    }
}

